/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.tdm.CatalogConfigReader;
import thredds.tdm.GCpass1;
import thredds.util.ThreddsConfigReader;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.util.AliasTranslator;
import ucar.nc2.util.Counters;
import ucar.nc2.util.DiskCache2;

public class GCsummary {
    private static Logger log = LoggerFactory.getLogger(GCsummary.class);
    private static final boolean debug = false;
    private static final boolean debugOpenFiles = false;
    private Path contentDir;
    private Path contentThreddsDir;
    private Path contentTdmDir;
    private Path threddsConfig;
    private ExecutorService executor;
    private Resource catalog;
    private boolean showOnly = false;
    List<Resource> catalogRoots = new ArrayList<Resource>();
    Map<String, GCsummaryTask> fcMap = new TreeMap<String, GCsummaryTask>();

    public void setContentDir(String contentDir) throws IOException {
        System.out.printf("contentDir=%s%n", contentDir);
        this.contentDir = Paths.get(contentDir, new String[0]);
        this.contentThreddsDir = Paths.get(contentDir, "thredds");
        this.threddsConfig = Paths.get(contentDir, "thredds", "threddsConfig.xml");
        this.contentTdmDir = Paths.get(contentDir, "tdm");
        this.catalog = new FileSystemResource(this.contentThreddsDir.toString() + "/catalog.xml");
    }

    public void setShowOnly(boolean showOnly) {
        this.showOnly = showOnly;
    }

    public void setNThreads(int n) {
        this.executor = Executors.newFixedThreadPool(n);
        log.info(" TDM nthreads= {}", (Object)n);
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setCatalog(String catalog) throws IOException {
        this.catalog = new FileSystemResource(this.contentThreddsDir.toString() + "/" + catalog);
        System.out.printf("use catalog=%s%n", this.catalog.getFile().getPath());
    }

    boolean init() {
        System.setProperty("tds.log.dir", this.contentTdmDir.toString());
        if (!Files.exists(this.threddsConfig, new LinkOption[0])) {
            log.error("config file {} does not exist, set -Dtds.content.root.path=<dir>", (Object)this.threddsConfig);
            System.out.printf("threddsConfig does not exist=%s%n", this.threddsConfig);
            return false;
        }
        ThreddsConfigReader reader = new ThreddsConfigReader(this.threddsConfig.toString(), log);
        for (String location : reader.getRootList("catalogRoot")) {
            FileSystemResource r = new FileSystemResource(this.contentThreddsDir.toString() + "/" + location);
            this.catalogRoots.add((Resource)r);
        }
        String gribIndexDir = reader.get("GribIndex.dir", new File(this.contentThreddsDir.toString(), "cache/grib/").getPath());
        Boolean gribIndexAlwaysUse = reader.getBoolean("GribIndex.alwaysUse", false);
        Boolean gribIndexNeverUse = reader.getBoolean("GribIndex.neverUse", false);
        String gribIndexPolicy = reader.get("GribIndex.policy", null);
        DiskCache2 gribCache = gribIndexNeverUse != false ? DiskCache2.getNoop() : new DiskCache2(gribIndexDir, false, -1, -1);
        gribCache.setPolicy(gribIndexPolicy);
        gribCache.setAlwaysUseCache(gribIndexAlwaysUse.booleanValue());
        gribCache.setNeverUseCache(gribIndexNeverUse.booleanValue());
        GribIndexCache.setDiskCache2((DiskCache2)gribCache);
        log.info("TDM set " + gribCache);
        return true;
    }

    void start() throws IOException {
        System.out.printf("GCsummary startup at %s%n", new Date());
        ArrayList<FeatureCollectionConfig> fcList = new ArrayList<FeatureCollectionConfig>();
        CatalogConfigReader reader = new CatalogConfigReader(this.contentThreddsDir, this.catalog);
        fcList.addAll(reader.getFcList());
        for (Resource resource : this.catalogRoots) {
            CatalogConfigReader r = new CatalogConfigReader(this.contentThreddsDir, resource);
            fcList.addAll(r.getFcList());
        }
        if (this.showOnly) {
            ArrayList<String> result = new ArrayList<String>();
            for (FeatureCollectionConfig config : fcList) {
                result.add(config.collectionName);
            }
            Collections.sort(result);
            System.out.printf("%nFeature Collection names:%n", new Object[0]);
            for (String name : result) {
                System.out.printf(" %s%n", name);
            }
            this.executor.shutdown();
            return;
        }
        for (FeatureCollectionConfig featureCollectionConfig : fcList) {
            if (featureCollectionConfig.type != FeatureCollectionType.GRIB1 && featureCollectionConfig.type != FeatureCollectionType.GRIB2) continue;
            System.out.printf(" FeatureCollection scheduled %s == %s %n", featureCollectionConfig.collectionName, featureCollectionConfig.spec);
            GCsummaryTask task = new GCsummaryTask(featureCollectionConfig);
            this.fcMap.put(featureCollectionConfig.getCollectionName(), task);
            this.executor.execute(task);
        }
    }

    public void finish() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            System.out.printf("Interupted%n", new Object[0]);
        }
        System.out.printf("Finished All tasks%n", new Object[0]);
        GCpass1.Accum all = new GCpass1.Accum();
        long tookAll = 0L;
        Formatter f = new Formatter();
        f.format("%40s,  type, ptype,    took,  nfiles, nrecords,  idx(MB), data(GB), data/idx, bytes/rec, variables, runtimes, gds %n", "Collection");
        for (GCsummaryTask task : this.fcMap.values()) {
            f.format("%40s, %5s, %5s, %8d,", task.config.collectionName, task.config.type, task.config.ptype, task.took);
            GCpass1.Accum acc = task.pass1.accumAll;
            f.format("%8d, %8d, %8.3f, %8.3f, ", acc.nfiles, acc.nrecords, Float.valueOf(acc.indexSize), Float.valueOf(acc.fileSize / 1000.0f));
            f.format("%8.3f, %8.0f,", Float.valueOf(acc.fileSize / acc.indexSize), Float.valueOf(acc.indexSize * 1000.0f * 1000.0f / (float)acc.nrecords));
            Counters counters = task.pass1.countersAll;
            f.format("%8d,", counters.get("variable").getUnique());
            f.format("%8d,", counters.get("referenceDate").getUnique());
            f.format("%8d,", counters.get("gds").getUnique());
            f.format("%n", new Object[0]);
            all.add(acc);
            tookAll += task.took;
        }
        f.format("%n", new Object[0]);
        f.format("%40s, %5s, %5s, %8d,", "total", "", "", tookAll);
        f.format("%8d, %8d, %8.3f, %8.3f, ", all.nfiles, all.nrecords, Float.valueOf(all.indexSize), Float.valueOf(all.fileSize / 1000.0f));
        f.format("%8.3f, %8.0f", Float.valueOf(all.fileSize / all.indexSize), Float.valueOf(all.indexSize * 1000.0f * 1000.0f / (float)all.nrecords));
        f.format("%n", new Object[0]);
        System.out.printf("%s%n", f);
        try (FileOutputStream fileOut = new FileOutputStream("GCsummary.csv");){
            fileOut.write(f.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        block25: {
            try (FileSystemXmlApplicationContext springContext = new FileSystemXmlApplicationContext("classpath:resources/application-config.xml");){
                CommandLine cmdLine;
                String progName;
                GCsummary app;
                block24: {
                    app = (GCsummary)springContext.getBean("GCsummary");
                    Map aliases = (Map)springContext.getBean("dataRootLocationAliasExpanders");
                    for (Map.Entry entry : aliases.entrySet()) {
                        AliasTranslator.addAlias((String)((String)entry.getKey()), (String)((String)entry.getValue()));
                    }
                    progName = GCsummary.class.getName();
                    cmdLine = new CommandLine(progName, args);
                    if (!cmdLine.help) break block24;
                    cmdLine.printUsage();
                    return;
                }
                try {
                    String contentDir = System.getProperty("tds.content.root.path");
                    if (contentDir == null) {
                        contentDir = "../content";
                    }
                    app.setContentDir(contentDir);
                    if (cmdLine.catalog != null) {
                        app.setCatalog(cmdLine.catalog);
                    }
                    if (cmdLine.nthreads != 0) {
                        app.setNThreads(cmdLine.nthreads);
                    }
                    if (cmdLine.showOnly) {
                        app.setShowOnly(true);
                    }
                    if (app.init()) {
                        app.start();
                        app.finish();
                        System.exit(0);
                        break block25;
                    }
                    System.out.printf("%nEXIT DUE TO ERRORS", new Object[0]);
                }
                catch (ParameterException e) {
                    System.err.println(e.getMessage());
                    System.err.printf("Try \"%s --help\" for more information.%n", progName);
                }
            }
        }
    }

    private static class CommandLine {
        @Parameter(names={"-catalog"}, description="specific catalog", required=false)
        public String catalog;
        @Parameter(names={"-nthreads"}, description="number of threads", required=false)
        public int nthreads;
        @Parameter(names={"-showOnly"}, description="show collections and exit", required=false)
        public boolean showOnly;
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public boolean help = false;
        private final JCommander jc = new JCommander((Object)this);

        public CommandLine(String progName, String[] args) throws ParameterException {
            this.jc.parse(args);
            this.jc.setProgramName(progName);
        }

        public void printUsage() {
            this.jc.usage();
        }
    }

    private class GCsummaryTask
    implements Runnable {
        String name;
        FeatureCollectionConfig config;
        GCpass1 pass1;
        long took;

        private GCsummaryTask(FeatureCollectionConfig config) {
            this.name = config.collectionName;
            this.config = config;
        }

        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                String fileOutName = this.config.collectionName + ".GCsummary.txt";
                try (FileOutputStream fileOut = new FileOutputStream(fileOutName);){
                    System.out.printf("GCsummaryTask %s started write to %s%n", this.name, fileOutName);
                    Formatter f = new Formatter(fileOut);
                    this.pass1 = new GCpass1(this.config, f);
                    this.pass1.scanAndReport();
                    f.flush();
                    fileOut.flush();
                }
                this.took = (System.currentTimeMillis() - start) / 1000L;
                System.out.printf(" GCsummaryTask %s finished in %d secs%n", this.name, this.took);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

