/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import java.net.URI;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.tdm.Tdm;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPSession;

public class TriggerableServer {
    private static final Logger tdmLogger = LoggerFactory.getLogger(Tdm.class);
    static final String REMOTE_API_PATH = "/admin/collection/";
    static final String LOCAL_API_PATH = "/local/collection/";
    static final String DEFAULT_CONTEXT = "/thredds";
    static final String PARTIAL_TRIGGER_QUERY = "trigger=never&collection=";
    private final String url;
    final String name;
    final URI uri;
    final HTTPSession session;
    final String apiPath;
    final boolean local;

    private TriggerableServer(String url, String user, String pass) throws HTTPException {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        URI tmpURI = URI.create(this.url);
        this.local = tmpURI.getHost().equals("localhost");
        String tmpName = tmpURI.getHost();
        if (tmpURI.getPort() > 0) {
            tmpName = String.format("%s:%s", tmpName, tmpURI.getPort());
        }
        this.name = tmpName;
        String context = tmpURI.getPath().isEmpty() ? DEFAULT_CONTEXT : tmpURI.getPath();
        this.apiPath = this.local ? LOCAL_API_PATH : REMOTE_API_PATH;
        this.uri = tmpURI.resolve(context + "/" + this.apiPath).normalize();
        HTTPSession httpSession = HTTPFactory.newSession((String)url);
        if (!this.local) {
            if (user != null && pass != null) {
                UsernamePasswordCredentials bp = new UsernamePasswordCredentials(user, pass);
                BasicCredentialsProvider bcp = new BasicCredentialsProvider();
                bcp.setCredentials(AuthScope.ANY, (Credentials)bp);
                httpSession.setCredentialsProvider((CredentialsProvider)bcp);
            } else {
                throw new IllegalStateException("Credentials required for sending triggers to non-local server. Exiting.");
            }
        }
        this.session = httpSession;
        String serverProximity = this.local ? "Local" : "Remote";
        System.out.printf("%s Server added %s%n", serverProximity, url);
        tdmLogger.info("{} TDS server added {}", (Object)serverProximity, (Object)url);
    }

    public String getCollectionTrigger(String collectionName) {
        String basePath = this.uri.getPath();
        String pathAndQuery = String.format("%s/trigger?%s%s", basePath, PARTIAL_TRIGGER_QUERY, collectionName);
        return this.uri.resolve(pathAndQuery).normalize().toString();
    }

    public static class ServerBuilder {
        String url;
        String user;
        String pass;

        public static ServerBuilder create(String name) {
            return new ServerBuilder(name);
        }

        private ServerBuilder(String url) {
            this.url = url;
        }

        public ServerBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ServerBuilder pass(String pass) {
            this.pass = pass;
            return this;
        }

        public TriggerableServer build() throws HTTPException {
            return new TriggerableServer(this.url, this.user, this.pass);
        }
    }
}

