/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import thredds.inventory.TimedCollection;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class CompositePointCollection
extends PointCollectionImpl
implements UpdateableCollection {
    private TimedCollection pointCollections;
    protected List<VariableSimpleIF> dataVariables;
    protected List<Attribute> globalAttributes;

    protected CompositePointCollection(String name, DateUnit timeUnit, String altUnits, TimedCollection pointCollections) throws IOException {
        super(name, timeUnit, altUnits);
        this.pointCollections = pointCollections;
    }

    private void readMetadata() {
        TimedCollection.Dataset td = this.pointCollections.getPrototype();
        if (td == null) {
            throw new RuntimeException("No datasets in the collection");
        }
        Formatter errlog = new Formatter();
        FeatureDataset openDataset = null;
        try {
            openDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.POINT, td.getLocation(), null, errlog);
            if (openDataset != null) {
                this.dataVariables = openDataset.getDataVariables();
                this.globalAttributes = openDataset.getGlobalAttributes();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (openDataset != null) {
                    openDataset.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public List<VariableSimpleIF> getDataVariables() {
        if (this.dataVariables == null) {
            this.readMetadata();
        }
        return this.dataVariables;
    }

    public List<Attribute> getGlobalAttributes() {
        if (this.globalAttributes == null) {
            this.readMetadata();
        }
        return this.globalAttributes;
    }

    @Override
    public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        if (dateRange == null && boundingBox == null) {
            return this;
        }
        if (dateRange == null) {
            return new PointCollectionImpl.PointCollectionSubset(this, boundingBox, null);
        }
        CompositePointCollection dateSubset = new CompositePointCollection(this.name, this.getTimeUnit(), this.getAltUnits(), this.pointCollections.subset(dateRange));
        return new PointCollectionImpl.PointCollectionSubset(dateSubset, boundingBox, dateRange);
    }

    @Override
    public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
        CompositePointFeatureIterator iter = new CompositePointFeatureIterator();
        if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
            iter.setCalculateBounds(this);
        }
        return iter;
    }

    @Override
    public void update() throws IOException {
        this.pointCollections.update();
    }

    private class CompositePointFeatureIteratorMultithreaded
    extends PointIteratorAbstract {
        private boolean finished = false;
        private int bufferSize = -1;
        private Iterator<TimedCollection.Dataset> iter;
        private FeatureDatasetPoint currentDataset;
        private PointFeatureIterator pfIter = null;

        CompositePointFeatureIteratorMultithreaded() {
            this.iter = CompositePointCollection.this.pointCollections.getDatasets().iterator();
        }

        private PointFeatureIterator getNextIterator() throws IOException {
            if (!this.iter.hasNext()) {
                return null;
            }
            TimedCollection.Dataset td = this.iter.next();
            Formatter errlog = new Formatter();
            this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.POINT, td.getLocation(), null, errlog);
            if (CompositeDatasetFactory.debug) {
                System.out.printf("CompositePointFeatureIterator open dataset %s%n", td.getLocation());
            }
            List<FeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
            PointFeatureCollection pc = (PointFeatureCollection)fcList.get(0);
            return pc.getPointFeatureIterator(this.bufferSize);
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.pfIter == null) {
                this.pfIter = this.getNextIterator();
                if (this.pfIter == null) {
                    this.finish();
                    return false;
                }
            }
            if (!this.pfIter.hasNext()) {
                this.pfIter.finish();
                this.currentDataset.close();
                this.pfIter = this.getNextIterator();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public PointFeature next() throws IOException {
            return this.pfIter.next();
        }

        @Override
        public void finish() {
            if (this.finished) {
                return;
            }
            if (this.pfIter != null) {
                this.pfIter.finish();
            }
            this.finishCalcBounds();
            if (this.currentDataset != null) {
                try {
                    this.currentDataset.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.finished = true;
        }

        @Override
        public void setBufferSize(int bytes) {
            this.bufferSize = bytes;
        }
    }

    private class CompositePointFeatureIterator
    extends PointIteratorAbstract {
        private boolean finished = false;
        private int bufferSize = -1;
        private Iterator<TimedCollection.Dataset> iter;
        private FeatureDatasetPoint currentDataset;
        private PointFeatureIterator pfIter = null;

        CompositePointFeatureIterator() {
            this.iter = CompositePointCollection.this.pointCollections.getDatasets().iterator();
        }

        private PointFeatureIterator getNextIterator() throws IOException {
            if (!this.iter.hasNext()) {
                return null;
            }
            TimedCollection.Dataset td = this.iter.next();
            Formatter errlog = new Formatter();
            this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.POINT, td.getLocation(), null, errlog);
            if (CompositeDatasetFactory.debug) {
                System.out.printf("CompositePointFeatureIterator open dataset %s%n", td.getLocation());
            }
            List<FeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
            PointFeatureCollection pc = (PointFeatureCollection)fcList.get(0);
            return pc.getPointFeatureIterator(this.bufferSize);
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.pfIter == null) {
                this.pfIter = this.getNextIterator();
                if (this.pfIter == null) {
                    this.finish();
                    return false;
                }
            }
            if (!this.pfIter.hasNext()) {
                this.pfIter.finish();
                if (CompositeDatasetFactory.debug) {
                    System.out.printf("CompositePointFeatureIterator open dataset %s%n", this.currentDataset.getLocation());
                }
                this.currentDataset.close();
                this.pfIter = this.getNextIterator();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public PointFeature next() throws IOException {
            return this.pfIter.next();
        }

        @Override
        public void finish() {
            if (this.finished) {
                return;
            }
            if (this.pfIter != null) {
                this.pfIter.finish();
            }
            this.finishCalcBounds();
            if (this.currentDataset != null) {
                try {
                    this.currentDataset.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.finished = true;
        }

        @Override
        public void setBufferSize(int bytes) {
            this.bufferSize = bytes;
        }
    }
}

