/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil2;

public class LoggerFactorySpecial
implements ucar.nc2.util.log.LoggerFactory {
    private static Logger startupLog = LoggerFactory.getLogger("serverStartup");
    private static Map<String, Logger> map = new HashMap<String, Logger>();
    private String dir = "./";
    private long maxSize;
    private int maxBackups;
    private Level level = Level.INFO;

    public LoggerFactorySpecial(long maxSize, int maxBackups, String levels) {
        String p = System.getProperty("tds.log.dir");
        if (p != null) {
            this.dir = p;
        }
        this.maxSize = maxSize;
        this.maxBackups = maxBackups;
        try {
            Level tlevel = Level.toLevel(levels);
            if (tlevel != null) {
                this.level = tlevel;
            }
        }
        catch (Exception e) {
            startupLog.error("Illegal Logger level=" + levels);
        }
    }

    @Override
    public Logger getLogger(String name) {
        Logger result = map.get(name = StringUtil2.replace(name.trim(), ' ', "_"));
        if (result != null) {
            return result;
        }
        try {
            String fileName = this.dir + "/" + name + ".log";
            String fileNamePattern = this.dir + "/" + name + "%i.log";
            NullConfiguration config = new NullConfiguration();
            PatternLayout layout = PatternLayout.createLayout("%d{yyyy-MM-dd'T'HH:mm:ss.SSS Z} %-5p - %m%n", null, config, null, null, true, false, null, null);
            DefaultRolloverStrategy.createStrategy(Integer.toString(this.maxBackups), "1", "max", null, null, true, config);
            RollingFileAppender app = RollingFileAppender.createAppender(fileName, fileNamePattern, "true", name, "true", null, "true", SizeBasedTriggeringPolicy.createPolicy(Long.toString(this.maxSize)), DefaultRolloverStrategy.createStrategy(Integer.toString(this.maxBackups), "1", "max", null, null, true, config), layout, null, "true", "false", null, config);
            app.start();
            org.apache.logging.log4j.core.Logger log4j = (org.apache.logging.log4j.core.Logger)LogManager.getLogger(name);
            log4j.addAppender(app);
            log4j.setLevel(this.level);
            log4j.setAdditive(false);
            startupLog.info("LoggerFactorySpecial add logger= {} file= {}", (Object)name, (Object)fileName);
            result = LoggerFactory.getLogger(name);
            map.put(name, result);
            return result;
        }
        catch (Throwable ioe) {
            startupLog.error("LoggerFactorySpecial failed on " + name, ioe);
            return LoggerFactory.getLogger(name);
        }
    }
}

