/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDuration;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

public class InvDatasetImpl
extends InvDataset {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetImpl.class);
    private String urlPath;
    private String alias;
    private double size = 0.0;
    private List<InvAccess> accessLocal = new ArrayList<InvAccess>();
    private List<InvService> servicesLocal = new ArrayList<InvService>();
    protected ThreddsMetadata tm = new ThreddsMetadata(false);
    protected ThreddsMetadata tmi = new ThreddsMetadata(true);
    protected Element ncmlElement;
    protected StringBuilder log = new StringBuilder();
    protected boolean mark = false;
    private boolean debugInherit = false;
    private boolean debugInherit2 = false;
    private HashMap<Object, Object> userMap = null;
    private volatile int hashCode = 0;

    public InvDatasetImpl(InvDatasetImpl parent, String name, FeatureType dataType, String serviceName, String urlPath) {
        super(parent, name);
        this.tm.setDataType(dataType);
        this.tm.setServiceName(serviceName);
        this.urlPath = urlPath;
    }

    public boolean finish() {
        boolean ok = true;
        if (this.debugInherit) {
            System.out.println("Now finish " + this.getName() + " id= " + this.getID());
        }
        this.authorityName = null;
        this.dataType = null;
        this.dataFormatType = null;
        this.defaultService = null;
        this.gc = null;
        this.tc = null;
        this.docs = new ArrayList();
        this.metadata = new ArrayList();
        this.properties = new ArrayList();
        this.creators = new ArrayList();
        this.contributors = new ArrayList();
        this.dates = new ArrayList();
        this.keywords = new ArrayList();
        this.projects = new ArrayList();
        this.publishers = new ArrayList();
        this.variables = new ArrayList();
        this.canonicalize();
        this.transfer2PublicMetadata(this.tm, true);
        this.transfer2PublicMetadata(this.tmi, true);
        this.transferInheritable2PublicMetadata((InvDatasetImpl)this.getParent());
        this.access = new ArrayList();
        if (this.urlPath != null && this.getServiceDefault() != null) {
            InvAccessImpl invAccessImpl = new InvAccessImpl(this, this.urlPath, this.getServiceDefault());
            invAccessImpl.setSize(this.size);
            invAccessImpl.finish();
            this.addExpandedAccess(invAccessImpl);
        }
        for (InvAccessImpl invAccessImpl : this.accessLocal) {
            invAccessImpl.finish();
            this.addExpandedAccess(invAccessImpl);
        }
        if (!(this instanceof InvCatalogRef)) {
            for (InvDataset invDataset : this.getDatasets()) {
                InvDatasetImpl curDs = (InvDatasetImpl)invDataset;
                ok &= curDs.finish();
            }
        }
        return ok;
    }

    private void transferInheritable2PublicMetadata(InvDatasetImpl parent) {
        if (parent == null) {
            return;
        }
        if (this.debugInherit) {
            System.out.println(" inheritFromParent= " + parent.getID());
        }
        this.transfer2PublicMetadata(parent.getLocalMetadataInheritable(), true);
        this.transferInheritable2PublicMetadata((InvDatasetImpl)parent.getParent());
    }

    private void transfer2PublicMetadata(ThreddsMetadata tmd, boolean inheritAll) {
        DateRange ttc;
        ThreddsMetadata.GeospatialCoverage tgc;
        if (tmd == null) {
            return;
        }
        if (this.debugInherit) {
            System.out.println("  transferMetadata " + tmd);
        }
        if (this.authorityName == null) {
            this.authorityName = tmd.getAuthority();
        }
        if (this.dataType == null || this.dataType == FeatureType.ANY || this.dataType == FeatureType.NONE) {
            this.dataType = tmd.getDataType();
        }
        if (this.dataFormatType == null || this.dataFormatType == DataFormatType.NONE) {
            this.dataFormatType = tmd.getDataFormatType();
        }
        if (this.defaultService == null) {
            this.defaultService = this.findService(tmd.getServiceName());
        }
        if (this.gc == null && (tgc = tmd.getGeospatialCoverage()) != null && !tgc.isEmpty()) {
            this.gc = tgc;
        }
        if (this.tc == null && (ttc = tmd.getTimeCoverage()) != null) {
            this.tc = ttc;
        }
        if (this.tc == null) {
            this.tc = tmd.getTimeCoverage();
        }
        for (InvProperty item : tmd.getProperties()) {
            if (this.properties.contains(item)) continue;
            if (this.debugInherit) {
                System.out.println("  add Property " + item + " to " + this.getID());
            }
            this.properties.add(item);
        }
        this.creators.addAll(tmd.getCreators());
        this.contributors.addAll(tmd.getContributors());
        this.dates.addAll(tmd.getDates());
        this.docs.addAll(tmd.getDocumentation());
        this.keywords.addAll(tmd.getKeywords());
        this.projects.addAll(tmd.getProjects());
        this.publishers.addAll(tmd.getPublishers());
        this.variables.addAll(tmd.getVariables());
        if (this.variableMapLink == null) {
            this.variableMapLink = tmd.variableMapLink;
        }
        for (InvMetadata meta : tmd.getMetadata()) {
            if (!meta.isInherited() && !inheritAll) continue;
            if (!meta.isThreddsMetadata()) {
                this.metadata.add(meta);
                continue;
            }
            if (this.debugInherit) {
                System.out.println("  add metadata Element " + tmd.isInherited() + " " + meta);
            }
            meta.finish();
            this.transfer2PublicMetadata(meta.getThreddsMetadata(), inheritAll);
            this.metadata.add(meta);
        }
    }

    public void transferMetadata(InvDatasetImpl fromDs, boolean copyInheritedMetadataFromParents) {
        if (fromDs == null) {
            return;
        }
        if (this.debugInherit2) {
            System.out.println(" transferMetadata= " + fromDs.getName());
        }
        if (this != fromDs) {
            this.getLocalMetadata().add(fromDs.getLocalMetadata(), false);
        }
        this.transferInheritableMetadata(fromDs, this.getLocalMetadataInheritable(), copyInheritedMetadataFromParents);
        this.setResourceControl(fromDs.getRestrictAccess());
    }

    private void transferInheritableMetadata(InvDatasetImpl fromDs, ThreddsMetadata target, boolean copyInheritedMetadataFromParents) {
        if (fromDs == null) {
            return;
        }
        if (this.debugInherit2) {
            System.out.println(" transferInheritedMetadata= " + fromDs.getName());
        }
        target.add(fromDs.getLocalMetadataInheritable(), true);
        if (copyInheritedMetadataFromParents) {
            this.transferInheritableMetadata((InvDatasetImpl)fromDs.getParent(), target, true);
        }
    }

    private void addExpandedAccess(InvAccessImpl a) {
        InvService service = a.getService();
        if (null == service) {
            a.check(this.log, false);
            return;
        }
        if (service.getServiceType() == ServiceType.COMPOUND) {
            for (InvService nestedService : service.getServices()) {
                InvAccessImpl nestedAccess = new InvAccessImpl(this, a.getUrlPath(), nestedService);
                this.addExpandedAccess(nestedAccess);
            }
        } else {
            this.access.add(a);
        }
    }

    protected void canonicalize() {
        ArrayList<InvMetadata> whatsLeft = new ArrayList<InvMetadata>();
        ArrayList<InvMetadata> original = new ArrayList<InvMetadata>(this.tm.metadata);
        this.tm.metadata = new ArrayList<InvMetadata>();
        for (InvMetadata m : original) {
            ThreddsMetadata nested;
            if (m.isThreddsMetadata() && !m.isInherited() && !m.hasXlink()) {
                nested = m.getThreddsMetadata();
                this.tm.add(nested, false);
                continue;
            }
            if (m.isThreddsMetadata() && m.isInherited() && !m.hasXlink()) {
                nested = m.getThreddsMetadata();
                this.tmi.add(nested, true);
                continue;
            }
            whatsLeft.add(m);
        }
        this.tm.metadata.addAll(whatsLeft);
    }

    public InvDatasetImpl(String urlPath, FeatureType dataType, ServiceType stype) {
        super(null, "local file");
        this.tm.setDataType(dataType);
        this.tm.setServiceName("anon");
        this.urlPath = urlPath;
        this.addService(new InvService(this.tm.getServiceName(), stype.toString(), "", "", null));
        this.finish();
    }

    public InvDatasetImpl(InvDataset parent, String name) {
        super(parent, name);
    }

    public InvDatasetImpl(InvDatasetImpl from) {
        super(from.getParent(), from.getName());
        this.tm = new ThreddsMetadata(from.getLocalMetadata());
        this.tmi = new ThreddsMetadata(from.getLocalMetadataInheritable());
        this.accessLocal = new ArrayList<InvAccess>(from.getAccessLocal());
        this.servicesLocal = new ArrayList<InvService>(from.getServicesLocal());
        this.harvest = from.harvest;
        this.collectionType = from.collectionType;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.hashCode = 0;
    }

    public void setCatalog(InvCatalog catalog) {
        this.catalog = catalog;
        this.hashCode = 0;
    }

    public InvDataset getParentReal() {
        return this.parent;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
        this.hashCode = 0;
    }

    public void setAuthority(String authorityName) {
        this.tm.setAuthority(authorityName);
        this.hashCode = 0;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        this.hashCode = 0;
    }

    public void setHarvest(boolean harvest) {
        this.harvest = harvest;
        this.hashCode = 0;
    }

    public void setID(String id) {
        this.id = id;
        this.hashCode = 0;
    }

    public void setName(String name) {
        this.name = name;
        this.hashCode = 0;
    }

    public void setParent(InvDatasetImpl parent) {
        this.parent = parent;
        this.hashCode = 0;
    }

    public void setGeospatialCoverage(ThreddsMetadata.GeospatialCoverage gc) {
        this.tm.setGeospatialCoverage(gc);
        this.hashCode = 0;
    }

    public void setTimeCoverage(CalendarDateRange tc) {
        this.tm.setTimeCoverage(tc);
        this.hashCode = 0;
    }

    public void setTimeCoverage(DateRange tc) {
        this.tm.setTimeCoverage(tc);
        this.hashCode = 0;
    }

    public void setDataFormatType(DataFormatType dataFormatType) {
        this.tm.setDataFormatType(dataFormatType);
        this.hashCode = 0;
    }

    public void setDataType(FeatureType dataType) {
        this.tm.setDataType(dataType);
        this.hashCode = 0;
    }

    public double getDataSize() {
        return this.tm.getDataSize();
    }

    public void setDataSize(double dataSize) {
        this.tm.setDataSize(dataSize);
        this.hashCode = 0;
    }

    public DateType getLastModifiedDate() {
        for (DateType dateType : this.tm.getDates()) {
            if (dateType.getType() == null || !dateType.getType().equals("modified")) continue;
            return dateType;
        }
        return null;
    }

    public void setLastModifiedDate(DateType lastModDate) {
        if (lastModDate == null) {
            throw new IllegalArgumentException("Last modified date can't be null.");
        }
        if (lastModDate.getType() == null || !lastModDate.getType().equals("modified")) {
            throw new IllegalArgumentException("Date type must be \"modified\" (was \"" + lastModDate.getType() + "\").");
        }
        DateType curLastModDateType = this.getLastModifiedDate();
        if (curLastModDateType != null) {
            this.tm.getDates().remove(curLastModDateType);
        }
        this.tm.addDate(lastModDate);
        this.hashCode = 0;
    }

    public void setLastModifiedDate(Date lastModDate) {
        if (lastModDate == null) {
            throw new IllegalArgumentException("Last modified date can't be null.");
        }
        DateType lastModDateType = new DateType(false, lastModDate);
        lastModDateType.setType("modified");
        this.setLastModifiedDate(lastModDateType);
    }

    public void setServiceName(String serviceName) {
        this.tm.setServiceName(serviceName);
        this.hashCode = 0;
    }

    public void setContributors(List<ThreddsMetadata.Contributor> a) {
        List<ThreddsMetadata.Contributor> dest = this.tm.getContributors();
        for (ThreddsMetadata.Contributor item : a) {
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setKeywords(List<ThreddsMetadata.Vocab> a) {
        List<ThreddsMetadata.Vocab> dest = this.tm.getKeywords();
        for (ThreddsMetadata.Vocab item : a) {
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setProjects(List<ThreddsMetadata.Vocab> a) {
        List<ThreddsMetadata.Vocab> dest = this.tm.getProjects();
        for (ThreddsMetadata.Vocab item : a) {
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setPublishers(List<ThreddsMetadata.Source> a) {
        List<ThreddsMetadata.Source> dest = this.tm.getPublishers();
        for (ThreddsMetadata.Source item : a) {
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setResourceControl(String restrictAccess) {
        this.restrictAccess = restrictAccess;
    }

    public void addAccess(InvAccess a) {
        this.accessLocal.add(a);
        this.hashCode = 0;
    }

    public void addAccess(List<InvAccess> a) {
        this.accessLocal.addAll(a);
        this.hashCode = 0;
    }

    public List<InvAccess> getAccessLocal() {
        return this.accessLocal;
    }

    public Element getNcmlElement() {
        return this.ncmlElement;
    }

    public void setNcmlElement(Element ncmlElement) {
        this.ncmlElement = ncmlElement;
    }

    public void addDataset(InvDatasetImpl ds) {
        if (ds == null) {
            return;
        }
        ds.setParent(this);
        this.datasets.add(ds);
        this.hashCode = 0;
    }

    public void addDataset(int index, InvDatasetImpl ds) {
        if (ds == null) {
            return;
        }
        ds.setParent(this);
        this.datasets.add(index, ds);
        this.hashCode = 0;
    }

    public boolean removeDataset(InvDatasetImpl ds) {
        if (this.datasets.remove(ds)) {
            ds.setParent(null);
            InvCatalogImpl cat = (InvCatalogImpl)this.getParentCatalog();
            if (cat != null) {
                cat.removeDatasetByID(ds);
            }
            return true;
        }
        return false;
    }

    public boolean replaceDataset(InvDatasetImpl remove, InvDatasetImpl add) {
        for (int i = 0; i < this.datasets.size(); ++i) {
            InvDataset dataset = (InvDataset)this.datasets.get(i);
            if (!dataset.equals(remove)) continue;
            this.datasets.set(i, add);
            InvCatalogImpl cat = (InvCatalogImpl)this.getParentCatalog();
            if (cat != null) {
                cat.removeDatasetByID(remove);
                cat.addDatasetByID(add);
            }
            return true;
        }
        return false;
    }

    public void addDocumentation(InvDocumentation doc) {
        this.tm.addDocumentation(doc);
        this.hashCode = 0;
    }

    public void addProperty(InvProperty p) {
        this.tm.addProperty(p);
        this.hashCode = 0;
    }

    public void addService(InvService service) {
        this.servicesLocal.add(service);
        this.services.add(service);
        for (InvService nested : service.getServices()) {
            this.services.add(nested);
        }
        this.hashCode = 0;
    }

    public void removeService(InvService service) {
        this.servicesLocal.remove(service);
        this.services.remove(service);
        for (InvService nested : service.getServices()) {
            this.services.remove(nested);
        }
    }

    public List<InvService> getServicesLocal() {
        return this.servicesLocal;
    }

    public void setServicesLocal(List<InvService> s) {
        this.services = new ArrayList();
        this.servicesLocal = new ArrayList<InvService>();
        for (InvService elem : s) {
            this.addService(elem);
        }
        this.hashCode = 0;
    }

    public ThreddsMetadata getLocalMetadata() {
        return this.tm;
    }

    public void setLocalMetadata(ThreddsMetadata tm) {
        this.tm = tm;
        this.hashCode = 0;
    }

    public ThreddsMetadata getLocalMetadataInheritable() {
        return this.tmi;
    }

    public boolean removeLocalMetadata(InvMetadata metadata) {
        InvDatasetImpl parentDataset = (InvDatasetImpl)metadata.getParentDataset();
        List<InvMetadata> localMdata = parentDataset.getLocalMetadata().getMetadata();
        if (localMdata.contains(metadata) && localMdata.remove(metadata)) {
            this.hashCode = 0;
            return true;
        }
        return false;
    }

    public String getServiceName() {
        if (this.defaultService != null) {
            return this.defaultService.getName();
        }
        return null;
    }

    protected boolean getMark() {
        return this.mark;
    }

    protected void setMark(boolean mark) {
        this.mark = mark;
    }

    public Object getUserProperty(Object key) {
        if (this.userMap == null) {
            return null;
        }
        return this.userMap.get(key);
    }

    public void setUserProperty(Object key, Object value) {
        if (this.userMap == null) {
            this.userMap = new HashMap();
        }
        this.userMap.put(key, value);
    }

    public String toString() {
        return this.getName();
    }

    public static void writeHtmlDescription(StringBuilder buff, InvDatasetImpl ds, boolean complete, boolean isServer, boolean datasetEvents, boolean catrefEvents) {
        InvDatasetImpl.writeHtmlDescription(buff, ds, complete, isServer, datasetEvents, catrefEvents, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeHtmlDescription(StringBuilder buff, InvDatasetImpl ds, boolean complete, boolean isServer, boolean datasetEvents, boolean catrefEvents, boolean resolveRelativeUrls) {
        CalendarDateRange tc;
        ThreddsMetadata.GeospatialCoverage geospatialCoverage;
        List<ThreddsMetadata.Variables> list;
        List<ThreddsMetadata.Source> list2;
        List<ThreddsMetadata.Source> list3;
        List<ThreddsMetadata.Vocab> list4;
        List<DateType> list5;
        List<ThreddsMetadata.Vocab> list6;
        List<ThreddsMetadata.Contributor> list7;
        List<InvAccess> access;
        if (ds == null) {
            return;
        }
        if (complete) {
            buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n");
            buff.append("<head>");
            buff.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            buff.append("</head>");
            buff.append("<body>\n");
        }
        buff.append("<h2>Dataset: ").append(ds.getFullName()).append("</h2>\n<ul>\n");
        if (ds.getDataFormatType() != null && ds.getDataFormatType() != DataFormatType.NONE) {
            buff.append(" <li><em>Data format: </em>").append(StringUtil2.quoteHtmlContent(ds.getDataFormatType().toString())).append("</li>\n");
        }
        if (ds.getDataSize() != 0.0 && !Double.isNaN(ds.getDataSize())) {
            buff.append(" <li><em>Data size: </em>").append(Format.formatByteSize(ds.getDataSize())).append("</li>\n");
        }
        if (ds.getDataType() != null && ds.getDataType() != FeatureType.ANY && ds.getDataType() != FeatureType.NONE) {
            buff.append(" <li><em>Data type: </em>").append(StringUtil2.quoteHtmlContent(ds.getDataType().toString())).append("</li>\n");
        }
        if (ds.getCollectionType() != null && ds.getCollectionType() != CollectionType.NONE) {
            buff.append(" <li><em>Collection type: </em>").append(StringUtil2.quoteHtmlContent(ds.getCollectionType().toString())).append("</li>\n");
        }
        if (ds.isHarvest()) {
            buff.append(" <li><em>Harvest: </em>").append(ds.isHarvest()).append("</li>\n");
        }
        if (ds.getAuthority() != null) {
            buff.append(" <li><em>Naming Authority: </em>").append(StringUtil2.quoteHtmlContent(ds.getAuthority())).append("</li>\n");
        }
        if (ds.getID() != null) {
            buff.append(" <li><em>ID: </em>").append(StringUtil2.quoteHtmlContent(ds.getID())).append("</li>\n");
        }
        if (ds.getRestrictAccess() != null) {
            buff.append(" <li><em>RestrictAccess: </em>").append(StringUtil2.quoteHtmlContent(ds.getRestrictAccess())).append("</li>\n");
        }
        if (ds instanceof InvCatalogRef) {
            Object href;
            InvCatalogRef catref = (InvCatalogRef)ds;
            Object object = href = resolveRelativeUrls || catrefEvents ? InvDatasetImpl.resolve(ds, catref.getXlinkHref()) : catref.getXlinkHref();
            if (catrefEvents) {
                href = "catref:" + (String)href;
            }
            buff.append(" <li><em>CatalogRef: </em>").append(InvDatasetImpl.makeHref((String)href, null)).append("</li>\n");
        }
        buff.append("</ul>\n");
        List<InvDocumentation> docs = ds.getDocumentation();
        if (docs.size() > 0) {
            buff.append("<h3>Documentation:</h3>\n<ul>\n");
            for (InvDocumentation invDocumentation : docs) {
                String string = invDocumentation.getType() == null ? "" : "<strong>" + StringUtil2.quoteHtmlContent(invDocumentation.getType()) + ":</strong> ";
                String string2 = invDocumentation.getInlineContent();
                if (string2 != null && string2.length() > 0) {
                    buff.append(" <li>").append(string).append(StringUtil2.quoteHtmlContent(string2)).append("</li>\n");
                }
                if (!invDocumentation.hasXlink()) continue;
                buff.append(" <li>").append(string).append(InvDatasetImpl.makeHref(invDocumentation.getXlinkHref(), invDocumentation.getXlinkTitle())).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((access = ds.getAccess()).size() > 0) {
            buff.append("<h3>Access:</h3>\n<ol>\n");
            for (InvAccess invAccess : access) {
                void var13_35;
                String string;
                InvService invService = invAccess.getService();
                String string3 = string = resolveRelativeUrls || datasetEvents ? invAccess.getStandardUrlName() : invAccess.getUnresolvedUrlName();
                if (datasetEvents) {
                    String string4 = "dataset:" + string3;
                }
                if (isServer) {
                    void var13_38;
                    ServiceType serviceType = invService.getServiceType();
                    if (serviceType == ServiceType.OPENDAP || serviceType == ServiceType.DODS) {
                        String string5 = (String)var13_38 + ".html";
                    } else if (serviceType == ServiceType.DAP4) {
                        String string6 = (String)var13_38 + ".dmr.xml";
                    } else if (serviceType == ServiceType.WCS) {
                        String string7 = (String)var13_38 + "?service=WCS&version=1.0.0&request=GetCapabilities";
                    } else if (serviceType == ServiceType.WMS) {
                        String string8 = (String)var13_38 + "?service=WMS&version=1.3.0&request=GetCapabilities";
                    } else if (serviceType == ServiceType.NCML || serviceType == ServiceType.UDDC || serviceType == ServiceType.ISO) {
                        void var16_73;
                        void var15_61;
                        String string9 = ds.getCatalogUrl();
                        String string10 = ds.id;
                        if (string9.indexOf(35) > 0) {
                            String string11 = string9.substring(0, string9.lastIndexOf(35));
                        }
                        try {
                            void var15_64;
                            String string12 = URLEncoder.encode((String)var15_64, "UTF-8");
                            String string13 = URLEncoder.encode(string10, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        String string14 = (String)var13_38 + "?catalog=" + (String)var15_61 + "&dataset=" + (String)var16_73;
                    } else if (serviceType == ServiceType.NetcdfSubset) {
                        String string15 = (String)var13_38 + "/dataset.html";
                    } else if (serviceType == ServiceType.CdmRemote || serviceType == ServiceType.CdmrFeature) {
                        String string16 = (String)var13_38 + "?req=form";
                    }
                }
                buff.append(" <li> <b>").append(StringUtil2.quoteHtmlContent(invService.getServiceType().toString()));
                buff.append(":</b> ").append(InvDatasetImpl.makeHref((String)var13_35, string)).append("</li>\n");
            }
            buff.append("</ol>\n");
        }
        if ((list7 = ds.getContributors()).size() > 0) {
            buff.append("<h3>Contributors:</h3>\n<ul>\n");
            for (ThreddsMetadata.Contributor contributor : list7) {
                String string = contributor.getRole() == null ? "" : "<strong> (" + StringUtil2.quoteHtmlContent(contributor.getRole()) + ")</strong> ";
                buff.append(" <li>").append(StringUtil2.quoteHtmlContent(contributor.getName())).append(string).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((list6 = ds.getKeywords()).size() > 0) {
            buff.append("<h3>Keywords:</h3>\n<ul>\n");
            for (ThreddsMetadata.Vocab vocab : list6) {
                String string = vocab.getVocabulary() == null ? "" : " <strong>(" + StringUtil2.quoteHtmlContent(vocab.getVocabulary()) + ")</strong> ";
                buff.append(" <li>").append(StringUtil2.quoteHtmlContent(vocab.getText())).append(string).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((list5 = ds.getDates()).size() > 0) {
            buff.append("<h3>Dates:</h3>\n<ul>\n");
            for (DateType dateType : list5) {
                String string = dateType.getType() == null ? "" : " <strong>(" + StringUtil2.quoteHtmlContent(dateType.getType()) + ")</strong> ";
                buff.append(" <li>").append(StringUtil2.quoteHtmlContent(dateType.getText())).append(string).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((list4 = ds.getProjects()).size() > 0) {
            buff.append("<h3>Projects:</h3>\n<ul>\n");
            for (ThreddsMetadata.Vocab vocab : list4) {
                String string = vocab.getVocabulary() == null ? "" : " <strong>(" + StringUtil2.quoteHtmlContent(vocab.getVocabulary()) + ")</strong> ";
                buff.append(" <li>").append(StringUtil2.quoteHtmlContent(vocab.getText())).append(string).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((list3 = ds.getCreators()).size() > 0) {
            buff.append("<h3>Creators:</h3>\n<ul>\n");
            for (ThreddsMetadata.Source source : list3) {
                buff.append(" <li><strong>").append(StringUtil2.quoteHtmlContent(source.getName())).append("</strong><ul>\n");
                buff.append(" <li><em>email: </em>").append(StringUtil2.quoteHtmlContent(source.getEmail())).append("</li>\n");
                if (source.getUrl() != null) {
                    String string = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, source.getUrl(), null) : InvDatasetImpl.makeHref(source.getUrl(), null);
                    buff.append(" <li> <em>").append(string).append("</em></li>\n");
                }
                buff.append(" </ul></li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((list2 = ds.getPublishers()).size() > 0) {
            buff.append("<h3>Publishers:</h3>\n<ul>\n");
            for (ThreddsMetadata.Source source : list2) {
                buff.append(" <li><strong>").append(StringUtil2.quoteHtmlContent(source.getName())).append("</strong><ul>\n");
                buff.append(" <li><em>email: </em>").append(StringUtil2.quoteHtmlContent(source.getEmail())).append("\n");
                if (source.getUrl() != null) {
                    String urlLink = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, source.getUrl(), null) : InvDatasetImpl.makeHref(source.getUrl(), null);
                    buff.append(" <li> <em>").append(urlLink).append("</em>\n");
                }
                buff.append(" </ul>\n");
            }
            buff.append("</ul>\n");
        }
        if ((list = ds.getVariables()).size() > 0) {
            buff.append("<h3>Variables:</h3>\n<ul>\n");
            for (ThreddsMetadata.Variables t : list) {
                Object vocabLink;
                buff.append("<li><em>Vocabulary</em> [");
                if (t.getVocabUri() != null) {
                    URI uri = t.getVocabUri();
                    vocabLink = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, uri.toString(), t.getVocabulary()) : InvDatasetImpl.makeHref(uri.toString(), t.getVocabulary());
                    buff.append((String)vocabLink);
                } else {
                    buff.append(StringUtil2.quoteHtmlContent(t.getVocabulary()));
                }
                buff.append("]:\n<ul>\n");
                List<ThreddsMetadata.Variable> vlist = t.getVariableList();
                if (vlist.size() > 0) {
                    vocabLink = vlist.iterator();
                    while (vocabLink.hasNext()) {
                        ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)vocabLink.next();
                        String units = v.getUnits() == null || v.getUnits().length() == 0 ? "" : " (" + v.getUnits() + ") ";
                        buff.append(" <li><strong>").append(StringUtil2.quoteHtmlContent(v.getName() + units)).append("</strong> = ");
                        String desc = v.getDescription() == null ? "" : " <i>" + StringUtil2.quoteHtmlContent(v.getDescription()) + "</i> = ";
                        buff.append(desc);
                        if (v.getVocabularyName() != null) {
                            buff.append(StringUtil2.quoteHtmlContent(v.getVocabularyName()));
                        }
                        buff.append("\n");
                    }
                }
                buff.append("</ul>\n");
            }
            buff.append("</ul>\n");
        }
        if (ds.getVariableMapLink() != null) {
            buff.append("<h3>Variables:</h3>\n");
            buff.append("<ul><li>" + InvDatasetImpl.makeHref(ds.getVariableMapLink(), "VariableMap") + "</li></ul>\n");
        }
        if ((geospatialCoverage = ds.getGeospatialCoverage()) != null && !geospatialCoverage.isEmpty()) {
            List<ThreddsMetadata.Vocab> nlist;
            buff.append("<h3>GeospatialCoverage:</h3>\n<ul>\n");
            if (geospatialCoverage.isGlobal()) {
                buff.append(" <li><em> Global </em>\n");
            }
            buff.append(" <li><em> Longitude: </em> ").append(InvDatasetImpl.rangeString(geospatialCoverage.getEastWestRange())).append("</li>\n");
            buff.append(" <li><em> Latitude: </em> ").append(InvDatasetImpl.rangeString(geospatialCoverage.getNorthSouthRange())).append("</li>\n");
            if (geospatialCoverage.getUpDownRange() != null) {
                buff.append(" <li><em> Altitude: </em> ").append(InvDatasetImpl.rangeString(geospatialCoverage.getUpDownRange())).append(" (positive is <strong>").append(StringUtil2.quoteHtmlContent(geospatialCoverage.getZPositive())).append(")</strong></li>\n");
            }
            if ((nlist = geospatialCoverage.getNames()) != null && nlist.size() > 0) {
                buff.append(" <li><em>  Names: </em> <ul>\n");
                for (ThreddsMetadata.Vocab elem : nlist) {
                    buff.append(" <li>").append(StringUtil2.quoteHtmlContent(elem.getText())).append("\n");
                }
                buff.append(" </ul>\n");
            }
            buff.append(" </ul>\n");
        }
        if ((tc = ds.getCalendarDateCoverage()) != null) {
            CalendarDuration resolution;
            Iterator<InvMetadata> duration;
            CalendarDate end;
            buff.append("<h3>TimeCoverage:</h3>\n<ul>\n");
            CalendarDate start = tc.getStart();
            if (start != null) {
                buff.append(" <li><em>  Start: </em> ").append(start.toString()).append("\n");
            }
            if ((end = tc.getEnd()) != null) {
                buff.append(" <li><em>  End: </em> ").append(end.toString()).append("\n");
            }
            if ((duration = tc.getDuration()) != null) {
                buff.append(" <li><em>  Duration: </em> ").append(StringUtil2.quoteHtmlContent(((CalendarDuration)((Object)duration)).toString())).append("\n");
            }
            if ((resolution = tc.getResolution()) != null) {
                buff.append(" <li><em>  Resolution: </em> ").append(StringUtil2.quoteHtmlContent(resolution.toString())).append("\n");
            }
            buff.append(" </ul>\n");
        }
        List<InvMetadata> metadata = ds.getMetadata();
        boolean gotSomeMetadata = false;
        for (InvMetadata m : metadata) {
            if (!m.hasXlink()) continue;
            gotSomeMetadata = true;
        }
        if (gotSomeMetadata) {
            buff.append("<h3>Metadata:</h3>\n<ul>\n");
            for (InvMetadata m : metadata) {
                String type;
                String string = type = m.getMetadataType() == null ? "" : m.getMetadataType();
                if (!m.hasXlink()) continue;
                String title = m.getXlinkTitle() == null ? "Type " + type : m.getXlinkTitle();
                String mdLink = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, m.getXlinkHref(), title) : InvDatasetImpl.makeHref(m.getXlinkHref(), title);
                buff.append(" <li> ").append(mdLink).append("\n");
            }
            buff.append("</ul>\n");
        }
        List<InvProperty> propsOrg = ds.getProperties();
        ArrayList<InvProperty> props = new ArrayList<InvProperty>(ds.getProperties().size());
        for (InvProperty p : propsOrg) {
            if (p.getName().startsWith("viewer")) continue;
            props.add(p);
        }
        if (props.size() > 0) {
            buff.append("<h3>Properties:</h3>\n<ul>\n");
            for (InvProperty p : props) {
                if (p.getName().equals("attachments")) {
                    String attachLink = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, p.getValue(), p.getName()) : InvDatasetImpl.makeHref(p.getValue(), p.getName());
                    buff.append(" <li>").append(attachLink).append("\n");
                    continue;
                }
                buff.append(" <li>").append(StringUtil2.quoteHtmlContent(p.getName() + " = \"" + p.getValue())).append("\"\n");
            }
            buff.append("</ul>\n");
        }
        if (complete) {
            buff.append("</body></html>");
        }
    }

    private static String rangeString(ThreddsMetadata.Range r) {
        if (r == null) {
            return "";
        }
        String units = r.getUnits() == null ? "" : " " + r.getUnits();
        String resolution = r.hasResolution() ? " Resolution=" + r.getResolution() : "";
        return StringUtil2.quoteHtmlContent(r.getStart() + " to " + (r.getStart() + r.getSize()) + resolution + units);
    }

    public static String resolve(InvDataset ds, String href) {
        InvCatalog cat = ds.getParentCatalog();
        if (cat != null) {
            try {
                URI uri = cat.resolveUri(href);
                href = uri.toString();
            }
            catch (URISyntaxException e) {
                logger.warn("InvDatasetImpl.writeHtml: error parsing URL= " + href);
            }
        }
        return href;
    }

    private static String makeHref(String href, String title) {
        if (title == null) {
            title = href;
        }
        return "<a href='" + StringUtil2.quoteHtmlContent(href) + "'>" + StringUtil2.quoteHtmlContent(title) + "</a>";
    }

    private static String makeHrefResolve(InvDatasetImpl ds, String href, String title) {
        if (title == null) {
            title = href;
        }
        href = InvDatasetImpl.resolve(ds, href);
        return InvDatasetImpl.makeHref(href, title);
    }

    public String dump() {
        return this.dump(0);
    }

    String dump(int n) {
        String indent;
        StringBuilder buff = new StringBuilder(100);
        buff.append(InvDatasetImpl.indent(n));
        buff.append("Dataset name:<").append(this.getName());
        if (this.dataType != null) {
            buff.append("> dataType:<").append((Object)this.dataType);
        }
        if (this.urlPath != null) {
            buff.append("> urlPath:<").append(this.urlPath);
        }
        if (this.defaultService != null) {
            buff.append("> defaultService <").append(this.defaultService);
        }
        buff.append("> uID:<").append(this.getUniqueID());
        buff.append(">\n");
        List<InvService> svcs = this.getServicesLocal();
        if (svcs.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Services:\n");
            for (InvService s : svcs) {
                buff.append(s.dump(n + 4));
            }
        }
        if (this.access.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            if (this.access.size() == 1) {
                buff.append("Access: ").append(this.access.get(0)).append("\n");
            } else if (this.access.size() > 1) {
                buff.append("Access:\n");
                for (InvAccess a : this.access) {
                    buff.append(InvDatasetImpl.indent(n + 4)).append(a).append("\n");
                }
            }
        }
        buff.append(InvDatasetImpl.indent(n)).append("Thredds Metadata\n");
        buff.append(this.tm.dump(n + 4)).append("\n");
        buff.append(InvDatasetImpl.indent(n)).append("Thredds Metadata Inherited\n");
        buff.append(this.tmi.dump(n + 4)).append("\n");
        if (this.datasets.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Datasets:\n");
            for (InvDataset ds : this.datasets) {
                InvDatasetImpl dsi = (InvDatasetImpl)ds;
                buff.append(dsi.dump(n + 4));
            }
        }
        return buff.toString();
    }

    static String indent(int n) {
        StringBuilder blanks = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            blanks.append(" ");
        }
        return blanks.toString();
    }

    boolean check(StringBuilder out, boolean show) {
        boolean isValid = true;
        if (this.log.length() > 0) {
            out.append((CharSequence)this.log);
        }
        for (InvAccess acces : this.access) {
            InvAccessImpl a = (InvAccessImpl)acces;
            isValid &= a.check(out, show);
        }
        for (InvDataset dataset : this.datasets) {
            InvDatasetImpl ds = (InvDatasetImpl)dataset;
            isValid &= ds.check(out, show);
        }
        for (InvMetadata m : this.getMetadata()) {
            m.check(out);
        }
        for (InvService s : this.getServicesLocal()) {
            isValid &= s.check(out);
        }
        if (this.hasAccess() && this.getDataType() == null) {
            out.append("**Warning: Dataset (").append(this.getFullName()).append("): is selectable but no data type declared in it or in a parent element\n");
        }
        if (!this.hasAccess() && !this.hasNestedDatasets()) {
            out.append("**Warning: Dataset (").append(this.getFullName()).append("): is not selectable and does not have nested datasets\n");
        }
        if (show) {
            System.out.println("  dataset " + this.name + " valid = " + isValid);
        }
        return isValid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvDatasetImpl)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getServicesLocal().hashCode();
            result = 37 * result + this.getDatasets().hashCode();
            result = 37 * result + this.getAccessLocal().hashCode();
            result = 37 * result + (this.isHarvest() ? 1 : 0);
            if (null != this.getCollectionType()) {
                result = 37 * result + this.getCollectionType().hashCode();
            }
            result = 37 * result + this.getDocumentation().hashCode();
            result = 37 * result + this.getProperties().hashCode();
            result = 37 * result + this.getMetadata().hashCode();
            result = 37 * result + this.getCreators().hashCode();
            result = 37 * result + this.getContributors().hashCode();
            result = 37 * result + this.getDates().hashCode();
            result = 37 * result + this.getKeywords().hashCode();
            result = 37 * result + this.getProjects().hashCode();
            result = 37 * result + this.getPublishers().hashCode();
            result = 37 * result + this.getVariables().hashCode();
            if (null != this.getID()) {
                result = 37 * result + this.getID().hashCode();
            }
            if (null != this.getAlias()) {
                result = 37 * result + this.getAlias().hashCode();
            }
            if (null != this.getAuthority()) {
                result = 37 * result + this.getAuthority().hashCode();
            }
            if (null != this.getDataType()) {
                result = 37 * result + this.getDataType().hashCode();
            }
            if (null != this.getDataFormatType()) {
                result = 37 * result + this.getDataFormatType().hashCode();
            }
            if (null != this.getServiceDefault()) {
                result = 37 * result + this.getServiceDefault().hashCode();
            }
            if (null != this.getUrlPath()) {
                result = 37 * result + this.getUrlPath().hashCode();
            }
            if (null != this.getGeospatialCoverage()) {
                result = 37 * result + this.getGeospatialCoverage().hashCode();
            }
            if (null != this.getCalendarDateCoverage()) {
                result = 37 * result + this.getCalendarDateCoverage().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }
}

