/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.CharSequences;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.FieldNullability;
import net.openhft.chronicle.values.MaxUtf8Length;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.Nullability;
import net.openhft.chronicle.values.ObjectHeapMemberGenerator;
import net.openhft.chronicle.values.ScalarFieldModel;
import net.openhft.chronicle.values.ValueBuilder;

class CharSequenceFieldModel
extends ScalarFieldModel {
    final FieldNullability nullability = new FieldNullability(this);
    MaxUtf8Length maxUtf8Length;
    private final MemberGenerator nativeGenerator = new MemberGenerator(this){

        @Override
        public void generateFields(ValueBuilder valueBuilder) {
            CharSequenceFieldModel.this.addCachedStringBuilder(valueBuilder);
        }

        @Override
        public void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            this.generateFields(valueBuilder);
        }

        @Override
        public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedStringBuilder(valueBuilder, methodBuilder);
            this.finishGet(methodBuilder, CharSequenceFieldModel.this.get);
        }

        private void initCachedStringBuilder(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int byteOffset = CharSequenceFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.beginControlFlow("if (bs.readUtf8Limited(offset + $L, $N, $L) > 0)", byteOffset, CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.maxUtf8Length.value());
        }

        @Override
        public void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.initArrayElementCachedStringBuilder(arrayFieldModel, valueBuilder, methodBuilder);
            this.finishGet(methodBuilder, arrayFieldModel.get);
        }

        private void initArrayElementCachedStringBuilder(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            methodBuilder.beginControlFlow("if (bs.readUtf8Limited(offset + $L + elementOffset, $N, $L) > 0)", arrayByteOffset, CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.maxUtf8Length.value());
        }

        private void finishGet(MethodSpec.Builder methodBuilder, Method get) {
            if (CharSequenceFieldModel.this.type == String.class) {
                methodBuilder.addStatement("return $N.toString()", CharSequenceFieldModel.this.cachedStringBuilder());
            } else {
                if (CharSequenceFieldModel.this.type != StringBuilder.class && CharSequenceFieldModel.this.type != CharSequence.class) {
                    throw new IllegalStateException("Only StringBuilder, String and CharSequence classes are supported, " + CharSequenceFieldModel.this.name + " field type is " + CharSequenceFieldModel.this.type);
                }
                methodBuilder.addStatement("return $N", CharSequenceFieldModel.this.cachedStringBuilder());
            }
            CharSequenceFieldModel.this.nullGetBranch(methodBuilder, get);
        }

        @Override
        public void generateGetUsing(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int byteOffset = CharSequenceFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.beginControlFlow("if (bs.readUtf8Limited(offset + $L, $N, $L) > 0)", byteOffset, CharSequenceFieldModel.this.usingName(), CharSequenceFieldModel.this.maxUtf8Length.value());
            this.finishGetUsing(methodBuilder, CharSequenceFieldModel.this.getUsing);
        }

        @Override
        public void generateArrayElementGetUsing(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            methodBuilder.beginControlFlow("if (bs.readUtf8Limited(offset + $L + elementOffset, $N, $L) > 0)", arrayByteOffset, CharSequenceFieldModel.this.usingName(), CharSequenceFieldModel.this.maxUtf8Length.value());
            this.finishGetUsing(methodBuilder, arrayFieldModel.getUsing);
        }

        private void finishGetUsing(MethodSpec.Builder methodBuilder, Method get) {
            CharSequenceFieldModel.this.returnNotNullGetUsing(methodBuilder);
            CharSequenceFieldModel.this.nullGetBranch(methodBuilder, get);
        }

        @Override
        public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (!CharSequenceFieldModel.this.nullable()) {
                CharSequenceFieldModel.this.checkArgumentNotNull(methodBuilder);
            }
            this.genSet(valueBuilder, methodBuilder, CharSequenceFieldModel.this.varName());
        }

        private void genSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, Object toSet) {
            int byteOffset = CharSequenceFieldModel.this.verifiedByteOffset(valueBuilder);
            String endName = "__end" + CharSequenceFieldModel.this.name;
            methodBuilder.addStatement("long $N = bs.writeUtf8Limited(offset + $L, $N, $L)", endName, byteOffset, toSet, CharSequenceFieldModel.this.maxUtf8Length.value());
            methodBuilder.addStatement("bs.zeroOut($N, offset + $L)", endName, byteOffset + CharSequenceFieldModel.this.sizeInBytes());
        }

        @Override
        public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (!CharSequenceFieldModel.this.nullable()) {
                CharSequenceFieldModel.this.checkArgumentNotNull(methodBuilder);
            }
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, CharSequenceFieldModel.this.varName());
        }

        private void genArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, Object toSet) {
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            String endName = "__end" + CharSequenceFieldModel.this.name;
            methodBuilder.addStatement("long $N = bs.writeUtf8Limited(offset + $L + elementOffset, $N, $L)", endName, arrayByteOffset, toSet, CharSequenceFieldModel.this.maxUtf8Length.value());
            methodBuilder.addStatement("bs.zeroOut($N, offset + $L + elementOffset + $L)", endName, arrayByteOffset, CharSequenceFieldModel.this.sizeInBytes());
        }

        @Override
        public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("from.$N($N)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    this.genSet(valueBuilder, methodBuilder, CharSequenceFieldModel.this.cachedStringBuilder());
                } else {
                    String getUsingResult = String.format("from.%s(%s)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    this.genSet(valueBuilder, methodBuilder, getUsingResult);
                }
            } else {
                this.genSet(valueBuilder, methodBuilder, String.format("from.%s()", CharSequenceFieldModel.this.get.getName()));
            }
        }

        @Override
        public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("from.$N(index, $N)", getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    this.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, CharSequenceFieldModel.this.cachedStringBuilder());
                } else {
                    String getUsingResult = String.format("from.%s(index, %s)", getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    this.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, getUsingResult);
                }
            } else {
                this.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, String.format("from.%s(index)", arrayFieldModel.get.getName()));
            }
        }

        @Override
        void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedStringBuilder(valueBuilder, methodBuilder);
            this.finishWriteMarshallable(methodBuilder);
        }

        @Override
        void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedStringBuilder(arrayFieldModel, valueBuilder, methodBuilder);
            this.finishWriteMarshallable(methodBuilder);
        }

        private void finishWriteMarshallable(MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("bytes.writeUtf8($N)", CharSequenceFieldModel.this.cachedStringBuilder());
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("bytes.writeUtf8(null)", new Object[0]);
            methodBuilder.endControlFlow();
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N(bytes.readUtf8($N) ? $N : null)", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.cachedBuilderToSettable());
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N(index, bytes.readUtf8($N) ? $N : null)", arrayFieldModel.set.getName(), CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.cachedBuilderToSettable());
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int byteOffset = CharSequenceFieldModel.this.verifiedByteOffset(valueBuilder);
            if (CharSequenceFieldModel.this.getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("other.$N($N)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    methodBuilder.addCode("if ($N.length() > $L) return false;\n", CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.maxUtf8Length.value());
                    methodBuilder.addCode("if (!bs.compareUtf8(offset + $L, $N)) return false;\n", byteOffset, CharSequenceFieldModel.this.cachedStringBuilder());
                } else {
                    String localName = "__other" + CharSequenceFieldModel.this.name;
                    methodBuilder.addStatement("$T $N = other.$N($N)", CharSequence.class, localName, CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    methodBuilder.addCode("if ($N != null && $N.length() > $L) return false;\n", localName, localName, CharSequenceFieldModel.this.maxUtf8Length.value());
                    methodBuilder.addCode("if (!bs.compareUtf8(offset + $L, $N)) return false;\n", byteOffset, localName);
                }
            } else {
                String localName = "__other" + CharSequenceFieldModel.this.name;
                methodBuilder.addStatement("$T $N = other.$N()", CharSequence.class, localName, CharSequenceFieldModel.this.get.getName());
                methodBuilder.addCode("if ($N != null && $N.length() > $L) return false;\n", localName, localName, CharSequenceFieldModel.this.maxUtf8Length.value());
                methodBuilder.addCode("if (!bs.compareUtf8(offset + $L, $N)) return false;\n", byteOffset, localName);
            }
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("other.$N(index, $N)", getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    methodBuilder.addCode("if ($N.length() > $L) return false;\n", CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.maxUtf8Length.value());
                    methodBuilder.addCode("if (!bs.compareUtf8(offset + $L + elementOffset, $N)) return false;\n", arrayByteOffset, CharSequenceFieldModel.this.cachedStringBuilder());
                } else {
                    String localName = "__other" + CharSequenceFieldModel.this.name;
                    methodBuilder.addStatement("$T $N = other.$N(index, $N)", CharSequence.class, localName, getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    methodBuilder.addCode("if ($N != null && $N.length() > $L) return false;\n", localName, localName, CharSequenceFieldModel.this.maxUtf8Length.value());
                    methodBuilder.addCode("if (!bs.compareUtf8(offset + $L + elementOffset, $N)) return false;\n", arrayByteOffset, localName);
                }
            } else {
                String localName = "__other" + CharSequenceFieldModel.this.name;
                methodBuilder.addStatement("$T $N = other.$N(index)", CharSequence.class, localName, arrayFieldModel.get.getName());
                methodBuilder.addCode("if ($N != null && $N.length() > $L) return false;\n", localName, localName, CharSequenceFieldModel.this.maxUtf8Length.value());
                methodBuilder.addCode("if (!bs.compareUtf8(offset + $L + elementOffset, $N)) return false;\n", arrayByteOffset, localName);
            }
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String hashCodeCharSequenceName = "__hashCode" + CharSequenceFieldModel.this.name;
            methodBuilder.addStatement("$T $N = null", CharSequence.class, hashCodeCharSequenceName);
            this.initCachedStringBuilder(valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N = $N", hashCodeCharSequenceName, CharSequenceFieldModel.this.cachedStringBuilder());
            methodBuilder.endControlFlow();
            return "net.openhft.chronicle.values.CharSequences.hashCode(" + hashCodeCharSequenceName + ")";
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String hashCodeCharSequenceName = "__hashCode" + CharSequenceFieldModel.this.name;
            methodBuilder.addStatement("$T $N = null", CharSequence.class, hashCodeCharSequenceName);
            this.initArrayElementCachedStringBuilder(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N = $N", hashCodeCharSequenceName, CharSequenceFieldModel.this.cachedStringBuilder());
            methodBuilder.endControlFlow();
            return "net.openhft.chronicle.values.CharSequences.hashCode(" + hashCodeCharSequenceName + ")";
        }

        @Override
        void generateToString(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedStringBuilder(valueBuilder, methodBuilder);
            this.genToString(methodBuilder, CharSequenceFieldModel.this.cachedStringBuilder());
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.genToString(methodBuilder, "(String) null");
            methodBuilder.endControlFlow();
        }

        @Override
        void generateArrayElementToString(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedStringBuilder(arrayFieldModel, valueBuilder, methodBuilder);
            this.genArrayElementToString(methodBuilder, CharSequenceFieldModel.this.cachedStringBuilder());
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.genArrayElementToString(methodBuilder, "(String) null");
            methodBuilder.endControlFlow();
        }
    };
    private final MemberGenerator stringHeapGenerator = new ObjectHeapMemberGenerator(this){

        @Override
        void generateFields(ValueBuilder valueBuilder) {
            this.field = FieldSpec.builder(String.class, CharSequenceFieldModel.this.fieldName(), new Modifier[]{Modifier.PRIVATE}).initializer("$S", "").build();
            valueBuilder.typeBuilder.addField(this.field);
            CharSequenceFieldModel.this.addCachedStringBuilder(valueBuilder);
        }

        @Override
        void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            super.generateArrayElementFields(arrayFieldModel, valueBuilder);
            MethodSpec.Builder constructor = valueBuilder.defaultConstructorBuilder();
            constructor.beginControlFlow("for (int index = 0; index < $L; index++)", arrayFieldModel.array.length());
            constructor.addStatement("$N[index] = $S", this.field, "");
            constructor.endControlFlow();
            CharSequenceFieldModel.this.addCachedStringBuilder(valueBuilder);
        }

        @Override
        public void generateGetUsing(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N.setLength(0)", CharSequenceFieldModel.this.usingName());
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.beginControlFlow("if ($N != null)", this.field);
            }
            methodBuilder.addStatement("$N.append($N)", CharSequenceFieldModel.this.usingName(), this.field);
            CharSequenceFieldModel.this.returnNotNullGetUsing(methodBuilder);
            if (CharSequenceFieldModel.this.nullable()) {
                CharSequenceFieldModel.this.nullGetBranch(methodBuilder, CharSequenceFieldModel.this.getUsing);
            }
        }

        @Override
        public void generateArrayElementGetUsing(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N.setLength(0)", CharSequenceFieldModel.this.usingName());
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.beginControlFlow("if ($N[index] != null)", this.field);
            }
            methodBuilder.addStatement("$N.append($N[index])", CharSequenceFieldModel.this.usingName(), this.field);
            CharSequenceFieldModel.this.returnNotNullGetUsing(methodBuilder);
            if (CharSequenceFieldModel.this.nullable()) {
                CharSequenceFieldModel.this.nullGetBranch(methodBuilder, arrayFieldModel.getUsing);
            }
        }

        @Override
        public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            CharSequenceFieldModel.this.checkHeapArgument(methodBuilder);
            methodBuilder.addStatement("this.$N = $N", this.field, CharSequenceFieldModel.this.varName());
        }

        @Override
        public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            CharSequenceFieldModel.this.checkHeapArgument(methodBuilder);
            methodBuilder.addStatement("this.$N[index] = $N", this.field, CharSequenceFieldModel.this.varName());
        }

        @Override
        public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.get != null) {
                methodBuilder.addStatement("this.$N(from.$N())", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.get.getName());
            } else if (!CharSequenceFieldModel.this.nullable()) {
                methodBuilder.addStatement("from.$N($N)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                methodBuilder.addStatement("this.$N($N.toString())", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
            } else {
                String getUsingResult = String.format("from.%s(%s)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                methodBuilder.addStatement("$T $N = $N", CharSequence.class, CharSequenceFieldModel.this.varName(), getUsingResult);
                methodBuilder.addStatement("$N = $N != null ? $N.toString() : null", this.field, CharSequenceFieldModel.this.varName(), CharSequenceFieldModel.this.cachedStringBuilder());
            }
        }

        @Override
        public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.get != null) {
                methodBuilder.addStatement("this.$N(index, from.$N(index))", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.get.getName());
            } else if (CharSequenceFieldModel.this.getUsing.getReturnType() == Void.TYPE) {
                methodBuilder.addStatement("from.$N(index, $N)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                methodBuilder.addStatement("this.$N(index, $N.toString())", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
            } else {
                String getUsingResult = String.format("from.%s(index, %s)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                methodBuilder.addStatement("$T $N = $N", CharSequence.class, CharSequenceFieldModel.this.varName(), getUsingResult);
                methodBuilder.addStatement("$N[index] = $N != null ? $N.toString() : null", this.field, CharSequenceFieldModel.this.varName(), CharSequenceFieldModel.this.cachedStringBuilder());
            }
        }

        @Override
        void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("bytes.writeUtf8($N)", CharSequenceFieldModel.this.fieldName());
        }

        @Override
        void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("bytes.writeUtf8($N[index])", CharSequenceFieldModel.this.fieldName());
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("this.$N(bytes.readUtf8($N) ? $N.toString() : null)", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.cachedStringBuilder());
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("this.$N(index, bytes.readUtf8($N) ? $N.toString() : null)", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.cachedStringBuilder());
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.get != null) {
                boolean hasGetUsing;
                boolean bl = hasGetUsing = CharSequenceFieldModel.this.getUsing != null;
                if (hasGetUsing) {
                    ClassName heapClassName = valueBuilder.className();
                    methodBuilder.beginControlFlow("if (other instanceof $T)", heapClassName);
                }
                methodBuilder.addCode("if (!$T.equals($N, other.$N())) return false;\n", CharSequences.class, this.field, CharSequenceFieldModel.this.get.getName());
                if (hasGetUsing) {
                    methodBuilder.nextControlFlow("else", new Object[0]);
                    this.equalsWithGetUsing(methodBuilder);
                    methodBuilder.endControlFlow();
                }
            } else {
                this.equalsWithGetUsing(methodBuilder);
            }
        }

        private void equalsWithGetUsing(MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.getUsing.getReturnType() == Void.TYPE) {
                methodBuilder.addStatement("other.$N($N)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                methodBuilder.addCode("if (!$T.equals($N, $N)) return false;\n", CharSequences.class, this.field, CharSequenceFieldModel.this.cachedStringBuilder());
            } else {
                methodBuilder.addCode("if (!$T.equals($N, other.$N($N))) return false;\n", CharSequences.class, this.field, CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
            }
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.get != null) {
                boolean hasGetUsing;
                boolean bl = hasGetUsing = CharSequenceFieldModel.this.getUsing != null;
                if (hasGetUsing) {
                    ClassName heapClassName = valueBuilder.className();
                    methodBuilder.beginControlFlow("if (other instanceof $T)", heapClassName);
                }
                methodBuilder.addCode("if (!$T.equals($N[index], other.$N(index))) return false;\n", CharSequences.class, this.field, CharSequenceFieldModel.this.get.getName());
                if (hasGetUsing) {
                    methodBuilder.nextControlFlow("else", new Object[0]);
                    this.equalsArrayElementWithGetUsing(methodBuilder);
                    methodBuilder.endControlFlow();
                }
            } else {
                this.equalsArrayElementWithGetUsing(methodBuilder);
            }
        }

        private void equalsArrayElementWithGetUsing(MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.getUsing.getReturnType() == Void.TYPE) {
                methodBuilder.addStatement("other.$N(index, $N)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                methodBuilder.addCode("if (!$T.equals($N[index], $N)) return false;\n", CharSequences.class, this.field, CharSequenceFieldModel.this.cachedStringBuilder());
            } else {
                methodBuilder.addCode("if (!$T.equals($N[index], other.$N(index, $N))) return false;\n", CharSequences.class, this.field, CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
            }
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return "net.openhft.chronicle.values.CharSequences.hashCode(" + this.field.name + ")";
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return "net.openhft.chronicle.values.CharSequences.hashCode(" + this.field.name + "[index])";
        }
    };
    private final MemberGenerator charSequenceHeapGenerator = new ObjectHeapMemberGenerator(this){

        private String isNull() {
            return CharSequenceFieldModel.this.fieldName() + "IsNull";
        }

        private void addCachedStringBuilderForCharSequenceHeapGenerator(ValueBuilder valueBuilder) {
            if (CharSequenceFieldModel.this.get == null) {
                CharSequenceFieldModel.this.addCachedStringBuilder(valueBuilder);
            }
        }

        @Override
        void generateFields(ValueBuilder valueBuilder) {
            this.field = FieldSpec.builder(StringBuilder.class, CharSequenceFieldModel.this.fieldName(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T($L)", StringBuilder.class, CharSequenceFieldModel.this.maxUtf8Length.value()).build();
            valueBuilder.typeBuilder.addField(this.field);
            if (CharSequenceFieldModel.this.nullable()) {
                FieldSpec isNullField = FieldSpec.builder(Boolean.TYPE, this.isNull(), Modifier.PRIVATE).build();
                valueBuilder.typeBuilder.addField(isNullField);
            }
            this.addCachedStringBuilderForCharSequenceHeapGenerator(valueBuilder);
        }

        @Override
        void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            this.field = FieldSpec.builder(ArrayTypeName.of(StringBuilder.class), CharSequenceFieldModel.this.fieldName(), Modifier.PRIVATE, Modifier.FINAL).initializer("new $T[$L]", StringBuilder.class, arrayFieldModel.array.length()).build();
            valueBuilder.typeBuilder.addField(this.field);
            MethodSpec.Builder constructorBuilder = valueBuilder.defaultConstructorBuilder();
            constructorBuilder.beginControlFlow("for (int index = 0; index < $L; index++)", new Object[0]);
            constructorBuilder.addStatement("$N[index] = new $T($L)", this.field, StringBuilder.class, CharSequenceFieldModel.this.maxUtf8Length.value());
            constructorBuilder.endControlFlow();
            if (CharSequenceFieldModel.this.nullable()) {
                FieldSpec isNullArrayField = FieldSpec.builder(ArrayTypeName.of(Boolean.TYPE), this.isNull(), Modifier.PRIVATE, Modifier.FINAL).initializer("new boolean[$L]", arrayFieldModel.array.length()).build();
                valueBuilder.typeBuilder.addField(isNullArrayField);
            }
            this.addCachedStringBuilderForCharSequenceHeapGenerator(valueBuilder);
        }

        @Override
        public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.addStatement("return !$N ? $N : null", this.isNull(), this.field);
            } else {
                methodBuilder.addStatement("return $N", this.field);
            }
        }

        @Override
        public void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.addStatement("return !$N[index] ? $N[index] : null", this.isNull(), this.field);
            } else {
                methodBuilder.addStatement("return $N[index]", this.field);
            }
        }

        @Override
        public void generateGetUsing(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.beginControlFlow("if (!$N)", this.isNull());
            }
            methodBuilder.addStatement("$N.setLength(0)", CharSequenceFieldModel.this.usingName());
            methodBuilder.addStatement("$N.append($N)", CharSequenceFieldModel.this.usingName(), this.field);
            CharSequenceFieldModel.this.returnNotNullGetUsing(methodBuilder);
            if (CharSequenceFieldModel.this.nullable()) {
                CharSequenceFieldModel.this.nullGetBranch(methodBuilder, CharSequenceFieldModel.this.getUsing);
            }
        }

        @Override
        public void generateArrayElementGetUsing(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.beginControlFlow("if (!$N[index])", this.isNull());
            }
            methodBuilder.addStatement("$N.setLength(0)", CharSequenceFieldModel.this.usingName());
            methodBuilder.addStatement("$N.append($N[index])", CharSequenceFieldModel.this.usingName(), this.field);
            CharSequenceFieldModel.this.returnNotNullGetUsing(methodBuilder);
            if (CharSequenceFieldModel.this.nullable()) {
                CharSequenceFieldModel.this.nullGetBranch(methodBuilder, arrayFieldModel.getUsing);
            }
        }

        @Override
        public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            CharSequenceFieldModel.this.checkHeapArgument(methodBuilder);
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.beginControlFlow("if ($N != null)", CharSequenceFieldModel.this.varName());
                methodBuilder.addStatement("$N = false", this.isNull());
                methodBuilder.addStatement("$N.setLength(0)", this.field);
                methodBuilder.addStatement("$N.append($N)", this.field, CharSequenceFieldModel.this.varName());
                methodBuilder.nextControlFlow("else", new Object[0]);
                methodBuilder.addStatement("$N = true", this.isNull());
                methodBuilder.endControlFlow();
            } else {
                methodBuilder.addStatement("$N.setLength(0)", this.field);
                methodBuilder.addStatement("$N.append($N)", this.field, CharSequenceFieldModel.this.varName());
            }
        }

        @Override
        public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            CharSequenceFieldModel.this.checkHeapArgument(methodBuilder);
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.beginControlFlow("if ($N != null)", CharSequenceFieldModel.this.varName());
                methodBuilder.addStatement("$N[index] = false", this.isNull());
                methodBuilder.addStatement("$N[index].setLength(0)", this.field);
                methodBuilder.addStatement("$N[index].append($N)", this.field, CharSequenceFieldModel.this.varName());
                methodBuilder.nextControlFlow("else", new Object[0]);
                methodBuilder.addStatement("$N[index] = true", this.isNull());
                methodBuilder.endControlFlow();
            } else {
                methodBuilder.addStatement("$N[index].setLength(0)", this.field);
                methodBuilder.addStatement("$N[index].append($N)", this.field, CharSequenceFieldModel.this.varName());
            }
        }

        @Override
        public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.get != null) {
                boolean hasGetUsing;
                boolean bl = hasGetUsing = CharSequenceFieldModel.this.getUsing != null;
                if (hasGetUsing) {
                    ClassName heapClassName = valueBuilder.className();
                    methodBuilder.beginControlFlow("if (from instanceof $T)", heapClassName);
                }
                methodBuilder.addStatement("this.$N(from.$N())", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.get.getName());
                if (hasGetUsing) {
                    methodBuilder.nextControlFlow("else", new Object[0]);
                    this.copyFromWithGetUsing(methodBuilder);
                    methodBuilder.endControlFlow();
                }
            } else {
                this.copyFromWithGetUsing(methodBuilder);
            }
        }

        private void copyFromWithGetUsing(MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.getUsing.getReturnType() == Void.TYPE) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("from.$N($N)", CharSequenceFieldModel.this.getUsing.getName(), this.field);
                } else {
                    CharSequenceFieldModel.this.throwNullableGetUsingVoidReturn();
                }
            } else {
                String getUsingResult = String.format("from.%s(%s)", CharSequenceFieldModel.this.getUsing.getName(), this.field.name);
                methodBuilder.addStatement("$T $N = $N", CharSequence.class, CharSequenceFieldModel.this.varName(), getUsingResult);
                methodBuilder.addStatement("$N = $N == null", this.isNull(), CharSequenceFieldModel.this.varName());
            }
        }

        @Override
        public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.get != null) {
                boolean nonStringWithGetUsing;
                boolean bl = nonStringWithGetUsing = CharSequenceFieldModel.this.getUsing != null && CharSequenceFieldModel.this.type != String.class;
                if (nonStringWithGetUsing) {
                    ClassName heapClassName = valueBuilder.className();
                    methodBuilder.beginControlFlow("if (from instanceof $T)", heapClassName);
                }
                methodBuilder.addStatement("this.$N(index, from.$N(index))", CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.get.getName());
                if (nonStringWithGetUsing) {
                    methodBuilder.nextControlFlow("else", new Object[0]);
                    this.arrayElementCopyFromWithGetUsing(methodBuilder);
                    methodBuilder.endControlFlow();
                }
            } else {
                this.arrayElementCopyFromWithGetUsing(methodBuilder);
            }
        }

        private void arrayElementCopyFromWithGetUsing(MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.getUsing.getReturnType() == Void.TYPE) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("from.$N(index, $N)", CharSequenceFieldModel.this.getUsing.getName(), this.field);
                } else {
                    CharSequenceFieldModel.this.throwNullableGetUsingVoidReturn();
                }
            } else {
                String getUsingResult = String.format("from.%s(index, %s)", CharSequenceFieldModel.this.getUsing.getName(), this.field.name);
                methodBuilder.addStatement("$T $N = $N", CharSequence.class, CharSequenceFieldModel.this.varName(), getUsingResult);
                methodBuilder.addStatement("$N[index] = $N == null", this.isNull(), CharSequenceFieldModel.this.varName());
            }
        }

        @Override
        void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.addStatement("bytes.writeUtf8(!$N ? $N : null)", this.isNull(), this.field);
            } else {
                methodBuilder.addStatement("bytes.writeUtf8($N)", this.field);
            }
        }

        @Override
        void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.addStatement("bytes.writeUtf8(!$N[index] ? $N[index] : null)", this.isNull(), this.field);
            } else {
                methodBuilder.addStatement("bytes.writeUtf8($N[index])", this.field);
            }
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.addStatement("$N = !bytes.readUtf8($N)", this.isNull(), this.field);
            } else {
                methodBuilder.beginControlFlow("if (!bytes.readUtf8($N))", this.field);
                methodBuilder.addStatement("throw new $T($S)", IllegalStateException.class, CharSequenceFieldModel.this.name + " shouldn't be null");
                methodBuilder.endControlFlow();
            }
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                methodBuilder.addStatement("$N[index] = !bytes.readUtf8($N[index])", this.isNull(), this.field);
            } else {
                methodBuilder.beginControlFlow("if (!bytes.readUtf8($N[index]))", this.field);
                methodBuilder.addStatement("throw new $T($S + index + $N)", IllegalStateException.class, CharSequenceFieldModel.this.name + " at ", " shouldn't be null");
                methodBuilder.endControlFlow();
            }
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.get == null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("other.$N($N)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    methodBuilder.addCode("if (!$T.equals($N, $N)) return false;\n", CharSequences.class, this.field, CharSequenceFieldModel.this.cachedStringBuilder());
                } else if (CharSequenceFieldModel.this.getUsing.getReturnType() != Void.TYPE) {
                    methodBuilder.addCode("if (!$T.equals(!$N ? $N : null, other.$N($N))) return false;\n", CharSequences.class, this.isNull(), this.field, CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                } else {
                    CharSequenceFieldModel.this.throwNullableGetUsingVoidReturn();
                }
            } else {
                methodBuilder.addCode("if (!$T.equals(this.$N(), other.$N())) return false;\n", CharSequences.class, CharSequenceFieldModel.this.get.getName(), CharSequenceFieldModel.this.get.getName());
            }
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            Method getUsing = arrayFieldModel.getUsing;
            if (CharSequenceFieldModel.this.get == null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("other.$N(index, $N)", getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    methodBuilder.addCode("if (!$T.equals($N[index], $N)) return false;\n", CharSequences.class, this.field, CharSequenceFieldModel.this.cachedStringBuilder());
                } else if (getUsing.getReturnType() != Void.TYPE) {
                    methodBuilder.addCode("if (!$T.equals(!$N[index] ? $N[index] : null, other.$N(index, $N))) return false;\n", CharSequences.class, this.isNull(), this.field, getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                } else {
                    CharSequenceFieldModel.this.throwNullableGetUsingVoidReturn();
                }
            } else {
                methodBuilder.addCode("if (!$T.equals(this.$N(index), other.$N(index))) return false;\n", CharSequences.class, CharSequenceFieldModel.this.get.getName(), CharSequenceFieldModel.this.get.getName());
            }
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String prefix = "net.openhft.chronicle.values.CharSequences.hashCode(";
            if (CharSequenceFieldModel.this.nullable()) {
                return "(!" + this.isNull() + " ? " + prefix + this.field.name + ") : 0)";
            }
            return prefix + this.field.name + ")";
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String prefix = "net.openhft.chronicle.values.CharSequences.hashCode(";
            if (CharSequenceFieldModel.this.nullable()) {
                return "(!" + this.isNull() + "[index] ? " + prefix + this.field.name + "[index]) : 0)";
            }
            return prefix + this.field.name + "[index])";
        }

        @Override
        void generateToString(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                this.genToString(methodBuilder, String.format("!%s ? %s : null", this.isNull(), this.field.name));
            } else {
                this.genToString(methodBuilder, this.field.name);
            }
        }

        @Override
        void generateArrayElementToString(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.nullable()) {
                String value = String.format("!%s[index] ? %s[index] : null", this.isNull(), this.field.name);
                this.genToString(methodBuilder, value);
            } else {
                this.genToString(methodBuilder, this.field.name + "[index]");
            }
        }
    };

    CharSequenceFieldModel() {
    }

    @Override
    void addTypeInfo(Method m3, MethodTemplate template) {
        if (!template.regex.startsWith("getUsing")) {
            super.addTypeInfo(m3, template);
        }
        this.nullability.addInfo(m3, template);
        Parameter annotatedParameter = template.annotatedParameter.apply(m3);
        if (annotatedParameter == null) {
            return;
        }
        MaxUtf8Length paramMaxUtf8Length = annotatedParameter.getAnnotation(MaxUtf8Length.class);
        if (paramMaxUtf8Length != null) {
            if (this.maxUtf8Length != null) {
                throw new IllegalStateException("@MaxUtf8Length should be specified only once for " + this.name + " field. Specified " + this.maxUtf8Length + " and " + paramMaxUtf8Length);
            }
            if (paramMaxUtf8Length.value() <= 0) {
                throw new IllegalStateException(paramMaxUtf8Length + " max size should be positive");
            }
            this.maxUtf8Length = paramMaxUtf8Length;
        }
    }

    @Override
    int sizeInBits() {
        if (this.maxUtf8Length == null) {
            throw new IllegalStateException("@MaxUtf8Length must be specified for a field " + this.name);
        }
        int sizeInBytes = BytesUtil.stopBitLength(this.maxUtf8Length.value()) + this.maxUtf8Length.value();
        return sizeInBytes * 8;
    }

    @Override
    int offsetAlignmentInBytes() {
        if (this.offsetAlignment == -1) {
            throw new IllegalStateException("Default offset alignment doesn't make sense for CharSequence field " + this.name);
        }
        return Math.max(this.offsetAlignment, 1);
    }

    @Override
    void checkState() {
        super.checkState();
        this.checkUnsupported(this.getVolatile);
        this.checkUnsupported(this.setVolatile);
        this.checkUnsupported(this.setOrdered);
        this.checkUnsupported(this.add);
        this.checkUnsupported(this.addAtomic);
        this.checkUnsupported(this.compareAndSwap);
    }

    private void checkUnsupported(Method m3) {
        if (m3 != null) {
            throw new IllegalStateException(this.type.getSimpleName() + "-typed field " + this.name + "cannot have method " + m3.getName());
        }
    }

    private String cachedStringBuilder() {
        return this.varName() + "Builder";
    }

    private String cachedBuilderToSettable() {
        if (this.type == String.class) {
            return this.cachedStringBuilder() + ".toString()";
        }
        return this.cachedStringBuilder();
    }

    private void addCachedStringBuilder(ValueBuilder valueBuilder) {
        FieldSpec cachedStringBuilder = FieldSpec.builder(StringBuilder.class, this.cachedStringBuilder(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T($L)", StringBuilder.class, this.maxUtf8Length.value()).build();
        valueBuilder.typeBuilder.addField(cachedStringBuilder);
    }

    private void throwNullableGetUsingVoidReturn() {
        throw new IllegalStateException(this.name + " field nullable " + this.get.getName() + "() shouldn't return void, because null value is indistinguishable from empty string. Specify the parameter in " + this.set.getName() + " method as @NotNull");
    }

    private void nullGetBranch(MethodSpec.Builder methodBuilder, Method get) {
        methodBuilder.nextControlFlow("else", new Object[0]);
        if (this.nullable()) {
            if (get.getReturnType() != Void.TYPE) {
                methodBuilder.addStatement("return null", new Object[0]);
            } else {
                this.throwNullableGetUsingVoidReturn();
            }
        } else {
            methodBuilder.addStatement("throw new $T($S)", IllegalStateException.class, this.name + " shouldn't be null");
        }
        methodBuilder.endControlFlow();
    }

    private boolean nullable() {
        return this.nullability.nullability() == Nullability.NULLABLE;
    }

    private void returnNotNullGetUsing(MethodSpec.Builder methodBuilder) {
        if (this.getUsing.getReturnType() == String.class) {
            methodBuilder.addStatement("return $N.toString()", this.usingName());
        } else if (this.getUsing.getReturnType() != Void.TYPE) {
            methodBuilder.addStatement("return $N", this.usingName());
        }
    }

    @Override
    MemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    private void checkHeapArgument(MethodSpec.Builder methodBuilder) {
        if (!this.nullable()) {
            this.checkArgumentNotNull(methodBuilder);
        }
    }

    @Override
    MemberGenerator heapGenerator() {
        return this.type == String.class ? this.stringHeapGenerator : this.charSequenceHeapGenerator;
    }
}

