/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.Nullable;

public class TextReadDocumentContext
implements ReadDocumentContext {
    public static final BytesStore MSG_SEP = BytesStore.from("---");
    @Nullable
    protected TextWire wire;
    protected boolean present;
    protected boolean notComplete;
    private boolean metaData;
    private long readPosition;
    private long readLimit;

    public TextReadDocumentContext(@Nullable TextWire wire) {
        this.wire = wire;
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void metaData(boolean metaData) {
        this.metaData = metaData;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void closeReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    @Override
    public void closeReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    @Override
    @Nullable
    public Wire wire() {
        return this.wire;
    }

    @Override
    public void close() {
        long readLimit = this.readLimit;
        long readPosition = this.readPosition;
        TextWire wire0 = this.wire;
        wire0.bytes.readLimit(readLimit);
        wire0.bytes.readPosition(readPosition);
        this.present = false;
    }

    @Override
    public void start() {
        this.wire.getValueOut().resetBetweenDocuments();
        Bytes<?> bytes = this.wire.bytes();
        this.present = false;
        this.wire.consumePadding();
        if (this.wire.bytes().startsWith(MSG_SEP)) {
            this.wire.bytes().readSkip(3L);
            this.wire.consumePadding();
        }
        if (bytes.readRemaining() < 1L) {
            this.readLimit = this.readPosition = bytes.readLimit();
            this.notComplete = false;
            return;
        }
        long position = bytes.readPosition();
        this.wire.getValueIn().skipValue();
        this.metaData = false;
        this.readLimit = bytes.readLimit();
        this.readPosition = bytes.readPosition();
        bytes.readLimit(bytes.readPosition());
        bytes.readPosition(position);
        this.present = true;
    }

    @Override
    public long index() {
        return 0L;
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return this.notComplete;
    }

    public String toString() {
        return Wires.fromSizePrefixedBlobs(this);
    }
}

