/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.Int24Int24MultiMap;
import net.openhft.chronicle.map.IntIntMultiMap;
import net.openhft.chronicle.map.MultiMap;
import net.openhft.chronicle.map.ShortShortMultiMap;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;

enum MultiMapFactory {
    I16{

        @Override
        public long sizeInBytes(long minCapacity) {
            return ShortShortMultiMap.sizeInBytes(minCapacity);
        }

        @Override
        public MultiMap create(Bytes bytes, Bytes bitSetBytes) {
            return new ShortShortMultiMap(bytes, bitSetBytes);
        }
    }
    ,
    I24{

        @Override
        public long sizeInBytes(long minCapacity) {
            return Int24Int24MultiMap.sizeInBytes(minCapacity);
        }

        @Override
        public MultiMap create(Bytes bytes, Bytes bitSetBytes) {
            return new Int24Int24MultiMap(bytes, bitSetBytes);
        }
    }
    ,
    I32{

        @Override
        public long sizeInBytes(long minCapacity) {
            return IntIntMultiMap.sizeInBytes(minCapacity);
        }

        @Override
        public MultiMap create(Bytes bytes, Bytes bitSetBytes) {
            return new IntIntMultiMap(bytes, bitSetBytes);
        }
    };

    public static final long I16_MAX_CAPACITY = 65536L;
    public static final long MAX_CAPACITY = 0x100000000L;

    public static MultiMapFactory forCapacity(long capacity) {
        if (capacity <= 65536L) {
            return I16;
        }
        if (capacity <= 0x100000000L) {
            return I32;
        }
        throw new IllegalArgumentException("Capacity " + capacity + " not supported");
    }

    public static long sizeOfBitSetInBytes(long actualChunksPerSegment) {
        return MemoryUnit.LONGS.align(MemoryUnit.BYTES.alignAndConvert(actualChunksPerSegment, MemoryUnit.BITS), MemoryUnit.BYTES);
    }

    public static DirectBitSet newPositions(long capacity) {
        if (!Maths.isPowerOf2(capacity)) {
            throw new AssertionError((Object)"capacity should be a power of 2");
        }
        capacity = MemoryUnit.LONGS.align(capacity, MemoryUnit.BITS);
        return ATSDirectBitSet.wrap(DirectStore.allocateLazy(MemoryUnit.BYTES.convert(capacity, MemoryUnit.BITS)).bytes());
    }

    static long multiMapCapacity(long minCapacity) {
        if (minCapacity < 0L) {
            throw new IllegalArgumentException("minCapacity should be positive");
        }
        long capacity = Maths.nextPower2(minCapacity, 16L);
        if ((double)minCapacity / (double)capacity > 0.6666666666666666) {
            capacity <<= 1;
        }
        return capacity;
    }

    public abstract long sizeInBytes(long var1);

    public abstract MultiMap create(Bytes var1, Bytes var2);
}

