/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import net.openhft.lang.io.AbstractMappedStore;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.JDKZObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;

public final class ResizeableMappedStore
extends AbstractMappedStore {
    public ResizeableMappedStore(File file, FileChannel.MapMode mode, long size) throws IOException {
        this(file, mode, size, BytesMarshallableSerializer.create(new VanillaBytesMarshallerFactory(), JDKZObjectSerializer.INSTANCE));
    }

    public ResizeableMappedStore(File file, FileChannel.MapMode mode, long size, ObjectSerializer objectSerializer) throws IOException {
        super(new AbstractMappedStore.MmapInfoHolder(), file, mode, 0L, size, objectSerializer);
    }

    public void resize(long newSize) throws IOException {
        ResizeableMappedStore.validateSize(newSize);
        this.unmapAndSyncToDisk();
        this.resizeIfNeeded(0L, newSize);
        this.mmapInfoHolder.setSize(newSize);
        this.map(0L);
    }
}

