/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.hashing.Hasher;
import net.openhft.chronicle.hash.serialization.internal.BytesBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DirectBytesBuffer;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;

public abstract class BasicCopyingMetaBytesInterop<E, W>
implements MetaBytesInterop<E, W> {
    static final Provider<DirectBytesBuffer> provider = Provider.of(DirectBytesBuffer.class);
    private static final long serialVersionUID = 0L;
    final DirectBytesBuffer buffer;
    transient long size;
    transient long hash;

    protected BasicCopyingMetaBytesInterop(DirectBytesBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public long size(W writer, E e) {
        return this.size;
    }

    @Override
    public boolean startsWith(W writer, Bytes bytes, E e) {
        return BytesBytesInterop.INSTANCE.startsWith(bytes, this.buffer.buffer);
    }

    @Override
    public long hash(W writer, E e) {
        long h = this.hash;
        if (h == 0L) {
            this.hash = Hasher.hash(this.buffer.buffer);
            return this.hash;
        }
        return h;
    }

    @Override
    public void write(W writer, Bytes bytes, E e) {
        bytes.write(this.buffer.buffer, this.buffer.buffer.position(), this.buffer.buffer.remaining());
    }

    static abstract class BasicCopyingMetaBytesInteropProvider<E, I, MI extends MetaBytesInterop<E, I>>
    implements MetaProvider<E, I, MI> {
        private static final long serialVersionUID = 0L;

        BasicCopyingMetaBytesInteropProvider() {
        }

        @Override
        public ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
            return provider.getCopies(copies);
        }
    }
}

