/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.model;

import java.util.Map;
import java.util.WeakHashMap;
import net.openhft.lang.model.DataValueModel;
import net.openhft.lang.model.DataValueModelImpl;

public enum DataValueModels {

    private static final Map<Class, DataValueModel> MODEL_MAP = new WeakHashMap<Class, DataValueModel>();

    private static synchronized <T> DataValueModel<T> getModel(Class<T> tClass) {
        return MODEL_MAP.get(tClass);
    }

    private static synchronized <T> void putModel(Class<T> tClass, DataValueModel<T> model) {
        MODEL_MAP.put(tClass, model);
    }

    public static <T> DataValueModel<T> acquireModel(Class<T> tClass) {
        if (!tClass.isInterface() || tClass.getClassLoader() == null) {
            throw new IllegalArgumentException(tClass + " not supported");
        }
        DataValueModel<T> model = DataValueModels.getModel(tClass);
        if (model == null) {
            model = new DataValueModelImpl<T>(tClass);
            DataValueModels.putModel(tClass, model);
        }
        return model;
    }
}

