/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.xstream.converters;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.DataValueModel;
import net.openhft.lang.model.DataValueModels;
import net.openhft.lang.model.FieldModel;
import net.openhft.lang.values.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValueConverter
implements Converter {
    private static final Logger LOG = LoggerFactory.getLogger(DataValueConverter.class);

    private static Object toNativeValueObjects(HierarchicalStreamReader reader, Class aClass, UnmarshallingContext context) {
        Object o = DataValueClasses.newDirectInstance(aClass);
        try {
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor p : info.getPropertyDescriptors()) {
                if (!p.getName().equals("value")) continue;
                String value = reader.getValue();
                if (StringValue.class.isAssignableFrom(o.getClass())) {
                    ((StringValue)o).setValue(value);
                    return o;
                }
                Class<?> propertyType = p.getPropertyType();
                Object o1 = context.convertAnother((Object)value, propertyType);
                p.getWriteMethod().invoke(o, o1);
                return o;
            }
        }
        catch (Exception e) {
            throw new ConversionException("class=" + aClass.getName(), (Throwable)e);
        }
        throw new ConversionException("setValue(..) method not found in class=" + aClass.getCanonicalName());
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        String canonicalName = o.getClass().getCanonicalName();
        boolean isNative = canonicalName.endsWith("$$Native");
        boolean isHeap = canonicalName.endsWith("$$Heap");
        if (!isNative && !isHeap) {
            return;
        }
        if (canonicalName.startsWith("net.openhft.lang.values")) {
            Method[] methods;
            for (Method method : methods = o.getClass().getMethods()) {
                if (!method.getName().equals("getValue") || method.getParameterTypes().length != 0) continue;
                try {
                    context.convertAnother(method.invoke(o, new Object[0]));
                    return;
                }
                catch (Exception e) {
                    throw new ConversionException("class=" + canonicalName, (Throwable)e);
                }
            }
            throw new ConversionException("class=" + canonicalName);
        }
        try {
            DataValueModel dataValueModel = DataValueModels.acquireModel(this.interfaceClass(o.getClass()));
            for (Map.Entry<String, FieldModel> p : dataValueModel.fieldMap().entrySet()) {
                FieldModel fileModel = p.getValue();
                if (fileModel.indexedGetter() != null) {
                    try {
                        Field field;
                        Class<?> returnType;
                        Method indexedReadMethod = fileModel.indexedGetter();
                        if (indexedReadMethod == null || (returnType = indexedReadMethod.getReturnType()) == null) continue;
                        String fieldName = "_" + fileModel.name();
                        try {
                            field = o.getClass().getDeclaredField(fieldName);
                        }
                        catch (NoSuchFieldException e1) {
                            throw new ConversionException("JSON conversion of Classes containing arrays is not currently supported, the following field could not be found=" + fileModel.name(), (Throwable)e1);
                        }
                        field.setAccessible(true);
                        Object[] o1 = (Object[])field.get(o);
                        if (o1 == null) continue;
                        writer.startNode(fileModel.name());
                        int i = 0;
                        for (Object f : o1) {
                            if (f == null) continue;
                            writer.startNode(Integer.toString(i++));
                            context.convertAnother(f);
                            writer.endNode();
                        }
                        writer.endNode();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new ConversionException("", (Throwable)e);
                    }
                }
                try {
                    Method readMethod = fileModel.getter();
                    if (readMethod == null) continue;
                    readMethod.setAccessible(true);
                    Object value = readMethod.invoke(o, new Object[0]);
                    if (value == null) {
                        return;
                    }
                    writer.startNode(fileModel.name());
                    context.convertAnother(value);
                    writer.endNode();
                }
                catch (Exception e) {
                    LOG.error("class=" + fileModel.name(), e);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConversionException("class=" + canonicalName, (Throwable)e);
        }
    }

    private Class interfaceClass(Class clazz) throws ClassNotFoundException {
        String className = clazz.getName();
        boolean isNative = className.endsWith("$$Native");
        boolean isHeap = className.endsWith("$$Heap");
        if (!isNative && !isHeap) {
            throw new ClassNotFoundException();
        }
        String nodeName = isNative ? className.substring(0, className.length() - "$$Native".length()) : className.substring(0, className.length() - "$$Heap".length());
        return Class.forName(nodeName);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String canonicalName = context.getRequiredType().getName();
        boolean isNative = canonicalName.endsWith("$$Native");
        boolean isHeap = canonicalName.endsWith("$$Heap");
        if (!isNative && !isHeap) {
            return null;
        }
        if (context.getRequiredType().getName().startsWith("net.openhft.lang.values")) {
            return DataValueConverter.toNativeValueObjects(reader, context.getRequiredType(), context);
        }
        String nodeName = isNative ? canonicalName.substring(0, canonicalName.length() - "$$Native".length()) : canonicalName.substring(0, canonicalName.length() - "$$Heap".length());
        try {
            Class<?> interfaceClass = Class.forName(nodeName);
            Object result = isNative ? DataValueClasses.newDirectInstance(interfaceClass) : DataValueClasses.newInstance(interfaceClass);
            this.fillInObject(reader, context, result);
            return result;
        }
        catch (Exception e) {
            throw new ConversionException("class=" + canonicalName, (Throwable)e);
        }
    }

    private void fillInObject(HierarchicalStreamReader reader, UnmarshallingContext context, Object using) throws ClassNotFoundException {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            DataValueModel dataValueModel = DataValueModels.acquireModel(this.interfaceClass(using.getClass()));
            FieldModel fieldModel = dataValueModel.fieldMap().get(name);
            if (fieldModel.indexedGetter() != null) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    try {
                        String index = reader.getNodeName();
                        int i = Integer.parseInt(index);
                        Method writeMethod = fieldModel.indexedSetter();
                        Class<?>[] parameterTypes = writeMethod.getParameterTypes();
                        if (parameterTypes.length == 2) {
                            Method indexedReadMethod = fieldModel.indexedGetter();
                            indexedReadMethod.setAccessible(true);
                            Object instance = indexedReadMethod.invoke(using, i);
                            this.fillInObject(reader, context, instance);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ConversionException("", (Throwable)e);
                    }
                    reader.moveUp();
                }
                reader.moveUp();
                continue;
            }
            Method setter = fieldModel.setter();
            setter.setAccessible(true);
            Class<?>[] parameterTypes = setter.getParameterTypes();
            if (parameterTypes.length != 1) continue;
            Object object = context.convertAnother(null, parameterTypes[0]);
            try {
                setter.invoke(using, object);
            }
            catch (Exception e) {
                throw new ConversionException("", (Throwable)e);
            }
            reader.moveUp();
        }
    }

    public boolean canConvert(Class clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName.startsWith("net.openhft.lang.values") || canonicalName.endsWith("$$Native") || canonicalName.endsWith("$$Heap");
    }
}

