/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.filter.StreamFilter;
import thredds.inventory.partition.DirectoryBuilder;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.DirectoryPartition;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Variable;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Show;
import ucar.nc2.grib.grib2.Grib2Variable;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CloseableIterator;
import ucar.nc2.util.Counters;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.Indent;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class GCpass1 {
    private static final Logger logger = LoggerFactory.getLogger(GCpass1.class);
    FeatureCollectionConfig config;
    FeatureCollectionConfig.GribConfig gribConfig;
    Formatter fm;
    Counters countersAll;
    Accum accumAll = new Accum();
    Grib1Customizer cust1 = null;
    Grib2Customizer cust2 = null;
    Map<Integer, Grib1Record> gds1set = new HashMap<Integer, Grib1Record>();
    Map<Integer, Grib2Record> gds2set = new HashMap<Integer, Grib2Record>();

    public static void main(String[] args) throws IOException {
        CommandLine cmdLine = new CommandLine("thredds.tdm.GCpass1", args);
        if (cmdLine.help) {
            cmdLine.printUsage();
            return;
        }
        if (cmdLine.cacheDir != null) {
            DiskCache2 gribCache = DiskCache2.getDefault();
            gribCache.setRootDirectory(cmdLine.cacheDir);
            gribCache.setAlwaysUseCache(true);
            GribIndexCache.setDiskCache2(gribCache);
        }
        FeatureCollectionConfig config = new FeatureCollectionConfig("GCpass1", "GCpass1", cmdLine.getFeatureCollectionType(), cmdLine.spec, null, null, null, cmdLine.partitionType.toString(), null);
        FeatureCollectionConfig.GribConfig gribConfig = config.gribConfig;
        gribConfig.useTableVersion = cmdLine.useTableVersion;
        if (cmdLine.rootDir != null && cmdLine.regexp != null) {
            config.setFilter(cmdLine.rootDir, cmdLine.regexp);
        }
        Formatter fm = new Formatter(System.out);
        GCpass1 pass1 = new GCpass1(config, fm);
        pass1.scanAndReport();
    }

    public GCpass1(FeatureCollectionConfig config, Formatter fm) {
        this.config = config;
        this.gribConfig = config.gribConfig;
        this.fm = fm;
        this.config.show(fm);
        fm.format("%n", new Object[0]);
        this.countersAll = new Counters();
        this.countersAll.add("referenceDate").setShowRange(true);
        this.countersAll.add("table version");
        this.countersAll.add("variable");
        this.countersAll.add("gds");
        this.countersAll.add("gdsTemplate");
        this.countersAll.add("vertCoordInGDS");
        this.countersAll.add("predefined");
        this.countersAll.add("thin");
    }

    public void reportAll(Indent indent, Formatter fm) {
        fm.format("%n", new Object[0]);
        this.reportOneHeader(indent, fm);
        fm.format("%s%60s", indent, "grand total");
        fm.format("%8d ", this.accumAll.nfiles);
        fm.format("%8d ", this.accumAll.nrecords);
        fm.format("%8.0f ", Float.valueOf(this.accumAll.indexSize));
        fm.format("%8.0f ", Float.valueOf(this.accumAll.fileSize));
        fm.format("%8d ", this.countersAll.get("variable").getUnique());
        fm.format("%8d ", this.countersAll.get("referenceDate").getUnique());
        fm.format("%8d ", this.countersAll.get("gds").getUnique());
        fm.format("%n", new Object[0]);
        this.countersAll.show(fm);
        if (this.gds1set.size() > 1) {
            fm.format("gds1%n", new Object[0]);
            for (Grib1Record gr1 : this.gds1set.values()) {
                Grib1Gds gds = gr1.getGDS();
                fm.format(" hash %s == %s%n", gds.hashCode(), gds);
            }
        }
        if (this.gds2set.size() > 1) {
            fm.format("gds2%n", new Object[0]);
            for (Integer key : this.gds2set.keySet()) {
                Grib2Record gr2 = this.gds2set.get(key);
                Grib2Gds gds = gr2.getGDS();
                fm.format(" key = %d hash = %s%n", key, gds.hashCode());
                Grib2Show.showGdsTemplate(gr2.getGDSsection(), fm, this.cust2);
                fm.format("%n", new Object[0]);
            }
        }
    }

    public void reportOneHeader(Indent indent, Formatter fm) {
        fm.format("%s%60s #files   #records #idxSize #dataSize #vars  #runtimes    #gds%n", indent, "");
    }

    public CalendarDate reportOneDir(String dir, Accum accum, Counters countersOne, Indent indent, CalendarDate last) {
        this.fm.format("%s%60s", indent, dir + " total");
        this.fm.format("%8d ", accum.nfiles);
        this.fm.format("%8d ", accum.nrecords);
        this.fm.format("%8.3f ", Float.valueOf(accum.indexSize));
        this.fm.format("%8.3f ", Float.valueOf(accum.fileSize));
        this.fm.format("%8d ", countersOne.get("variable").getUnique());
        this.fm.format("%8d ", countersOne.get("referenceDate").getUnique());
        this.fm.format("%8d ", countersOne.get("gds").getUnique());
        this.fm.format("%s ", countersOne.get("referenceDate").showRange());
        CalendarDate first = (CalendarDate)countersOne.get("referenceDate").getFirst();
        if (last != null && first.isBefore(last)) {
            this.fm.format(" ***", new Object[0]);
        }
        this.fm.format("%n", new Object[0]);
        return (CalendarDate)countersOne.get("referenceDate").getLast();
    }

    public void reportOneFileHeader(Indent indent, Formatter fm) {
        fm.format("%s%40s #records   #vars  #runtimes #gds%n", indent, "");
    }

    public void reportOneFile(MFile mfile, int nrecords, Counters countersOne, Indent indent, Formatter fm) {
        fm.format("%s%40s", indent, mfile.getName());
        fm.format("%8d ", nrecords);
        fm.format("%8d ", countersOne.get("variable").getUnique());
        fm.format("%8d ", countersOne.get("referenceDate").getUnique());
        fm.format("%8d ", countersOne.get("gds").getUnique());
        int vertCoordInGDS = countersOne.get("vertCoordInGDS").getUnique();
        int predefined = countersOne.get("predefined").getUnique();
        int thin = countersOne.get("thin").getUnique();
        if (vertCoordInGDS != 0) {
            fm.format("vertCoordInGDS=%d ", vertCoordInGDS);
        }
        if (predefined != 0) {
            fm.format("predefined=%d ", vertCoordInGDS);
        }
        if (thin != 0) {
            fm.format("thin=%d ", vertCoordInGDS);
        }
        fm.format("%n", new Object[0]);
    }

    public void scanAndReport() throws IOException {
        Indent indent = new Indent(2);
        if (this.config.ptype != FeatureCollectionConfig.PartitionType.file) {
            this.reportOneHeader(indent, this.fm);
        }
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = this.config.getCollectionSpecParser(errlog);
        Path rootPath = Paths.get(specp.getRootDir(), new String[0]);
        boolean isGrib1 = this.config.type == FeatureCollectionType.GRIB1;
        try (MCollection topCollection = DirectoryBuilder.factory(this.config, rootPath, true, null, ".ncx4", logger);){
            if (topCollection instanceof DirectoryPartition) {
                DirectoryPartition dpart = (DirectoryPartition)topCollection;
                dpart.putAuxInfo("fcConfig", this.config);
                this.accumAll.add(this.scanDirectoryPartitionRecurse(isGrib1, dpart, this.config, this.countersAll, logger, indent, this.fm));
            } else if (topCollection instanceof DirectoryCollection) {
                this.accumAll.add(this.scanLeafDirectoryCollection(isGrib1, this.config, this.countersAll, logger, rootPath, true, indent, this.fm));
            }
            this.reportAll(indent, this.fm);
        }
    }

    private Accum scanDirectoryPartitionRecurse(boolean isGrib1, DirectoryPartition dpart, FeatureCollectionConfig config, Counters countersParent, Logger logger, Indent indent, Formatter fm) throws IOException {
        fm.format("%n%sDirectory %s%n", indent, dpart.getRoot());
        indent.incr();
        Counters countersPart = countersParent.makeSubCounters();
        Accum accum = new Accum();
        for (MCollection part : dpart.makePartitions(CollectionUpdateType.always)) {
            part.putAuxInfo("fcConfig", config);
            try {
                if (part instanceof DirectoryPartition) {
                    accum.add(this.scanDirectoryPartitionRecurse(isGrib1, (DirectoryPartition)part, config, countersPart, logger, indent, fm));
                    continue;
                }
                Path partPath = Paths.get(part.getRoot(), new String[0]);
                accum.add(this.scanLeafDirectoryCollection(isGrib1, config, countersPart, logger, partPath, false, indent, fm));
            }
            catch (Throwable t) {
                logger.warn("Error making partition " + part.getRoot(), t);
                dpart.removePartition(part);
            }
        }
        countersParent.addTo(countersPart);
        accum.last = this.reportOneDir(dpart.getRoot(), accum, countersPart, indent, accum.last);
        indent.decr();
        return accum;
    }

    private Accum scanLeafDirectoryCollection(boolean isGrib1, FeatureCollectionConfig config, Counters parentCounters, Logger logger, Path dirPath, boolean isTop, Indent indent, Formatter fm) throws IOException {
        if (config.ptype == FeatureCollectionConfig.PartitionType.file) {
            this.reportOneFileHeader(indent, fm);
            fm.format("%sDirectory %s%n", indent, dirPath);
        }
        Accum accum = new Accum();
        int nfiles = 0;
        Counters countersThisDir = parentCounters.makeSubCounters();
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = config.getCollectionSpecParser(errlog);
        DirectoryCollection dcm = new DirectoryCollection(config.collectionName, dirPath, isTop, config.olderThan, logger);
        dcm.putAuxInfo("fcConfig", config);
        if (specp.getFilter() != null) {
            dcm.setStreamFilter(new StreamFilter(specp.getFilter(), specp.getFilterOnName()));
        }
        try (CloseableIterator<MFile> iter = dcm.getFileIterator();){
            while (iter.hasNext()) {
                MFile mfile = (MFile)iter.next();
                Counters countersOneFile = countersThisDir.makeSubCounters();
                int nrecords = 0;
                if (isGrib1) {
                    Grib1Index grib1Index = this.readGrib1Index(mfile, false);
                    if (grib1Index == null) {
                        System.out.printf("%s%s: read or create failed%n", indent, mfile.getPath());
                        continue;
                    }
                    for (Grib1Record grib1Record : grib1Index.getRecords()) {
                        this.accumGrib1Record(grib1Record, countersOneFile);
                        ++nrecords;
                    }
                } else {
                    Grib2Index grib2Index = this.readGrib2Index(mfile, false);
                    if (grib2Index == null) {
                        System.out.printf("%s%s: read or create failed%n", indent, mfile.getPath());
                        continue;
                    }
                    for (Grib2Record grib2Record : grib2Index.getRecords()) {
                        this.accumGrib2Record(grib2Record, countersOneFile);
                        ++nrecords;
                    }
                }
                accum.nrecords += nrecords;
                countersThisDir.addTo(countersOneFile);
                if (config.ptype == FeatureCollectionConfig.PartitionType.file) {
                    this.reportOneFile(mfile, nrecords, countersOneFile, indent, fm);
                }
                ++nfiles;
                String path = mfile.getPath();
                if (path.endsWith(".gbx9")) {
                    accum.indexSize += (float)mfile.getLength() / 1000000.0f;
                    continue;
                }
                accum.fileSize += (float)mfile.getLength() / 1000000.0f;
                File idxFile = GribIndexCache.getExistingFileOrCache(path + ".gbx9");
                if (!idxFile.exists()) continue;
                accum.indexSize += (float)idxFile.length() / 1000000.0f;
            }
        }
        parentCounters.addTo(countersThisDir);
        accum.nfiles += nfiles;
        accum.last = this.reportOneDir(dirPath.toString(), accum, countersThisDir, indent, accum.last);
        return accum;
    }

    private void accumGrib1Record(Grib1Record gr, Counters counters) throws IOException {
        if (this.cust1 == null) {
            this.cust1 = Grib1Customizer.factory(gr, null);
        }
        Grib1SectionGridDefinition gdss = gr.getGDSsection();
        Grib1SectionProductDefinition pds = gr.getPDSsection();
        String table = pds.getCenter() + "-" + pds.getSubCenter() + "-" + pds.getTableVersion();
        counters.count("table version", (Comparable)((Object)table));
        counters.count("referenceDate", pds.getReferenceDate());
        int gdsHash = gr.getGDS().hashCode();
        int cdmHash = Grib1Variable.cdmVariableHash(this.cust1, gr, gdsHash, this.gribConfig.useTableVersion, this.gribConfig.intvMerge, this.gribConfig.useCenter);
        String name = Grib1Iosp.makeVariableName(this.cust1, this.gribConfig, pds);
        counters.count("variable", new Variable(cdmHash, name));
        if (counters.count("gds", Integer.valueOf(gdsHash))) {
            this.storeGrib1Record(gdsHash, gr);
        }
        counters.count("gdsTemplate", Integer.valueOf(gdss.getGridTemplate()));
        if (gdss.isThin()) {
            counters.count("thin", Integer.valueOf(gdss.getGridTemplate()));
        }
        if (!pds.gdsExists()) {
            counters.count("predefined", Integer.valueOf(gdss.getPredefinedGridDefinition()));
        }
        if (gdss.hasVerticalCoordinateParameters()) {
            counters.count("vertCoordInGDS", Integer.valueOf(pds.getLevelType()));
        }
    }

    private void accumGrib2Record(Grib2Record gr, Counters counters) throws IOException {
        if (this.cust2 == null) {
            this.cust2 = Grib2Customizer.factory(gr);
        }
        Grib2SectionIdentification id = gr.getId();
        String table = id.getCenter_id() + "-" + id.getSubcenter_id() + "-" + id.getMaster_table_version() + "-" + id.getLocal_table_version();
        counters.count("table version", (Comparable)((Object)table));
        counters.count("referenceDate", gr.getReferenceDate());
        int cdmHash = Grib2Variable.cdmVariableHash(this.cust2, gr, 0, this.gribConfig.intvMerge, this.gribConfig.useGenType);
        String name = GribUtils.makeNameFromDescription(this.cust2.getVariableName(gr));
        counters.count("variable", new Variable(cdmHash, name));
        int gdsHash = gr.getGDS().hashCode();
        if (counters.count("gds", Integer.valueOf(gdsHash))) {
            this.storeGrib2Record(gdsHash, gr);
        }
        counters.count("gdsTemplate", Integer.valueOf(gr.getGDSsection().getGDSTemplateNumber()));
    }

    private Grib1Index readGrib1Index(MFile mf, boolean readOnly) throws IOException {
        Grib1Index index;
        String path = mf.getPath();
        if (path.endsWith(".gbx9")) {
            path = StringUtil2.removeFromEnd(path, ".gbx9");
        }
        if (!(index = new Grib1Index()).readIndex(path, mf.getLastModified(), CollectionUpdateType.test)) {
            if (readOnly) {
                return null;
            }
            try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
                if (!Grib1RecordScanner.isValidFile(raf)) {
                    Grib1Index grib1Index = null;
                    return grib1Index;
                }
                index.makeIndex(path, raf);
            }
        }
        return index;
    }

    private Grib2Index readGrib2Index(MFile mf, boolean readOnly) throws IOException {
        Grib2Index index;
        String path = mf.getPath();
        if (path.endsWith(".gbx9")) {
            path = StringUtil2.removeFromEnd(path, ".gbx9");
        }
        if (!(index = new Grib2Index()).readIndex(path, mf.getLastModified(), CollectionUpdateType.test)) {
            if (readOnly) {
                return null;
            }
            try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
                if (!Grib2RecordScanner.isValidFile(raf)) {
                    Grib2Index grib2Index = null;
                    return grib2Index;
                }
                index.makeIndex(path, raf);
            }
        }
        return index;
    }

    private void storeGrib1Record(int hash, Grib1Record gr1) {
        this.gds1set.put(hash, gr1);
    }

    private void storeGrib2Record(int hash, Grib2Record gr2) {
        this.gds2set.put(hash, gr2);
    }

    static class Variable
    implements Comparable<Variable> {
        int cdmHash;
        String name;

        Variable(int cdmHash, String name) {
            this.cdmHash = cdmHash;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.cdmHash == variable.cdmHash;
        }

        public int hashCode() {
            return this.cdmHash;
        }

        @Override
        public int compareTo(Variable o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Accum {
        CalendarDate last = null;
        int nfiles;
        int nrecords;
        float fileSize;
        float indexSize;

        void add(Accum a) {
            this.nfiles += a.nfiles;
            this.nrecords += a.nrecords;
            this.fileSize += a.fileSize;
            this.indexSize += a.indexSize;
        }
    }

    private static class CommandLine {
        @Parameter(names={"-spec"}, description="Collection specification string, exactly as in the <featureCollection>.", required=false)
        public String spec;
        @Parameter(names={"-rootDir"}, description="Collection rootDir, exactly as in the <featureCollection>.", required=false)
        public String rootDir;
        @Parameter(names={"-regexp"}, description="Collection regexp string, exactly as in the <featureCollection>.", required=false)
        public String regexp;
        @Parameter(names={"-isGrib2"}, description="Is Grib2 collection.", required=false)
        public boolean isGrib2 = false;
        @Parameter(names={"-partition"}, description="Partition type: none, directory, file", required=false)
        public FeatureCollectionConfig.PartitionType partitionType = FeatureCollectionConfig.PartitionType.directory;
        @Parameter(names={"-useTableVersion"}, description="Use Table version to make seperate variables.", required=false)
        public boolean useTableVersion = false;
        @Parameter(names={"-useCacheDir"}, description="Set the Grib index cache directory.", required=false)
        public String cacheDir;
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public boolean help = false;
        private final JCommander jc;

        public CommandLine(String progName, String[] args) throws ParameterException {
            this.jc = new JCommander((Object)this, args);
            this.jc.setProgramName(progName);
        }

        public void printUsage() {
            this.jc.usage();
        }

        FeatureCollectionType getFeatureCollectionType() {
            return this.isGrib2 ? FeatureCollectionType.GRIB2 : FeatureCollectionType.GRIB1;
        }
    }
}

