/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.xstream.converters.AbstractChronicleMapConverter;
import net.openhft.xstream.converters.ByteBufferConverter;
import net.openhft.xstream.converters.DataValueConverter;
import net.openhft.xstream.converters.StatelessChronicleMapConverter;
import net.openhft.xstream.converters.VanillaChronicleMapConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(StatelessChronicleMap.class);

    JsonSerializer() {
    }

    static synchronized <K, V> void getAll(File toFile, Map<K, V> map, List jsonConverters) throws IOException {
        XStream xstream = JsonSerializer.xStream(map, jsonConverters);
        OutputStream outputStream = new FileOutputStream(toFile);
        if (toFile.getName().toLowerCase().endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        try (FileOutputStream out = outputStream;){
            xstream.toXML(map, (OutputStream)out);
        }
    }

    static synchronized <K, V> void putAll(File fromFile, Map<K, V> map, List jsonConverters) throws IOException {
        XStream xstream = JsonSerializer.xStream(map, jsonConverters);
        InputStream inputStream = new FileInputStream(fromFile);
        if (fromFile.getName().toLowerCase().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        try (FileInputStream out = inputStream;){
            xstream.fromXML((InputStream)out);
        }
    }

    private static <K, V> XStream xStream(Map<K, V> map, List jsonConverters) {
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
            xstream.setMode(1001);
            xstream.alias("cmap", map.getClass());
            JsonSerializer.registerChronicleMapConverter(map, xstream);
            xstream.registerConverter((Converter)new ByteBufferConverter());
            xstream.registerConverter((Converter)new DataValueConverter());
            for (Object c : jsonConverters) {
                if (c instanceof Converter) {
                    xstream.registerConverter((Converter)c);
                    continue;
                }
                LOG.warn("Skipping Converter of type class=" + c.getClass().getName() + " as " + " expecting an object of type com.thoughtworks.xstream.converters" + ".Converter");
            }
            return xstream;
        }
        catch (NoClassDefFoundError e) {
            JsonSerializer.logErrorSuggestXStreem(e);
            throw e;
        }
    }

    private static void logErrorSuggestXStreem(Error e) {
        LOG.error("map.getAll(<file>) and map.putAll(<file>) methods require the JSON XStream serializer, we don't include these artifacts by default as some users don't require this functionality. Please add the following artifacts to your project\n<dependency>\n <groupId>xstream</groupId>\n <artifactId>xstream</artifactId>\n <version>1.2.2</version>\n</dependency>\n<dependency>\n <groupId>org.codehaus.jettison</groupId>\n <artifactId>jettison</artifactId>\n <version>1.3.6</version>\n</dependency>\n", e);
    }

    private static <K, V> void registerChronicleMapConverter(Map<K, V> map, XStream xstream) {
        AbstractChronicleMapConverter converter = map instanceof StatelessChronicleMap ? new StatelessChronicleMapConverter<K, V>(map) : new VanillaChronicleMapConverter<K, V>(map);
        xstream.registerConverter(converter);
    }
}

