/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import java.util.Map;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.tracker.DatasetExt;
import thredds.server.catalog.tracker.DatasetTracker;

public class DatasetTrackerChronicle
implements DatasetTracker {
    private static Logger catalogInitLog = LoggerFactory.getLogger("catalogInit");
    private static final String datasetName = "/chronicle.datasets.dat";
    private boolean alreadyExists;
    private boolean changed;
    private File dbFile;
    private long maxDatasets;
    private ChronicleMap<String, DatasetExt> datasetMap;

    public static void cleanupBefore(String pathname, long trackerNumber) {
        File oldDatabaseFile;
        for (long tnum = trackerNumber - 1L; tnum > 0L && (oldDatabaseFile = new File(pathname + datasetName + "." + tnum)).exists(); --tnum) {
            if (oldDatabaseFile.delete()) {
                catalogInitLog.info("DatasetTrackerChronicle deleted {} ", (Object)oldDatabaseFile.getAbsolutePath());
                continue;
            }
            catalogInitLog.error("DatasetTrackerChronicle not able to delete {} ", (Object)oldDatabaseFile.getAbsolutePath());
        }
    }

    public DatasetTrackerChronicle(String pathname, long maxDatasets, long number) {
        this.dbFile = new File(pathname + datasetName + "." + number);
        this.alreadyExists = this.dbFile.exists();
        this.maxDatasets = maxDatasets;
        try {
            this.open();
            catalogInitLog.info("DatasetTrackerChronicle opened success on '" + this.dbFile.getAbsolutePath() + "'");
        }
        catch (Throwable e) {
            catalogInitLog.error("DatasetTrackerChronicle failed on '" + this.dbFile.getAbsolutePath() + "', delete catalog cache and reload ", e);
            this.reinit();
        }
    }

    @Override
    public void save() throws IOException {
        if (this.changed) {
            System.out.printf("datasetMap was saved%n", new Object[0]);
            this.datasetMap.close();
            this.open();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.datasetMap != null) {
            this.datasetMap.close();
            System.out.printf("datasetMap.close() was called%n", new Object[0]);
            this.datasetMap = null;
        }
    }

    @Override
    public boolean exists() {
        return this.alreadyExists;
    }

    @Override
    public boolean reinit() {
        boolean wasDeleted;
        if (this.dbFile.exists() && !(wasDeleted = this.dbFile.delete())) {
            catalogInitLog.error("DatasetTrackerChronicle not able to delete {} ", (Object)this.dbFile.getAbsolutePath());
            return false;
        }
        try {
            this.open();
            this.alreadyExists = false;
            return true;
        }
        catch (Throwable e) {
            catalogInitLog.error("DatasetTrackerChronicle failed on '" + this.dbFile.getAbsolutePath() + "', delete catalog cache and reload ", e);
            return false;
        }
    }

    private void open() throws IOException {
        ChronicleHashBuilder builder = ChronicleMapBuilder.of(String.class, DatasetExt.class).averageValueSize(200.0).entries(this.maxDatasets);
        this.datasetMap = ((ChronicleMapBuilder)builder).createPersistedTo(this.dbFile);
        this.changed = false;
    }

    @Override
    public boolean trackDataset(long catId, Dataset dataset, DatasetTracker.Callback callback) {
        boolean hasNcml;
        if (callback != null) {
            callback.hasDataset(dataset);
            boolean track = false;
            if (dataset.getRestrictAccess() != null) {
                callback.hasRestriction(dataset);
                track = true;
            }
            if (dataset.getNcmlElement() != null) {
                callback.hasNcml(dataset);
                track = true;
            }
            if (track) {
                callback.hasTrackedDataset(dataset);
            }
        }
        boolean hasRestrict = dataset.getRestrictAccess() != null;
        boolean bl = hasNcml = dataset.getNcmlElement() != null && !(dataset instanceof DatasetScan) && !(dataset instanceof FeatureCollectionRef);
        if (!hasRestrict && !hasNcml) {
            return false;
        }
        String path = null;
        if (dataset instanceof DatasetScan) {
            path = ((DatasetScan)dataset).getPath();
        } else if (dataset instanceof FeatureCollectionRef) {
            path = ((FeatureCollectionRef)dataset).getPath();
        } else {
            for (Access access : dataset.getAccess()) {
                ServiceType st = access.getService().getType();
                if (st == null || !st.isStandardTdsService()) continue;
                String accessPath = access.getUrlPath();
                if (accessPath == null) {
                    catalogInitLog.warn("trackDataset {} access {} has null path", (Object)dataset, (Object)access);
                    continue;
                }
                if (path == null) {
                    path = accessPath;
                    continue;
                }
                if (path.equals(accessPath)) continue;
                System.out.printf(" paths differ: %s%n %s%n%n", path, accessPath);
                catalogInitLog.warn(" paths differ: {} != {}", (Object)path, (Object)accessPath);
            }
        }
        if (path == null) {
            catalogInitLog.debug("trackDataset {} has null path", (Object)dataset);
            return false;
        }
        String ncml = null;
        if (hasNcml) {
            Element ncmlElem = dataset.getNcmlElement();
            XMLOutputter xmlOut = new XMLOutputter();
            ncml = xmlOut.outputString(ncmlElem);
        }
        DatasetExt dsext = new DatasetExt(catId, dataset.getRestrictAccess(), ncml);
        this.datasetMap.put(path, dsext);
        this.changed = true;
        return true;
    }

    @Override
    public String findResourceControl(String path) {
        DatasetExt dext = this.datasetMap.get(path);
        if (dext == null) {
            return null;
        }
        return dext.getRestrictAccess();
    }

    @Override
    public String findNcml(String path) {
        DatasetExt dext = this.datasetMap.get(path);
        if (dext == null) {
            return null;
        }
        return dext.getNcml();
    }

    @Override
    public void showDB(Formatter f) {
        f.format("ChronicleMap %s%n", this.dbFile.getPath());
        int count = 0;
        for (Map.Entry entry : this.datasetMap.entrySet()) {
            f.format("%4d: '%s' == %s%n", count++, entry.getKey(), entry.getValue());
            if (count % 10 != 0) continue;
            f.format("%n", new Object[0]);
        }
    }
}

