/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;

public abstract class CompactOffHeapLinearHashTable {
    public static final int MAX_TIER_CHUNKS = 0x40000000;
    public static final int MAX_TIER_ENTRIES = 0x20000000;
    public static final double MAX_UPPER_BOUND_LOAD_FACTOR = 0.6666666666666667;
    public static final double MAX_LOAD_FACTOR = 0.8;
    public static final long UNSET_KEY = 0L;
    public static final long UNSET_ENTRY = 0L;
    private final long capacityMask;
    final long capacityMask2;
    private final int keyBits;
    private final long keyMask;
    private final long valueMask;

    public static int valueBits(long actualChunksPerSegment) {
        return 64 - Long.numberOfLeadingZeros(actualChunksPerSegment - 1L);
    }

    public static int keyBits(long entriesPerSegment, int valueBits) {
        int minKeyBits = 64 - Long.numberOfLeadingZeros(entriesPerSegment - 1L);
        int actualEntryBits = (int)MemoryUnit.BYTES.align((minKeyBits += 3) + valueBits, MemoryUnit.BITS);
        return actualEntryBits - valueBits;
    }

    public static int entrySize(int keyBits, int valueBits) {
        int entrySize = (int)MemoryUnit.BYTES.alignAndConvert(keyBits + valueBits, MemoryUnit.BITS);
        if (entrySize <= 4) {
            return 4;
        }
        if (entrySize <= 8) {
            return 8;
        }
        return entrySize;
    }

    public static long capacityFor(long entriesPerSegment) {
        if (entriesPerSegment < 0L) {
            throw new AssertionError((Object)("entriesPerSegment should be positive: " + entriesPerSegment));
        }
        long capacity = Maths.nextPower2(entriesPerSegment, 64L);
        if ((double)entriesPerSegment > 0.6666666666666667 * (double)capacity) {
            capacity *= 2L;
        }
        return capacity;
    }

    public static long mask(int bits) {
        return (1L << bits) - 1L;
    }

    CompactOffHeapLinearHashTable(long capacity, int slotSize, int keyBits, int valueBits) {
        this.capacityMask = capacity - 1L;
        this.capacityMask2 = this.capacityMask * (long)slotSize;
        this.keyBits = keyBits;
        this.keyMask = CompactOffHeapLinearHashTable.mask(keyBits);
        this.valueMask = CompactOffHeapLinearHashTable.mask(valueBits);
    }

    CompactOffHeapLinearHashTable(VanillaChronicleHash h) {
        this(h.tierHashLookupCapacity, h.tierHashLookupSlotSize, h.tierHashLookupKeyBits, h.tierHashLookupValueBits);
    }

    abstract long indexToPos(long var1);

    public long maskUnsetKey(long key) {
        return (key &= this.keyMask) != 0L ? key : this.keyMask;
    }

    public void checkValueForPut(long value) {
        assert ((value & (this.valueMask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "Value out of range, was " + value;
    }

    public boolean empty(long entry) {
        return entry == 0L;
    }

    public long key(long entry) {
        return entry & this.keyMask;
    }

    public long value(long entry) {
        return entry >>> this.keyBits & this.valueMask;
    }

    public long entry(long key, long value) {
        return key | value << this.keyBits;
    }

    public long hlPos(long key) {
        return this.indexToPos(key & this.capacityMask);
    }

    public abstract long step(long var1);

    public abstract long stepBack(long var1);

    public abstract long readEntry(long var1, long var3);

    public abstract long readEntryVolatile(long var1, long var3);

    public abstract void writeEntryVolatile(long var1, long var3, long var5, long var7);

    public abstract void writeEntry(long var1, long var3, long var5);

    public abstract void clearEntry(long var1, long var3);

    public long remove(long addr, long posToRemove) {
        long entryToShift;
        long posToShift = posToRemove;
        while (!this.empty(entryToShift = this.readEntry(addr, posToShift = this.step(posToShift)))) {
            boolean cond2;
            long insertPos = this.hlPos(this.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.writeEntry(addr, posToRemove, entryToShift);
            posToRemove = posToShift;
        }
        this.clearEntry(addr, posToRemove);
        return posToRemove;
    }
}

