/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import shaded.org.apache.maven.model.Model;
import shaded.org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public final class BuildVersion {
    private static String version = null;

    public static void main(String[] args) {
        System.out.println(BuildVersion.version());
    }

    public static synchronized String version() {
        if (version != null) {
            return version;
        }
        try {
            InputStream resource = BuildVersion.class.getClassLoader().getResourceAsStream("map.version");
            BufferedReader in = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
            version = in.readLine().trim();
            if (!"${project.version}".equals(BuildVersion.version())) {
                return version;
            }
            return version;
        }
        catch (Exception resource) {
            String versionFromManifest = BuildVersion.getVersionFromManifest();
            if (versionFromManifest != null) {
                version = versionFromManifest;
                return version;
            }
            version = BuildVersion.getVersionFromPom();
            return version;
        }
    }

    private static String getVersionFromManifest() {
        return ChronicleMapBuilder.class.getPackage().getImplementationVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersionFromPom() {
        String absolutePath = new File(BuildVersion.class.getResource(BuildVersion.class.getSimpleName() + ".class").getPath()).getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getAbsolutePath();
        File file = new File(absolutePath + "/pom.xml");
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            Model model = xpp3Reader.read(reader);
            String string = model.getVersion();
            return string;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private BuildVersion() {
    }
}

