/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.core.util.SerializableFunction;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.util.CharSequences;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapEntrySet;
import net.openhft.chronicle.map.ChronicleMapIterator;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.JsonSerializer;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapSegmentContext;
import org.jetbrains.annotations.NotNull;

interface AbstractChronicleMap<K, V>
extends ChronicleMap<K, V> {
    @Override
    default public <R> R getMapped(K key, @NotNull SerializableFunction<? super V, R> function) {
        Objects.requireNonNull(function);
        try (ExternalMapQueryContext c = (ExternalMapQueryContext)this.queryContext(key);){
            HashEntry entry = c.entry();
            R r = entry != null ? (R)function.apply(entry.value().get()) : null;
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void getAll(File toFile) throws IOException {
        AbstractChronicleMap abstractChronicleMap = this;
        synchronized (abstractChronicleMap) {
            JsonSerializer.getAll(toFile, this, Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void putAll(File fromFile) throws IOException {
        AbstractChronicleMap abstractChronicleMap = this;
        synchronized (abstractChronicleMap) {
            JsonSerializer.putAll(fromFile, this, Collections.emptyList());
        }
    }

    @Override
    default public boolean containsValue(Object value) {
        return !this.forEachEntryWhile((Predicate<? super MapEntry<K, V>>)((Predicate<MapEntry>)c -> !c.value().equals(c.context().wrapValueAsData(value))));
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public void forEach(BiConsumer<? super K, ? super V> action) {
        this.forEachEntry((Consumer<? super MapEntry<K, V>>)((Consumer<MapEntry>)c -> action.accept((Object)c.key().get(), (Object)c.value().get())));
    }

    @Override
    default public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    @NotNull
    default public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private Iterator<Map.Entry<K, V>> i;
                    {
                        this.i = AbstractChronicleMap.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.i.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractChronicleMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return AbstractChronicleMap.this.isEmpty();
            }

            @Override
            public void clear() {
                AbstractChronicleMap.this.clear();
            }

            @Override
            public boolean contains(Object v) {
                return AbstractChronicleMap.this.containsValue(v);
            }

            @Override
            public void forEach(Consumer<? super V> action) {
                AbstractChronicleMap.this.forEachEntry(c -> action.accept((Object)c.value().get()));
            }
        };
    }

    @Override
    @NotNull
    default public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new ChronicleMapIterator.OfKeys(AbstractChronicleMap.this);
            }

            @Override
            public int size() {
                return AbstractChronicleMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return AbstractChronicleMap.this.isEmpty();
            }

            @Override
            public void clear() {
                AbstractChronicleMap.this.clear();
            }

            @Override
            public boolean contains(Object k) {
                return AbstractChronicleMap.this.containsKey(k);
            }

            @Override
            public void forEach(Consumer<? super K> action) {
                AbstractChronicleMap.this.forEachEntry(c -> action.accept((Object)c.key().get()));
            }
        };
    }

    default public boolean mapEquals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if ((m instanceof ChronicleMap ? ((ChronicleMap)m).longSize() : (long)m.size()) != this.longSize()) {
            return false;
        }
        try {
            return this.forEachEntryWhile((Predicate<? super MapEntry<K, V>>)((Predicate<MapEntry>)c -> {
                Object k = c.key().get();
                Object v = m.get(k);
                if (v instanceof CharSequence) {
                    return CharSequences.equivalent((CharSequence)v, (CharSequence)c.value().get());
                }
                if (v instanceof Set) {
                    return v.equals(c.value().get());
                }
                if (v instanceof Map) {
                    return v.equals(c.value().get());
                }
                return v != null && c.value().equals(c.context().wrapValueAsData(v));
            }));
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    default public int mapHashCode() {
        int[] h = new int[1];
        this.forEach((k, v) -> {
            h[0] = h[0] + (AbstractChronicleMap.hashCode(k) ^ AbstractChronicleMap.hashCode(v));
        });
        return h[0];
    }

    public static int hashCode(Object obj) {
        if (!(obj instanceof CharSequence)) {
            return obj.hashCode();
        }
        return CharSequences.hash((CharSequence)obj);
    }

    default public String mapToString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.forEach((k, v) -> sb.append(k != this ? k : "(this Map)").append('=').append(v != this ? v : "(this Map)").append(',').append(' '));
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    default public Set<Map.Entry<K, V>> newEntrySet() {
        return new ChronicleMapEntrySet(this);
    }

    @Override
    default public void forEachEntry(Consumer<? super MapEntry<K, V>> action) {
        this.forEachEntryWhile((Predicate<? super MapEntry<K, V>>)((Predicate<MapEntry>)c -> {
            action.accept((Object)c);
            return true;
        }));
    }

    @Override
    default public boolean forEachEntryWhile(Predicate<? super MapEntry<K, V>> action) {
        boolean interrupt = false;
        for (int i = this.segments() - 1; i >= 0; --i) {
            try (MapSegmentContext c = (MapSegmentContext)this.segmentContext(i);){
                if (c.forEachSegmentEntryWhile(action)) continue;
                interrupt = true;
                break;
            }
        }
        return !interrupt;
    }
}

