/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import ucar.httpservices.HTTPConnections;
import ucar.httpservices.HTTPMethod;

class HTTPConnectionPool
extends HTTPConnections {
    protected PoolingHttpClientConnectionManager poolmgr = null;

    public HTTPConnectionPool() {
        super(true);
    }

    protected PoolingHttpClientConnectionManager getPool() {
        if (this.poolmgr == null) {
            this.poolmgr = new PoolingHttpClientConnectionManager(this.getRegistry());
            this.setMaxConnections(this.maxconnections);
        }
        return this.poolmgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientConnectionManager newManager(HTTPMethod m) {
        HTTPConnectionPool hTTPConnectionPool = this;
        synchronized (hTTPConnectionPool) {
            if (TRACE) {
                System.err.println("HTTPConnections: open connection: " + m.hashCode());
            }
            ++this.actualconnections;
            return this.getPool();
        }
    }

    @Override
    public void freeManager(HTTPMethod m) {
        if (TRACE) {
            System.err.println("HTTPConnections: close connection: " + m.hashCode());
        }
        --this.actualconnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HTTPConnectionPool hTTPConnectionPool = this;
        synchronized (hTTPConnectionPool) {
            this.poolmgr.shutdown();
            this.poolmgr = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxConnections(int n) {
        if (n > 0) {
            super.setMaxConnections(n);
            HTTPConnectionPool hTTPConnectionPool = this;
            synchronized (hTTPConnectionPool) {
                if (this.poolmgr != null) {
                    this.poolmgr.setDefaultMaxPerRoute(n);
                    this.poolmgr.setMaxTotal(n);
                }
            }
        }
    }
}

