/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.win32.W32APIOptions;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;

public final class WindowsMsync {
    private static final Kernel32Ex KERNEL_32 = (Kernel32Ex)Native.loadLibrary((String)"kernel32", Kernel32Ex.class, (Map)W32APIOptions.UNICODE_OPTIONS);

    public static void msync(RandomAccessFile raf, long addr, long length) throws IOException {
        boolean success;
        int retry = 0;
        int lastError = 0;
        while (!(success = KERNEL_32.FlushViewOfFile(new Pointer(addr), new BaseTSD.SIZE_T(length))) && (lastError = KERNEL_32.GetLastError()) == 33 && ++retry < 3) {
        }
        if (!success) {
            throw new IOException(Kernel32Util.formatMessageFromLastErrorCode(lastError));
        }
        raf.getChannel().force(false);
    }

    private WindowsMsync() {
    }

    public static interface Kernel32Ex
    extends Kernel32 {
        public boolean FlushViewOfFile(Pointer var1, BaseTSD.SIZE_T var2);
    }
}

