/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import java.lang.reflect.Method;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.ObjectHeapMemberGenerator;
import net.openhft.chronicle.values.ScalarFieldModel;
import net.openhft.chronicle.values.ValueBuilder;
import net.openhft.chronicle.values.ValueModel;
import net.openhft.chronicle.values.Values;

class ValueFieldModel
extends ScalarFieldModel {
    private ValueModel valueModel;
    private final NativeMemberGenerator nativeGenerator = new NativeMemberGenerator();

    ValueFieldModel() {
    }

    private ValueModel valueModel() {
        if (this.valueModel == null) {
            this.valueModel = ValueModel.acquire(this.type);
        }
        return this.valueModel;
    }

    @Override
    int sizeInBits() {
        return this.valueModel().sizeInBytes() * 8;
    }

    @Override
    int offsetAlignmentInBytes() {
        if (this.offsetAlignment == -1) {
            return this.valueModel().recommendedOffsetAlignment();
        }
        return Math.max(1, this.offsetAlignment);
    }

    @Override
    NativeMemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new ObjectHeapMemberGenerator(this){

            @Override
            void generateFields(ValueBuilder valueBuilder) {
                this.field = FieldSpec.builder(ValueFieldModel.this.valueModel().heapClass(), ValueFieldModel.this.fieldName(), Modifier.PRIVATE).initializer("new $T()", ValueFieldModel.this.valueModel().heapClass()).build();
                valueBuilder.typeBuilder.addField(this.field);
            }

            @Override
            void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
                this.field = FieldSpec.builder(ArrayTypeName.of(ValueFieldModel.this.valueModel().heapClass()), ValueFieldModel.this.fieldName(), new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.FINAL).initializer("new $T[$L]", ValueFieldModel.this.valueModel().heapClass(), arrayFieldModel.array.length()).build();
                valueBuilder.typeBuilder.addField(this.field);
                MethodSpec.Builder constructor = valueBuilder.defaultConstructorBuilder();
                constructor.beginControlFlow("for (int index = 0; index < $L; index++)", arrayFieldModel.array.length());
                constructor.addStatement("$N[index] = new $T()", ValueFieldModel.this.fieldName(), ValueFieldModel.this.valueModel().heapClass());
                constructor.endControlFlow();
            }

            @Override
            public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.copyFrom($N)", this.field, ValueFieldModel.this.varName());
            }

            @Override
            public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index].copyFrom($N)", this.field, ValueFieldModel.this.varName());
            }

            @Override
            public void generateSetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.copyFrom($N)", this.field, ValueFieldModel.this.varName());
                methodBuilder.addStatement("$N.storeFence()", valueBuilder.unsafe());
            }

            @Override
            public void generateArrayElementSetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index].copyFrom($N)", this.field, ValueFieldModel.this.varName());
                methodBuilder.addStatement("$N.storeFence()", valueBuilder.unsafe());
            }

            @Override
            public void generateSetOrdered(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                this.generateSetVolatile(valueBuilder, methodBuilder);
            }

            @Override
            public void generateArrayElementSetOrdered(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                this.generateArrayElementSetVolatile(arrayFieldModel, valueBuilder, methodBuilder);
            }

            @Override
            public void generateCompareAndSwap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                throw new UnsupportedOperationException("compareAndSwap() is not supported by value field " + ValueFieldModel.this.name);
            }

            @Override
            public void generateArrayElementCompareAndSwap(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                throw new UnsupportedOperationException("compareAndSwap() is not supported by value field " + ValueFieldModel.this.name);
            }

            @Override
            public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.copyFrom(from.$N())", this.field, this.fieldModel.getOrGetVolatile().getName());
            }

            @Override
            public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("this.$N[index].copyFrom(from.$N(index))", this.field, arrayFieldModel.getOrGetVolatile().getName());
            }

            @Override
            void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.writeMarshallable(bytes)", ValueFieldModel.this.fieldName());
            }

            @Override
            void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index].writeMarshallable(bytes)", ValueFieldModel.this.fieldName());
            }

            @Override
            void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.readMarshallable(bytes)", ValueFieldModel.this.fieldName());
            }

            @Override
            void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index].readMarshallable(bytes)", ValueFieldModel.this.fieldName());
            }

            @Override
            String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                return this.field.name + ".hashCode()";
            }

            @Override
            String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                return this.field.name + "[index].hashCode()";
            }
        };
    }

    final class NativeMemberGenerator
    extends MemberGenerator {
        private Class nativeType;
        FieldSpec cachedValue;

        NativeMemberGenerator() {
            super(ValueFieldModel.this);
        }

        @Override
        public void generateFields(ValueBuilder valueBuilder) {
            this.nativeType = Values.nativeClassFor(ValueFieldModel.this.type);
            this.cachedValue = FieldSpec.builder(this.nativeType, ValueFieldModel.this.name + "CachedValue", Modifier.PRIVATE, Modifier.FINAL).initializer("new $T()", this.nativeType).build();
            valueBuilder.typeBuilder.addField(this.cachedValue);
        }

        @Override
        public void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            this.generateFields(valueBuilder);
        }

        private void initCachedValue(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$T $N = this.$N", this.nativeType, this.cachedValue, this.cachedValue);
            int byteOffset = ValueFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("$N.bytesStore(bs, offset + $L, $L)", this.cachedValue, byteOffset, ValueFieldModel.this.valueModel().sizeInBytes());
        }

        @Override
        public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("return $N", this.cachedValue);
        }

        @Override
        public void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("return $N", this.cachedValue);
        }

        private void initArrayElementCachedValue(ArrayFieldModel arrayField, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$T $N = this.$N", this.nativeType, this.cachedValue, this.cachedValue);
            int arrayByteOffset = arrayField.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayField, methodBuilder);
            methodBuilder.addStatement("$N.bytesStore(bs, offset + $L + elementOffset, $L)", this.cachedValue, arrayByteOffset, ValueFieldModel.this.valueModel().sizeInBytes());
        }

        @Override
        public void generateGetUsing(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("if ($N instanceof $T)", ValueFieldModel.this.varName(), this.nativeType);
            int byteOffset = ValueFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("(($T) $N).bytesStore(bs, offset + $L, $L)", this.nativeType, ValueFieldModel.this.varName(), byteOffset, ValueFieldModel.this.valueModel().sizeInBytes());
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("(($T) $N).copyFrom($N)", Copyable.class, ValueFieldModel.this.varName(), this.cachedValue);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("return $N", ValueFieldModel.this.varName());
        }

        @Override
        public void generateArrayElementGetUsing(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("if ($N instanceof $T)", ValueFieldModel.this.varName(), this.nativeType);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("(($T) $N).bytesStore(bs, offset + $L + elementOffset, $L)", this.nativeType, ValueFieldModel.this.varName(), arrayByteOffset, ValueFieldModel.this.valueModel().sizeInBytes());
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("(($T) $N).copyFrom($N)", Copyable.class, ValueFieldModel.this.varName(), this.cachedValue);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("return $N", ValueFieldModel.this.varName());
        }

        @Override
        public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("if ($N instanceof $T)", ValueFieldModel.this.varName(), this.nativeType);
            int byteOffset = ValueFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("bs.write(offset + $L, (($T) $N).bytesStore(), (($T) $N).offset(), $L)", byteOffset, this.nativeType, ValueFieldModel.this.varName(), this.nativeType, ValueFieldModel.this.varName(), ValueFieldModel.this.valueModel().sizeInBytes());
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.copyFrom($N)", this.cachedValue, ValueFieldModel.this.varName());
            methodBuilder.endControlFlow();
        }

        @Override
        public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("if ($N instanceof $T)", ValueFieldModel.this.varName(), this.nativeType);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("bs.write(offset + $L + elementOffset, (($T) $N).bytesStore(), (($T) $N).offset(), $L)", arrayByteOffset, this.nativeType, ValueFieldModel.this.varName(), this.nativeType, ValueFieldModel.this.varName(), ValueFieldModel.this.valueModel().sizeInBytes());
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.copyFrom($N)", this.cachedValue, ValueFieldModel.this.varName());
            methodBuilder.endControlFlow();
        }

        @Override
        public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            if (ValueFieldModel.this.getUsing != null) {
                methodBuilder.addStatement("from.$N($N)", ValueFieldModel.this.getUsing.getName(), this.cachedValue);
            } else {
                methodBuilder.addStatement("$N.copyFrom(from.$N())", this.cachedValue, ValueFieldModel.this.get.getName());
            }
        }

        @Override
        public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                methodBuilder.addStatement("from.$N(index, $N)", getUsing.getName(), this.cachedValue);
            } else {
                methodBuilder.addStatement("$N.copyFrom(from.$N(index))", this.cachedValue, arrayFieldModel.get.getName());
            }
        }

        @Override
        void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.writeMarshallable(bytes)", this.cachedValue);
        }

        @Override
        void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.writeMarshallable(bytes)", this.cachedValue);
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.readMarshallable(bytes)", this.cachedValue);
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.readMarshallable(bytes)", this.cachedValue);
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addCode("if (!$N.equals(other.$N())) return false;\n", this.cachedValue, ValueFieldModel.this.get.getName());
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addCode("if (!$N.equals(other.$N(index))) return false;\n", this.cachedValue, arrayFieldModel.get.getName());
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            return this.cachedValue.name + ".hashCode()";
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            return this.cachedValue.name + ".hashCode()";
        }

        @Override
        void generateToString(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            this.genToString(methodBuilder, this.cachedValue.name);
        }

        @Override
        void generateArrayElementToString(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            this.genArrayElementToString(methodBuilder, this.cachedValue.name);
        }
    }
}

