/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.TextWire;
import org.jetbrains.annotations.NotNull;

public class TextMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    static boolean ENABLE_EOD = true;
    @NotNull
    private final TextWire wire;

    TextMethodWriterInvocationHandler(@NotNull TextWire wire) {
        this.wire = wire;
        this.recordHistory = wire.recordHistory();
    }

    @Override
    protected void handleInvoke(Method method, Object[] args) {
        this.handleInvoke(method, args, this.wire);
        this.wire.getValueOut().resetBetweenDocuments();
        Bytes<?> bytes = this.wire.bytes();
        if (bytes.peekUnsignedByte(bytes.writePosition() - 1L) >= 32) {
            bytes.append('\n');
        }
        if (ENABLE_EOD) {
            bytes.append("---\n");
        }
    }
}

