/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionSpecParser;
import ucar.nc2.util.AliasTranslator;

@Immutable
public class FeatureCollectionRef
extends CatalogRef {
    final FeatureCollectionConfig config;
    final String topDirectoryLocation;

    public FeatureCollectionRef(DatasetNode parent, String name, String xlink, Map<String, Object> flds, List<AccessBuilder> accessBuilders, List<DatasetBuilder> datasetBuilders, FeatureCollectionConfig config) {
        super(parent, name, xlink, flds, accessBuilders, datasetBuilders);
        this.config = config;
        this.config.spec = AliasTranslator.translateAlias(this.config.spec);
        CollectionSpecParser specp = new CollectionSpecParser(config.spec, null);
        this.topDirectoryLocation = specp.getRootDir();
    }

    public String getPath() {
        return this.config.path;
    }

    public String getTopDirectoryLocation() {
        return this.topDirectoryLocation;
    }

    public String getCollectionName() {
        return this.config.collectionName;
    }

    public FeatureCollectionConfig getConfig() {
        return this.config;
    }

    public FeatureCollectionType getFeatureCollectionType() {
        return this.config.type;
    }
}

