/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.hash.locks.InterProcessDeadLockException;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.hash.serialization.impl.IntegerDataAccess;
import net.openhft.chronicle.hash.serialization.impl.WrongXxHash;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.chronicle.map.impl.ret.UsableReturnValue;
import net.openhft.chronicle.map.impl.stage.data.ZeroBytesStore;
import net.openhft.chronicle.map.impl.stage.query.Absent;
import net.openhft.chronicle.map.impl.stage.query.MapAndSetContext;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.DummyValueData;
import net.openhft.chronicle.set.ExternalSetQueryContext;
import net.openhft.chronicle.set.SetContext;
import net.openhft.chronicle.set.SetEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledMapQueryContext<K, V, R>
extends ChainingInterface
implements AutoCloseable,
ChecksumEntry,
HashEntry<K>,
SegmentLock,
Alloc,
KeyHashCode,
LocksInterface,
ExternalMapQueryContext<K, V, R>,
MapContext<K, V, R>,
MapEntry<K, V>,
QueryContextInterface<K, V, R>,
VanillaChronicleMapHolder<K, V, R>,
Absent<K, V>,
MapAndSetContext<K, V, R>,
ExternalSetQueryContext<K, R>,
SetContext<K, R>,
SetEntry<K> {
    final Thread owner;
    public final ReadLock innerReadLock;
    public final int indexInContextChain;
    public final WriteLock innerWriteLock;
    public final UpdateLock innerUpdateLock;
    final DataAccess<V> innerInputValueDataAccess;
    final DataAccess<K> innerInputKeyDataAccess;
    final InputKeyBytesData inputKeyBytesData;
    final DummyValueZeroData zeroValueData;
    final WrappedValueBytesData wrappedValueBytesData;
    final HashEntryChecksumStrategy hashEntryChecksumStrategy;
    public static final Logger LOG = LoggerFactory.getLogger(CompiledMapQueryContext.class);
    public final AcquireHandle acquireHandle;
    public final UsingReturnValue usingReturnValue;
    public final SizedReader<K> keyReader;
    public final ReusableBitSet freeList;
    public final EntryKeyBytesData entryKey;
    public final SizedReader<V> valueReader;
    public final DefaultReturnValue defaultReturnValue;
    public final EntryValueBytesData entryValue;
    public final ChainingInterface rootContextInThisThread;
    public final PointerBytesStore segmentBS;
    final WrappedValueInstanceDataHolder wrappedValueInstanceDataHolder;
    public final List<ChainingInterface> contextChain;
    public final Bytes segmentBytes;
    public final ChecksumStrategy checksumStrategy;
    private boolean inputKeyDataAccessInitialized = false;
    public long keySize = -1L;
    private boolean inputValueDataAccessInitialized = false;
    public Data<K> inputKey = null;
    public long keyHash = 0L;
    public long pos = -1L;
    public long keyOffset = -1L;
    public long valueSizeOffset = -1L;
    public int allocatedChunks = 0;
    private VanillaChronicleMap<K, V, R> m = null;
    long searchKey = 0L;
    public long searchStartPos;
    public int segmentIndex = -1;
    public long segmentHeaderAddress;
    public SegmentHeader segmentHeader = null;
    public int tier = -1;
    public long tierIndex;
    public long tierBaseAddr;
    public long entrySpaceOffset = 0L;
    public long valueSize = -1L;
    public long valueOffset;
    public long keySizeOffset = -1L;
    public int entrySizeInChunks = 0;
    public boolean used;
    private boolean firstContextLockedInThisThread;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    public boolean nestedContextsLockedOnSameSegment;
    LocksInterface nextNode;
    LocalLockState localLockState;
    public LocksInterface rootContextLockedOnThisSegment = null;
    public boolean delayedUpdateChecksum = false;
    public long hashLookupPos = -1L;
    protected SearchState searchState = null;
    private EntryPresence entryPresence = null;

    public boolean readZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.readZero();
    }

    public boolean reallocGuarded(long fromPos, int oldChunks, int newChunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.realloc(fromPos, oldChunks, newChunks);
    }

    public boolean updateZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementWrite();
    }

    public RuntimeException debugContextsAndLocksGuarded(InterProcessDeadLockException e) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.debugContextsAndLocks(e);
    }

    public long allocReturnCodeGuarded(int chunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.allocReturnCode(chunks);
    }

    public Bytes segmentBytesForReadGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForRead();
    }

    public Bytes segmentBytesForWriteGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForWrite();
    }

    @Override
    public void close() {
        this.entryKey.doCloseCachedEntryKey();
        this.entryValue.doCloseCachedEntryValue();
        this.doClosePresenceOfEntry();
        this.doCloseKeySearch();
        this.doCloseHashLookupPos();
        this.doCloseDelayedUpdateChecksum();
        this.doCloseLocks();
        this.doCloseUsed();
        this.usingReturnValue.doCloseReturnedValue();
        this.usingReturnValue.doCloseUsingReturnValue();
        this.doCloseEntrySizeInChunks();
        this.doCloseEntryOffset();
        this.doCloseValueSize();
        this.doCloseSegment();
        this.doCloseSegmentTier();
        this.doCloseSegmentHeader();
        this.doCloseSegmentIndex();
        this.doCloseSearchKey();
        this.wrappedValueInstanceDataHolder.doCloseWrappedData();
        this.wrappedValueInstanceDataHolder.doCloseValue();
        this.doCloseMap();
        this.defaultReturnValue.doCloseDefaultReturnedValue();
        this.doCloseAllocatedChunks();
        this.doCloseValueSizeOffset();
        this.doCloseKeyOffset();
        this.doClosePos();
        this.wrappedValueBytesData.doCloseCachedWrappedValue();
        this.wrappedValueBytesData.doCloseWrappedValueBytes();
        this.wrappedValueBytesData.doCloseWrappedValueBytesStore();
        this.wrappedValueBytesData.doCloseNext();
        this.wrappedValueInstanceDataHolder.doCloseNext();
        this.doCloseKeyHash();
        this.doCloseInputKey();
        this.inputKeyBytesData.doCloseCachedInputKey();
        this.inputKeyBytesData.doCloseInputKeyBytes();
        this.inputKeyBytesData.doCloseInputKeyBytesStore();
        this.doCloseInputValueDataAccess();
        this.doCloseKeySize();
        this.doCloseInputKeyDataAccess();
    }

    public void doCloseAllocatedChunks() {
        this.allocatedChunks = 0;
    }

    public void doCloseDelayedUpdateChecksum() {
        if (!this.delayedUpdateChecksumInit()) {
            return;
        }
        if (this.h().checksumEntries) {
            this.hashEntryChecksumStrategy.computeAndStoreChecksum();
        }
        this.delayedUpdateChecksum = false;
    }

    public void doCloseEntryOffset() {
        this.keySizeOffset = -1L;
    }

    public void doCloseEntrySizeInChunks() {
        this.entrySizeInChunks = 0;
    }

    public void doCloseHashLookupPos() {
        this.hashLookupPos = -1L;
    }

    public void doCloseInputKey() {
        this.inputKey = null;
    }

    public void doCloseInputKeyDataAccess() {
        if (!this.inputKeyDataAccessInit()) {
            return;
        }
        this.innerInputKeyDataAccess.uninit();
        this.inputKeyDataAccessInitialized = false;
    }

    public void doCloseInputValueDataAccess() {
        if (!this.inputValueDataAccessInit()) {
            return;
        }
        this.innerInputValueDataAccess.uninit();
        this.inputValueDataAccessInitialized = false;
    }

    public void doCloseKeyHash() {
        this.keyHash = 0L;
    }

    public void doCloseKeyOffset() {
        this.keyOffset = -1L;
    }

    public void doCloseKeySearch() {
        this.searchState = null;
    }

    public void doCloseKeySize() {
        this.keySize = -1L;
    }

    public void doCloseLocks() {
        if (!this.locksInit()) {
            return;
        }
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    public void doCloseMap() {
        this.m = null;
    }

    public void doClosePos() {
        this.pos = -1L;
    }

    public void doClosePresenceOfEntry() {
        this.entryPresence = null;
    }

    public void doCloseSearchKey() {
        this.searchKey = 0L;
    }

    public void doCloseSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.entrySpaceOffset = 0L;
    }

    public void doCloseSegmentHeader() {
        this.segmentHeader = null;
    }

    public void doCloseSegmentIndex() {
        this.segmentIndex = -1;
    }

    public void doCloseSegmentTier() {
        this.tier = -1;
    }

    public void doCloseUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
        if (this.firstContextLockedInThisThread) {
            this.rootContextInThisThread.unlockContextLocally();
        }
    }

    public void doCloseValueSize() {
        this.valueSize = -1L;
    }

    public void doCloseValueSizeOffset() {
        this.valueSizeOffset = -1L;
    }

    public void freeExtraGuarded(long pos, int oldChunks, int newChunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        this.freeExtra(pos, oldChunks, newChunks);
    }

    public void freeGuarded(long fromPos, int chunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        this.free(fromPos, chunks);
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    public void setSearchStateGuarded(SearchState newSearchState) {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        this.setSearchState(newSearchState);
    }

    public CompiledMapQueryContext(ChainingInterface rootContextInThisThread, VanillaChronicleMap map) {
        this.contextChain = rootContextInThisThread.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.rootContextInThisThread = rootContextInThisThread;
        this.initMap(map);
        this.inputKeyBytesData = new InputKeyBytesData();
        this.innerInputValueDataAccess = (DataAccess)this.m().valueDataAccess.copy();
        this.defaultReturnValue = new DefaultReturnValue();
        this.owner = Thread.currentThread();
        this.zeroValueData = new DummyValueZeroData();
        this.entryKey = new EntryKeyBytesData();
        this.usingReturnValue = new UsingReturnValue();
        this.valueReader = StatefulCopyable.copyIfNeeded(this.m().valueReader);
        this.acquireHandle = new AcquireHandle();
        this.entryValue = new EntryValueBytesData();
        this.wrappedValueInstanceDataHolder = new WrappedValueInstanceDataHolder();
        this.innerReadLock = new ReadLock();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.innerInputKeyDataAccess = (DataAccess)this.h().keyDataAccess.copy();
        this.innerWriteLock = new WriteLock();
        this.wrappedValueBytesData = new WrappedValueBytesData();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes(this.segmentBS);
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerUpdateLock = new UpdateLock();
        this.freeList = new ReusableBitSet(new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
    }

    public CompiledMapQueryContext(VanillaChronicleMap map) {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.rootContextInThisThread = this;
        this.initMap(map);
        this.inputKeyBytesData = new InputKeyBytesData();
        this.innerInputValueDataAccess = (DataAccess)this.m().valueDataAccess.copy();
        this.defaultReturnValue = new DefaultReturnValue();
        this.owner = Thread.currentThread();
        this.zeroValueData = new DummyValueZeroData();
        this.entryKey = new EntryKeyBytesData();
        this.usingReturnValue = new UsingReturnValue();
        this.valueReader = StatefulCopyable.copyIfNeeded(this.m().valueReader);
        this.acquireHandle = new AcquireHandle();
        this.entryValue = new EntryValueBytesData();
        this.wrappedValueInstanceDataHolder = new WrappedValueInstanceDataHolder();
        this.innerReadLock = new ReadLock();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.innerInputKeyDataAccess = (DataAccess)this.h().keyDataAccess.copy();
        this.innerWriteLock = new WriteLock();
        this.wrappedValueBytesData = new WrappedValueBytesData();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes(this.segmentBS);
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerUpdateLock = new UpdateLock();
        this.freeList = new ReusableBitSet(new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.locksInit()) {
            LocksInterface root;
            this.rootContextLockedOnThisSegment = root = c.rootContextLockedOnThisSegment();
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        assert (this.totalReadLockCount + change >= 0) : "read underflow";
        return this.totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        assert (this.totalUpdateLockCount + change >= 0) : "update underflow";
        return this.totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        assert (this.totalWriteLockCount + change >= 0) : "write underflow";
        return this.totalWriteLockCount += change;
    }

    public int decrementRead() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash<K, ?, ?, ?> h2 = this.h();
        if (chunks > h2.maxChunksPerEntry) {
            throw new IllegalArgumentException(this.h().toIdentityString() + ": Entry is too large: requires " + chunks + " chunks, " + h2.maxChunksPerEntry + " is maximum.");
        }
        long lowestPossiblyFreeChunk = this.lowestPossiblyFreeChunk();
        if (lowestPossiblyFreeChunk + (long)chunks > h2.actualChunksPerSegmentTier) {
            return -1L;
        }
        if (this.tierEntries() >= h2.maxEntriesPerHashLookup) {
            return -1L;
        }
        assert (lowestPossiblyFreeChunk < h2.actualChunksPerSegmentTier);
        long ret = this.freeList.setNextNContinuousClearBits(lowestPossiblyFreeChunk, chunks);
        if (ret == -1L || ret + (long)chunks > h2.actualChunksPerSegmentTier) {
            if (ret + (long)chunks > h2.actualChunksPerSegmentTier) {
                assert (ret != -1L);
                this.freeList.clearRange(ret, ret + (long)chunks);
            }
            return -1L;
        }
        this.tierEntries(this.tierEntries() + 1L);
        if (chunks == 1 || this.freeList.isSet(lowestPossiblyFreeChunk)) {
            this.lowestPossiblyFreeChunk(ret + (long)chunks);
        }
        return ret;
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkOnEachLockOperation();
    }

    public void free(long fromPos, int chunks) {
        this.tierEntries(this.tierEntries() - 1L);
        this.freeList.clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(fromPos);
        }
    }

    public void freeExtra(long pos, int oldChunks, int newChunks) {
        long from = pos + (long)newChunks;
        this.freeList.clearRange(from, pos + (long)oldChunks);
        if (from < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(from);
        }
    }

    public void incrementModCount() {
        this.contextModCount = this.rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                if (this.decrementRead() == 0 && this.updateZero() && this.writeZero()) {
                    this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                }
                return;
            }
            case UPDATE_LOCKED: {
                if (this.decrementUpdate() == 0 && this.writeZero()) {
                    if (this.readZero()) {
                        this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                    } else {
                        this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                    }
                }
                return;
            }
            case WRITE_LOCKED: {
                if (this.decrementWrite() != 0) break;
                if (!this.updateZero()) {
                    this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                    break;
                }
                if (!this.readZero()) {
                    this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                    break;
                }
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        boolean goingToLock;
        boolean isLocked = this.localLockState != LocalLockState.UNLOCKED && this.localLockState != null;
        boolean bl = goingToLock = newState != LocalLockState.UNLOCKED && newState != null;
        if (isLocked) {
            if (!goingToLock) {
                this.deregisterIterationContextLockedInThisThread();
            }
        } else if (goingToLock) {
            this.registerIterationContextLockedInThisThread();
        }
        this.localLockState = newState;
    }

    @Override
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    @Override
    public Thread owner() {
        return this.owner;
    }

    public Bytes segmentBytesForRead() {
        this.segmentBytes.readLimit(this.segmentBytes.capacity());
        return this.segmentBytes;
    }

    public Bytes segmentBytesForWrite() {
        this.segmentBytes.readPosition(0L);
        return this.segmentBytes;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextLockedOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface nextNode;
        LocksInterface prevContext = this.rootContextLockedOnThisSegment;
        while ((nextNode = prevContext.nextNode()) != this && nextNode != null) {
            prevContext = nextNode;
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Attempt to close contexts not structurally");
        }
    }

    public boolean readZero() {
        return this.rootContextLockedOnThisSegment.totalReadLockCount() == 0;
    }

    public boolean realloc(long fromPos, int oldChunks, int newChunks) {
        if (fromPos + (long)newChunks < this.h().actualChunksPerSegmentTier && this.freeList.isRangeClear(fromPos + (long)oldChunks, fromPos + (long)newChunks)) {
            this.freeList.setRange(fromPos + (long)oldChunks, fromPos + (long)newChunks);
            return true;
        }
        return false;
    }

    public boolean updateZero() {
        return this.rootContextLockedOnThisSegment.totalUpdateLockCount() == 0;
    }

    public boolean writeZero() {
        return this.rootContextLockedOnThisSegment.totalWriteLockCount() == 0;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public DataAccess<K> innerInputKeyDataAccess() {
        return this.innerInputKeyDataAccess;
    }

    public DataAccess<V> innerInputValueDataAccess() {
        return this.innerInputValueDataAccess;
    }

    public InputKeyBytesData inputKeyBytesData() {
        return this.inputKeyBytesData;
    }

    public DummyValueZeroData zeroValueData() {
        return this.zeroValueData;
    }

    public RuntimeException debugContextsAndLocks(InterProcessDeadLockException e) {
        String message = this.h().toIdentityString() + ":\n";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextLockedOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        throw new InterProcessDeadLockException(message, e);
    }

    public WrappedValueBytesData wrappedValueBytesData() {
        return this.wrappedValueBytesData;
    }

    public HashEntryChecksumStrategy hashEntryChecksumStrategy() {
        return this.hashEntryChecksumStrategy;
    }

    public UsingReturnValue usingReturnValue() {
        return this.usingReturnValue;
    }

    @Override
    public AcquireHandle acquireHandle() {
        return this.acquireHandle;
    }

    public Logger LOG() {
        return LOG;
    }

    public SizedReader<V> valueReader() {
        return this.valueReader;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ReusableBitSet freeList() {
        return this.freeList;
    }

    public SizedReader<K> keyReader() {
        return this.keyReader;
    }

    public DefaultReturnValue defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public ChainingInterface rootContextInThisThread() {
        return this.rootContextInThisThread;
    }

    public WrappedValueInstanceDataHolder wrappedValueInstanceDataHolder() {
        return this.wrappedValueInstanceDataHolder;
    }

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    private static <T extends ChainingInterface> T initUsedAndReturn(VanillaChronicleMap map, ChainingInterface context) {
        try {
            context.initUsed(true, map);
            return (T)context;
        }
        catch (Throwable throwable) {
            try {
                ((AutoCloseable)((Object)context)).close();
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw throwable;
        }
    }

    public Bytes segmentBytes() {
        return this.segmentBytes;
    }

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, BiFunction<ChainingInterface, VanillaChronicleMap, T> createChaining, VanillaChronicleMap map) {
        ChainingInterface context2;
        for (ChainingInterface context2 : this.contextChain) {
            if (context2.getClass() != contextClass || context2.usedInit()) continue;
            return CompiledMapQueryContext.initUsedAndReturn(map, context2);
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException(map.toIdentityString() + ": More than " + maxNestedContexts + " nested ChronicleHash contexts\n" + "are not supported. Very probable that you simply forgot to close context\n" + "somewhere (recommended to use try-with-resources statement).\n" + "Otherwise this is a bug, please report with this\n" + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = (ChainingInterface)createChaining.apply(this, map);
        return CompiledMapQueryContext.initUsedAndReturn(map, context2);
    }

    @Override
    public DataAccess<K> inputKeyDataAccess() {
        this.initInputKeyDataAccess();
        return this.innerInputKeyDataAccess;
    }

    public boolean entryDeleted() {
        return false;
    }

    public void closeEntry() {
        this.closePos();
        this.closeEntryOffset();
        this.closeKeySize();
        this.closeKeyOffset();
    }

    @Override
    public DataAccess<V> inputValueDataAccess() {
        this.initInputValueDataAccess();
        return this.innerInputValueDataAccess;
    }

    public long newEntrySize(Data<V> newValue, long entryStartOffset, long newValueOffset) {
        return this.checksumStrategy.extraEntryBytes() + newValueOffset + newValue.size() - entryStartOffset;
    }

    private void registerIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = true;
        }
    }

    public void closeQuerySegmentStagesRegisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    @Override
    public Data<K> getInputKeyBytesAsData(BytesStore bytesStore, long offset, long size) {
        this.inputKeyBytesData.initInputKeyBytesStore(bytesStore, offset, size);
        return this.inputKeyBytesData;
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    private void deregisterIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = false;
        }
    }

    public void closeQuerySegmentStagesDeregisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public void readFoundEntry(long pos, long keySizeOffset, long keySize, long keyOffset) {
        this.initPos(pos);
        this.initEntryOffset(keySizeOffset);
        this.initKeySize(keySize);
        this.initKeyOffset(keyOffset);
    }

    public void closeMapEntryStagesReadFoundEntryDependants() {
        this.closeKeySearch();
    }

    public boolean inputKeyDataAccessInit() {
        return this.inputKeyDataAccessInitialized;
    }

    void initInputKeyDataAccess() {
        this.inputKeyDataAccessInitialized = true;
    }

    void closeInputKeyDataAccess() {
        if (!this.inputKeyDataAccessInit()) {
            return;
        }
        this.innerInputKeyDataAccess.uninit();
        this.inputKeyDataAccessInitialized = false;
    }

    public boolean keySizeInit() {
        return this.keySize != -1L;
    }

    public void initKeySize(long keySize) {
        boolean wasKeySizeInit = this.keySizeInit();
        this.keySize = keySize;
        if (wasKeySizeInit) {
            this.closeKeySizeDependants();
        }
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    public boolean inputValueDataAccessInit() {
        return this.inputValueDataAccessInitialized;
    }

    void initInputValueDataAccess() {
        this.inputValueDataAccessInitialized = true;
    }

    void closeInputValueDataAccess() {
        if (!this.inputValueDataAccessInit()) {
            return;
        }
        this.innerInputValueDataAccess.uninit();
        this.inputValueDataAccessInitialized = false;
    }

    public boolean inputKeyInit() {
        return this.inputKey != null;
    }

    @Override
    public void initInputKey(Data<K> inputKey) {
        boolean wasInputKeyInit = this.inputKeyInit();
        this.inputKey = inputKey;
        if (wasInputKeyInit) {
            this.closeInputKeyDependants();
        }
    }

    public Data<K> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeyHash();
        this.closeKeySearchKeyEqualsDependants();
    }

    public boolean keyHashInit() {
        return this.keyHash != 0L;
    }

    void initKeyHash() {
        boolean wasKeyHashInit = this.keyHashInit();
        this.keyHash = this.inputKey().hash(LongHashFunction.xx_r39());
        if (wasKeyHashInit) {
            this.closeKeyHashDependants();
        }
    }

    public long keyHash() {
        if (!this.keyHashInit()) {
            this.initKeyHash();
        }
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!this.keyHashInit()) {
            return;
        }
        this.closeKeyHashDependants();
        this.keyHash = 0L;
    }

    public void closeKeyHashDependants() {
        this.closeInputKeyHashCodeKeyHashCodeDependants();
    }

    @Override
    public long keyHashCode() {
        return this.keyHash();
    }

    public void closeInputKeyHashCodeKeyHashCodeDependants() {
        this.closeSegmentIndex();
        this.closeSearchKey();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    public boolean posInit() {
        return this.pos != -1L;
    }

    public void initPos(long pos) {
        boolean wasPosInit = this.posInit();
        this.pos = pos;
        if (wasPosInit) {
            this.closePosDependants();
        }
    }

    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public boolean keyOffsetInit() {
        return this.keyOffset != -1L;
    }

    public void initKeyOffset(long keyOffset) {
        boolean wasKeyOffsetInit = this.keyOffsetInit();
        this.keyOffset = keyOffset;
        if (wasKeyOffsetInit) {
            this.closeKeyOffsetDependants();
        }
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeMapEntryStagesKeyEndDependants() {
        this.closeMapEntryStagesCountValueSizeOffsetDependants();
        this.closeMapEntryStagesEntryEndDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    public void closeMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset != -1L;
    }

    void initValueSizeOffset() {
        boolean wasValueSizeOffsetInit = this.valueSizeOffsetInit();
        this.valueSizeOffset = this.countValueSizeOffset();
        if (wasValueSizeOffsetInit) {
            this.closeValueSizeOffsetDependants();
        }
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        this.allocatedChunks = 0;
    }

    public boolean mapInit() {
        return this.m != null;
    }

    public void initMap(VanillaChronicleMap map) {
        boolean wasMapInit = this.mapInit();
        this.m = map;
        if (wasMapInit) {
            this.closeMapDependants();
        }
    }

    @Override
    public VanillaChronicleMap<K, V, R> m() {
        assert (this.mapInit()) : "Map should be init";
        return this.m;
    }

    public void closeMap() {
        if (!this.mapInit()) {
            return;
        }
        this.closeMapDependants();
        this.m = null;
    }

    public void closeMapDependants() {
        this.closeVanillaChronicleMapHolderImplMDependants();
        this.closeVanillaChronicleMapHolderImplHDependants();
    }

    public void closeVanillaChronicleMapHolderImplMDependants() {
        this.closeValueSize();
        this.wrappedValueInstanceDataHolder.closeValue();
        this.closeKeySearch();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)this.m().keySizeMarshaller.storingLength(keySize) + keySize + (long)this.m().valueSizeMarshaller.storingLength(valueSize);
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        long sizeWithoutChecksum = this.m().constantlySizedEntry ? VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue + valueSize, this.m().alignment) : (this.m().couldNotDetermineAlignmentBeforeAllocation ? sizeOfEverythingBeforeValue + (long)this.m().worstAlignment + valueSize : VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue, this.m().alignment) + valueSize);
        return sizeWithoutChecksum + this.checksumStrategy.extraEntryBytes();
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    @Override
    public ChronicleSet<K> set() {
        return this.m().chronicleSet;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    @Override
    public ChronicleHash<K, ?, ?, ?> hash() {
        return this.set() != null ? this.set() : this.map();
    }

    @Override
    public VanillaChronicleHash<K, ?, ?, ?> h() {
        return this.m();
    }

    public void closeVanillaChronicleMapHolderImplHDependants() {
        this.closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeQueryHashLookupSearchHlDependants();
        this.closeSearchKey();
        this.closeSegmentIndex();
        this.closeSegmentHeader();
        this.closeLocks();
        this.closeSegmentTier();
        this.closeQuerySegmentStagesTierCountersAreaAddrDependants();
        this.closeQuerySegmentStagesNextTierDependants();
        this.closeSegment();
        this.closeEntryOffset();
        this.closeEntrySizeInChunks();
        this.closeDelayedUpdateChecksum();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeKeySearch();
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data<K> key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && java.util.Objects.equals(key = ((CompiledMapQueryContext)innermostContextOnThisSegment).inputKey(), this.inputKey())) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Nested same-thread contexts cannot access the same key " + key);
        }
    }

    public void closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeQueryHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    void initSearchKey() {
        boolean wasSearchKeyInit = this.searchKeyInit();
        this.initSearchKey(this.hl().maskUnsetKey(this.h().hashSplitting.segmentHash(this.keyHashCode())));
        if (wasSearchKeyInit) {
            this.closeSearchKeyDependants();
        }
    }

    public void initSearchKey(long searchKey) {
        boolean wasSearchKeyInit = this.searchKeyInit();
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
        if (wasSearchKeyInit) {
            this.closeSearchKeyDependants();
        }
    }

    public long searchKey() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchKey;
    }

    public long searchStartPos() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    @Override
    public boolean segmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    void initSegmentIndex() {
        boolean wasSegmentIndexInit = this.segmentIndexInit();
        this.segmentIndex = this.h().hashSplitting.segmentIndex(this.keyHashCode());
        if (wasSegmentIndexInit) {
            this.closeSegmentIndexDependants();
        }
    }

    @Override
    public void initSegmentIndex(int segmentIndex) {
        boolean wasSegmentIndexInit = this.segmentIndexInit();
        this.segmentIndex = segmentIndex;
        if (wasSegmentIndexInit) {
            this.closeSegmentIndexDependants();
        }
    }

    @Override
    public int segmentIndex() {
        if (!this.segmentIndexInit()) {
            this.initSegmentIndex();
        }
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!this.segmentIndexInit()) {
            return;
        }
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentHeader();
        this.closeSegmentTier();
        this.closeQuerySegmentStagesNextTierDependants();
    }

    @Override
    public boolean segmentHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegmentHeader() {
        boolean wasSegmentHeaderInit = this.segmentHeaderInit();
        this.segmentHeaderAddress = this.h().segmentHeaderAddress(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        if (wasSegmentHeaderInit) {
            this.closeSegmentHeaderDependants();
        }
    }

    @Override
    public long segmentHeaderAddress() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!this.segmentHeaderInit()) {
            return;
        }
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeQuerySegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeQuerySegmentStagesTierEntriesDependants();
        this.closeQuerySegmentStagesTierEntriesDependants();
    }

    public boolean segmentTierInit() {
        return this.tier >= 0;
    }

    public void initSegmentTier() {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tierIndex = this.segmentIndex() + 1;
        this.tierBaseAddr = this.h().segmentBaseAddr(this.segmentIndex());
        this.tier = 0;
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public void initSegmentTier(int tier, long tierIndex) {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.tierBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public int tier() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tier;
    }

    public long tierBaseAddr() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierBaseAddr;
    }

    public long tierIndex() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!this.segmentTierInit()) {
            return;
        }
        this.closeSegmentTierDependants();
        this.tier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeQueryHashLookupSearchAddrDependants();
        this.closeQuerySegmentStagesTierCountersAreaAddrDependants();
        this.closeHashLookupPos();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierDependants();
        this.closeQuerySegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeQuerySegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeQuerySegmentStagesTierEntriesDependants();
        this.closeQuerySegmentStagesTierEntriesDependants();
        this.closeSegment();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.closeMapQueryTieredEntryPresentDependants();
    }

    private long addr() {
        return this.tierBaseAddr();
    }

    public void closeQueryHashLookupSearchAddrDependants() {
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public long tierCountersAreaAddr() {
        return this.tierBaseAddr() + this.h().tierHashLookupOuterSize;
    }

    public void closeQuerySegmentStagesTierCountersAreaAddrDependants() {
        this.closeQuerySegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeQuerySegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeQuerySegmentStagesPrevTierIndexDependants();
        this.closeQuerySegmentStagesTierEntriesDependants();
        this.closeQuerySegmentStagesTierEntriesDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public void closeQuerySegmentStagesPrevTierIndexDependants() {
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void tierDeleted(long tierDeleted) {
        if (this.tier() == 0) {
            this.segmentHeader().deleted(this.segmentHeaderAddress(), tierDeleted);
        } else {
            TierCountersArea.deleted(this.tierCountersAreaAddr(), tierDeleted);
        }
    }

    public long tierDeleted() {
        if (this.tier() == 0) {
            return this.segmentHeader().deleted(this.segmentHeaderAddress());
        }
        return TierCountersArea.deleted(this.tierCountersAreaAddr());
    }

    public void nextTierIndex(long nextTierIndex) {
        if (this.tier() == 0) {
            this.segmentHeader().nextTierIndex(this.segmentHeaderAddress(), nextTierIndex);
        } else {
            TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
        }
    }

    public void closeQuerySegmentStagesNextTierIndexDependants() {
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public long nextTierIndex() {
        if (this.tier() == 0) {
            return this.segmentHeader().nextTierIndex(this.segmentHeaderAddress());
        }
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void closeQuerySegmentStagesHasNextTierDependants() {
        this.closeMapQueryTieredEntryPresentDependants();
    }

    public void nextTier() {
        VanillaChronicleHash<K, ?, ?, ?> h2 = this.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            LOG.debug("Allocate tier for segment # {}, tier {}", (Object)this.segmentIndex(), (Object)(this.tier() + 1));
            nextTierIndex = h2.allocateTier();
            this.nextTierIndex(nextTierIndex);
            long prevTierIndex = this.tierIndex();
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
            TierCountersArea.segmentIndex(this.tierCountersAreaAddr(), this.segmentIndex());
            TierCountersArea.tier(this.tierCountersAreaAddr(), this.tier());
            this.nextTierIndex(0L);
            this.prevTierIndex(prevTierIndex);
        } else {
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
        }
    }

    public void closeQuerySegmentStagesNextTierDependants() {
        this.closeMapQueryTieredEntryPresentDependants();
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    public void lowestPossiblyFreeChunk(long lowestPossiblyFreeChunk) {
        if (this.tier() == 0) {
            this.segmentHeader().lowestPossiblyFreeChunk(this.segmentHeaderAddress(), lowestPossiblyFreeChunk);
        } else {
            TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr(), lowestPossiblyFreeChunk);
        }
    }

    public long lowestPossiblyFreeChunk() {
        if (this.tier() == 0) {
            return this.segmentHeader().lowestPossiblyFreeChunk(this.segmentHeaderAddress());
        }
        return TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr());
    }

    public void closeQuerySegmentStagesLowestPossiblyFreeChunkDependants() {
        this.closeSegment();
    }

    public void tierEntries(long tierEntries) {
        if (this.tier() == 0) {
            this.segmentHeader().entries(this.segmentHeaderAddress(), tierEntries);
        } else {
            TierCountersArea.entries(this.tierCountersAreaAddr(), tierEntries);
        }
    }

    public long tierEntries() {
        if (this.tier() == 0) {
            return this.segmentHeader().entries(this.segmentHeaderAddress());
        }
        return TierCountersArea.entries(this.tierCountersAreaAddr());
    }

    public void closeQuerySegmentStagesTierEntriesDependants() {
        this.closeSegment();
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        boolean wasSegmentInit = this.segmentInit();
        VanillaChronicleHash<K, ?, ?, ?> h2 = this.h();
        long segmentBaseAddr = this.tierBaseAddr();
        this.segmentBS.set(segmentBaseAddr, h2.tierSize);
        this.segmentBytes.clear();
        long freeListOffset = h2.tierHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h2.tierFreeListOuterSize + (long)h2.tierEntrySpaceInnerOffset;
        if (wasSegmentInit) {
            this.closeSegmentDependants();
        }
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public PointerBytesStore segmentBS() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBS;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeySearch();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.closeEntryOffset();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public boolean valueSizeInit() {
        return this.valueSize != -1L;
    }

    void initValueSize() {
        boolean wasValueSizeInit = this.valueSizeInit();
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize(segmentBytes);
        this.valueOffset = segmentBytes.readPosition();
        if (wasValueSizeInit) {
            this.closeValueSizeDependants();
        }
    }

    void initValueSize(long valueSize) {
        boolean wasValueSizeInit = this.valueSizeInit();
        this.valueSize = valueSize;
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.valueSizeOffset());
        this.m().valueSizeMarshaller.writeSize(segmentBytes, valueSize);
        long currentPosition = segmentBytes.writePosition();
        long currentAddr = segmentBytes.addressForRead(currentPosition);
        long skip = VanillaChronicleMap.alignAddr(currentAddr, this.m().alignment) - currentAddr;
        if (skip > 0L) {
            segmentBytes.writeSkip(skip);
        }
        this.valueOffset = segmentBytes.writePosition();
        if (wasValueSizeInit) {
            this.closeValueSizeDependants();
        }
    }

    public long valueOffset() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!this.valueSizeInit()) {
            return;
        }
        this.closeValueSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValueSizeDependants() {
        this.closeMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    public long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeMapEntryStagesEntryEndDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
    }

    public void writeValue(Data<?> value) {
        this.initDelayedUpdateChecksum(true);
        value.writeTo(this.segmentBS(), this.valueOffset());
    }

    public void initValue(Data<?> value) {
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    boolean keyEquals(long keySize, long keyOffset) {
        return this.inputKey().size() == keySize && this.inputKey().equivalent(this.segmentBS(), keyOffset);
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset != -1L;
    }

    public void initEntryOffset() {
        boolean wasEntryOffsetInit = this.entryOffsetInit();
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        if (wasEntryOffsetInit) {
            this.closeEntryOffsetDependants();
        }
    }

    public void initEntryOffset(long keySizeOffset) {
        boolean wasEntryOffsetInit = this.entryOffsetInit();
        this.keySizeOffset = keySizeOffset;
        if (wasEntryOffsetInit) {
            this.closeEntryOffsetDependants();
        }
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
        this.closeDelayedUpdateChecksum();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize(segmentBytes, this.keySize());
        this.initKeyOffset(segmentBytes.writePosition());
        key.writeTo(this.segmentBS(), this.keyOffset());
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset();
    }

    public void closeMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public boolean entrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            this.initEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        this.entrySizeInChunks = 0;
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.freeExtraGuarded(this.pos(), this.allocatedChunks(), this.entrySizeInChunks());
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)this.m().valueSizeMarshaller.storingLength(newValue.size()) - this.keySizeOffset();
    }

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize(segmentBytes));
        this.initKeyOffset(segmentBytes.readPosition());
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyAddr - oldKeySizeAddr));
        Access.copy(Access.nativeAccess(), null, oldKeySizeAddr, Access.checkedBytesStoreAccess(), this.segmentBS(), this.keySizeOffset(), bytesToCopy);
    }

    public void prevTier() {
        if (this.tier() == 0) {
            throw new IllegalStateException(this.h().toIdentityString() + ": first tier doesn't have previous");
        }
        this.initSegmentTier(this.tier() - 1, this.prevTierIndex());
    }

    public void goToFirstTier() {
        while (this.tier() != 0) {
            this.prevTier();
        }
    }

    public long size() {
        this.goToFirstTier();
        long size = this.tierEntries() - this.tierDeleted();
        while (this.hasNextTier()) {
            this.nextTier();
            size += this.tierEntries() - this.tierDeleted();
        }
        return size;
    }

    @Override
    public long alloc(int chunks, long prevPos, int prevChunks) {
        long ret = this.allocReturnCodeGuarded(chunks);
        if (prevPos >= 0L) {
            this.freeGuarded(prevPos, prevChunks);
        }
        if (ret >= 0L) {
            return ret;
        }
        int alreadyAttemptedTier = this.tier();
        this.goToFirstTier();
        while (this.tier() == alreadyAttemptedTier || (ret = this.allocReturnCodeGuarded(chunks)) < 0L) {
            this.nextTier();
        }
        return ret;
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy, long prevPos, int prevChunks) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        long oldSegmentTierBaseAddr = this.tierBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + this.keySizeOffset();
        long oldKeyAddr = oldSegmentTierBaseAddr + this.keyOffset();
        int tierBeforeAllocation = this.tier();
        long pos = this.alloc(this.allocatedChunks(), prevPos, prevChunks);
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return this.tier() != tierBeforeAllocation;
    }

    public boolean initEntryAndKey(long entrySize) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        int tierBeforeAllocation = this.tier();
        long pos = this.alloc(this.allocatedChunks(), -1L, 0);
        this.writeNewEntry(pos, this.inputKey());
        return this.tier() != tierBeforeAllocation;
    }

    public void verifyTierCountersAreaData() {
        block2: {
            long currentTierIndex;
            this.goToFirstTier();
            do {
                int tierSegmentIndex;
                if ((tierSegmentIndex = TierCountersArea.segmentIndex(this.tierCountersAreaAddr())) != this.segmentIndex()) {
                    throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex() + ", tier: " + this.tier() + ", tierIndex: " + this.tierIndex() + ", tierBaseAddr: " + this.tierBaseAddr() + " reports it belongs to segmentIndex " + tierSegmentIndex));
                }
                if (!this.hasNextTier()) break block2;
                currentTierIndex = this.tierIndex();
                this.nextTier();
            } while (this.prevTierIndex() == currentTierIndex);
            throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex() + ", tier: " + this.tier() + ", tierIndex: " + this.tierIndex() + ", tierBaseAddr: " + this.tierBaseAddr() + " reports the previous tierIndex is " + this.prevTierIndex() + " while actually it is " + currentTierIndex));
        }
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Update or Write " + "locking is forbidden in the context of locked iteration context");
        }
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException(this.h().toIdentityString() + ": Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachLockOperationDependants();
    }

    public void checkOnEachLockOperation() {
        this.checkAccessingFromOwnerThread();
    }

    public void closeQueryCheckOnEachPublicOperationCheckOnEachLockOperationDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used, VanillaChronicleMap map) {
        boolean wasUsedInit = this.usedInit();
        assert (used);
        this.firstContextLockedInThisThread = this.rootContextInThisThread.lockContextLocally(map);
        this.initMap(map);
        this.used = true;
        if (wasUsedInit) {
            this.closeUsedDependants();
        }
    }

    public boolean used() {
        assert (this.usedInit()) : "Used should be init";
        return this.used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.closeUsedDependants();
        this.used = false;
        if (this.firstContextLockedInThisThread) {
            this.rootContextInThisThread.unlockContextLocally();
        }
    }

    public void closeUsedDependants() {
        this.closeLocks();
    }

    @Override
    public boolean locksInit() {
        return this.rootContextLockedOnThisSegment != null;
    }

    void initLocks() {
        int i;
        boolean wasLocksInit = this.locksInit();
        assert (this.used());
        if (this.segmentHeader() == null) {
            throw new AssertionError();
        }
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextLockedOnThisSegment = this;
        this.nestedContextsLockedOnSameSegment = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        if (wasLocksInit) {
            this.closeLocksDependants();
        }
    }

    public boolean nestedContextsLockedOnSameSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nestedContextsLockedOnSameSegment;
    }

    public int contextModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.contextModCount;
    }

    @Override
    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    @Override
    public int totalReadLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalReadLockCount;
    }

    @Override
    public int totalUpdateLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalUpdateLockCount;
    }

    @Override
    public int totalWriteLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    @Override
    public LocksInterface nextNode() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nextNode;
    }

    @Override
    public LocksInterface rootContextLockedOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextLockedOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.closeDelayedUpdateChecksum();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    boolean delayedUpdateChecksumInit() {
        return this.delayedUpdateChecksum;
    }

    public void initDelayedUpdateChecksum(boolean delayedUpdateChecksum) {
        assert (this.entryOffsetInit() && this.keySizeOffset() >= 0L);
        assert (this.locksInit() && this.localLockState() != LocalLockState.UNLOCKED);
        assert (delayedUpdateChecksum);
        this.delayedUpdateChecksum = true;
    }

    public void closeDelayedUpdateChecksum() {
        if (!this.delayedUpdateChecksumInit()) {
            return;
        }
        if (this.h().checksumEntries) {
            this.hashEntryChecksumStrategy.computeAndStoreChecksum();
        }
        this.delayedUpdateChecksum = false;
    }

    @Override
    public String debugLocksState() {
        String s2 = this + ": ";
        if (!this.usedInit()) {
            s2 = s2 + "unused";
            return s2;
        }
        s2 = s2 + "used, ";
        if (!this.segmentIndexInit()) {
            s2 = s2 + "segment uninitialized";
            return s2;
        }
        s2 = s2 + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s2 = s2 + "locks uninitialized";
            return s2;
        }
        s2 = s2 + "local state: " + (Object)((Object)this.localLockState()) + ", ";
        s2 = s2 + "read lock count: " + this.rootContextLockedOnThisSegment().totalReadLockCount() + ", ";
        s2 = s2 + "update lock count: " + this.rootContextLockedOnThisSegment().totalUpdateLockCount() + ", ";
        s2 = s2 + "write lock count: " + this.rootContextLockedOnThisSegment().totalWriteLockCount();
        return s2;
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos != -1L;
    }

    public void initHashLookupPos() {
        boolean wasHashLookupPosInit = this.hashLookupPosInit();
        if (this.tier() < 0) {
            throw new AssertionError();
        }
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        if (wasHashLookupPosInit) {
            this.closeHashLookupPosDependants();
        }
    }

    public void initHashLookupPos(long hashLookupPos) {
        boolean wasHashLookupPosInit = this.hashLookupPosInit();
        this.hashLookupPos = hashLookupPos;
        if (wasHashLookupPosInit) {
            this.closeHashLookupPosDependants();
        }
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public void found() {
        this.setHashLookupPosGuarded(this.hl().stepBack(this.hashLookupPos()));
    }

    public void closeQueryHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            CompactOffHeapLinearHashTable hl = this.hl();
            do {
                if (hl.empty(entry = hl.readEntryVolatile(this.addr(), pos))) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                if ((pos = hl.step(pos)) == this.searchStartPos()) break block2;
            } while (hl.key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return hl.value(entry);
        }
        throw new IllegalStateException(this.h().toIdentityString() + ": HashLookup overflow should never occur");
    }

    public void closeQueryHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public boolean keySearchInit() {
        return this.searchState != null;
    }

    public void initKeySearch() {
        long pos;
        boolean wasKeySearchInit = this.keySearchInit();
        while ((pos = this.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            long keySizeOffset = this.entrySpaceOffset() + pos * this.m().chunkSize;
            Bytes segmentBytes = this.segmentBytesForReadGuarded();
            segmentBytes.readPosition(keySizeOffset);
            long keySize = this.h().keySizeMarshaller.readSize(segmentBytes);
            long keyOffset = segmentBytes.readPosition();
            if (!this.keyEquals(keySize, keyOffset)) continue;
            this.found();
            this.readFoundEntry(pos, keySizeOffset, keySize, keyOffset);
            this.searchState = SearchState.PRESENT;
            return;
        }
        this.searchState = SearchState.ABSENT;
        if (wasKeySearchInit) {
            this.closeKeySearchDependants();
        }
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    public void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.closeKeySearchDependants();
        this.searchState = null;
    }

    public void closeKeySearchDependants() {
        this.closeKeySearchSearchStatePresentDependants();
    }

    public boolean searchStateAbsent() {
        return this.searchState() == SearchState.ABSENT;
    }

    public boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    public void closeKeySearchSearchStatePresentDependants() {
        this.closeMapQueryTieredEntryPresentDependants();
        this.closePresenceOfEntry();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    private boolean tieredEntryPresent() {
        int firstTier;
        block5: {
            firstTier = this.tier();
            long firstTierBaseAddr = this.tierBaseAddr();
            do {
                if (this.hasNextTier()) {
                    this.nextTier();
                } else if (this.tier() != 0) {
                    this.initSegmentTier();
                }
                if (this.tierBaseAddr() == firstTierBaseAddr) break block5;
            } while (!this.searchStatePresent());
            return true;
        }
        if (firstTier != 0) {
            this.initSegmentTier();
        }
        return false;
    }

    public void closeMapQueryTieredEntryPresentDependants() {
        this.closePresenceOfEntry();
    }

    public boolean presenceOfEntryInit() {
        return this.entryPresence != null;
    }

    public void initPresenceOfEntry(EntryPresence entryPresence) {
        this.entryPresence = entryPresence;
    }

    private void initPresenceOfEntry() {
        this.entryPresence = this.searchStatePresent() || this.tieredEntryPresent() ? EntryPresence.PRESENT : EntryPresence.ABSENT;
    }

    public EntryPresence entryPresence() {
        if (!this.presenceOfEntryInit()) {
            this.initPresenceOfEntry();
        }
        return this.entryPresence;
    }

    public void closePresenceOfEntry() {
        this.entryPresence = null;
    }

    public boolean entryPresent() {
        return this.entryPresence() == EntryPresence.PRESENT;
    }

    public void putNewVolatile(long entryPos) {
        boolean keySearchReInit;
        boolean bl = keySearchReInit = !this.keySearchInit();
        if (this.searchStatePresent()) {
            throw new AssertionError();
        }
        if (keySearchReInit) {
            this.readExistingEntry(entryPos);
        }
        this.hl().checkValueForPut(entryPos);
        this.hl().writeEntryVolatile(this.addr(), this.hashLookupPos(), this.searchKey(), entryPos);
    }

    void putEntry(Data<V> value) {
        assert (this.searchStateAbsent());
        long entrySize = this.entrySize(this.inputKey().size(), value.size());
        this.initEntryAndKey(entrySize);
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putNewVolatile(this.pos());
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        return this.hl().key(entry) == this.searchKey() && this.hl().value(entry) == value;
    }

    public void closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants() {
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.hl().remove(this.addr(), this.hashLookupPos()));
    }

    public void dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed() {
        if (this.locksInit() && this.nestedContextsLockedOnSameSegment() && this.rootContextLockedOnThisSegment().latestSameThreadSegmentModCount() != this.contextModCount() && this.keySearchInit() && this.searchStatePresent() && !this.checkSlotContainsExpectedKeyAndValue(this.pos())) {
            this.closeHashLookupPos();
        }
    }

    public void closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed();
    }

    public void closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public Data<V> wrapValueBytesAsData(BytesStore bytesStore, long offset, long size) {
        Objects.requireNonNull(bytesStore);
        this.checkOnEachPublicOperation();
        WrappedValueBytesData wrapped = this.wrappedValueBytesData;
        wrapped = wrapped.getUnusedWrappedValueBytesDataGuarded();
        wrapped.initWrappedValueBytesStore(bytesStore, offset, size);
        return wrapped;
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    public CompiledMapQueryContext<K, V, R> entry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? this : null;
    }

    @Override
    @NotNull
    public CompiledMapQueryContext<K, V, R> context() {
        this.checkOnEachPublicOperation();
        return this;
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceDataHolder wrapped = this.wrappedValueInstanceDataHolder;
        wrapped = wrapped.getUnusedWrappedValueHolderGuarded();
        wrapped.initValue(value);
        return wrapped.wrappedData();
    }

    @Override
    public Data<K> queriedKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    @NotNull
    public Data<K> absentKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    @Nullable
    public Absent<K, V> absentEntry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? null : this;
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    @NotNull
    public Data<V> defaultValue() {
        this.checkOnEachPublicOperation();
        return this.zeroValueData;
    }

    @Override
    public boolean checkSum() {
        this.checkOnEachPublicOperation();
        if (!this.h().checksumEntries) {
            throw new UnsupportedOperationException(this.h().toIdentityString() + ": Checksum is not stored in this Chronicle Hash");
        }
        this.innerUpdateLock.lock();
        return this.delayedUpdateChecksumInit() || this.checksumStrategy.innerCheckSum();
    }

    protected void putPrefix() {
        this.checkOnEachPublicOperation();
        if (!this.innerUpdateLock.isHeldByCurrentThread()) {
            this.innerUpdateLock.lock();
        }
        if (this.nestedContextsLockedOnSameSegment() && this.rootContextLockedOnThisSegment().latestSameThreadSegmentModCount() != this.contextModCount() && this.hashLookupPosInit() && this.searchStateAbsent()) {
            this.closeHashLookupPos();
        }
    }

    @Override
    public void doInsert(Data<V> value) {
        this.putPrefix();
        if (this.entryPresent()) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Entry is present in the map when doInsert() is called");
        }
        this.putEntry(value);
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
        this.initPresenceOfEntry(EntryPresence.PRESENT);
    }

    @Override
    public void doInsert() {
        if (this.set() == null) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Called SetAbsentEntry.doInsert() from Map context");
        }
        this.doInsert(DummyValueData.INSTANCE);
    }

    @Override
    public void updateChecksum() {
        this.checkOnEachPublicOperation();
        if (!this.h().checksumEntries) {
            throw new UnsupportedOperationException(this.h().toIdentityString() + ": Checksum is not stored in this Chronicle Hash");
        }
        this.innerUpdateLock.lock();
        this.initDelayedUpdateChecksum(true);
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.tierBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset(), this.pos(), this.entrySizeInChunks());
        if (tierHasChanged && !this.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long hashLookupKey = hl.key(hl.readEntry(oldHashLookupAddr, oldHashLookupPos));
        hl.checkValueForPut(this.pos());
        hl.writeEntryVolatile(this.tierBaseAddr(), this.hashLookupPos(), hashLookupKey, this.pos());
        this.innerWriteLock.lock();
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap<K, V, R> m3 = this.m();
            int newSizeInChunks = m3.inChunks(newEntrySize = this.newEntrySize(newValue, entryStartOffset, newValueOffset = VanillaChronicleMap.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue, this.m().alignment)));
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m3.maxChunksPerEntry) {
                    throw new IllegalArgumentException(m3.toIdentityString() + ": Value too large: entry takes " + newSizeInChunks + " chunks, " + m3.maxChunksPerEntry + " is maximum.");
                }
                if (!this.reallocGuarded(this.pos(), this.entrySizeInChunks(), newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeExtraGuarded(this.pos(), this.entrySizeInChunks(), newSizeInChunks);
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
        } else {
            this.writeValue(newValue);
        }
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.putPrefix();
        if (!this.entryPresent()) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Entry is absent in the map when doReplaceValue() is called");
        }
        this.innerDefaultReplaceValue(newValue);
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
        this.initPresenceOfEntry(EntryPresence.PRESENT);
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.freeGuarded(this.pos(), this.entrySizeInChunks());
        this.incrementModCountGuarded();
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        if (!this.searchStatePresent()) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Entry is absent when doRemove() is called");
        }
        this.innerRemoveEntryExceptHashLookupUpdate();
        this.remove();
        this.setSearchStateGuarded(SearchState.ABSENT);
        this.initPresenceOfEntry(EntryPresence.ABSENT);
    }

    public class UsingReturnValue
    implements UsableReturnValue<V> {
        private V usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINIT;
        private V returnedValue = null;

        public void doCloseUsingReturnValue() {
            this.usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINIT;
        }

        public void doCloseReturnedValue() {
            this.returnedValue = null;
        }

        @Override
        public void returnValue(@NotNull Data<V> value) {
            this.initReturnedValue(value);
        }

        public boolean usingReturnValueInit() {
            return this.usingReturnValue != UsableReturnValue.USING_RETURN_VALUE_UNINIT;
        }

        @Override
        public void initUsingReturnValue(V usingReturnValue) {
            boolean wasUsingReturnValueInit = this.usingReturnValueInit();
            this.usingReturnValue = usingReturnValue;
            if (wasUsingReturnValueInit) {
                this.closeUsingReturnValueDependants();
            }
        }

        public V usingReturnValue() {
            assert (this.usingReturnValueInit()) : "UsingReturnValue should be init";
            return this.usingReturnValue;
        }

        public void closeUsingReturnValue() {
            if (!this.usingReturnValueInit()) {
                return;
            }
            this.closeUsingReturnValueDependants();
            this.usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINIT;
        }

        public void closeUsingReturnValueDependants() {
            this.closeReturnedValue();
        }

        boolean returnedValueInit() {
            return this.returnedValue != null;
        }

        private void initReturnedValue(@NotNull Data<V> value) {
            this.returnedValue = value.getUsing(this.usingReturnValue());
        }

        public V returnedValue() {
            assert (this.returnedValueInit()) : "ReturnedValue should be init";
            return this.returnedValue;
        }

        public void closeReturnedValue() {
            this.returnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.returnedValueInit()) {
                return this.returnedValue();
            }
            return null;
        }
    }

    public class DefaultReturnValue
    implements InstanceReturnValue<V> {
        private V defaultReturnedValue = null;

        public void doCloseDefaultReturnedValue() {
            this.defaultReturnedValue = null;
        }

        @Override
        public void returnValue(@NotNull Data<V> value) {
            this.initDefaultReturnedValue(value);
        }

        boolean defaultReturnedValueInit() {
            return this.defaultReturnedValue != null;
        }

        private void initDefaultReturnedValue(@NotNull Data<V> value) {
            this.defaultReturnedValue = value.getUsing(null);
        }

        public V defaultReturnedValue() {
            assert (this.defaultReturnedValueInit()) : "DefaultReturnedValue should be init";
            return this.defaultReturnedValue;
        }

        public void closeDefaultReturnedValue() {
            this.defaultReturnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.defaultReturnedValueInit()) {
                return this.defaultReturnedValue();
            }
            return null;
        }
    }

    public static enum SearchState {
        PRESENT,
        ABSENT;

    }

    public static enum EntryPresence {
        PRESENT,
        ABSENT;

    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": Cannot acquire write lock, because outer context holds read lock. " + "In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean tryLock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                                CompiledMapQueryContext.this.incrementWriteGuarded();
                                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapQueryContext.this.segmentHeader().tryWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledMapQueryContext.this.incrementWriteGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapQueryContext.this.updateZeroGuarded());
                        if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledMapQueryContext.this.decrementUpdateGuarded();
                            CompiledMapQueryContext.this.incrementWriteGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.decrementUpdateGuarded();
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new IllegalStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)CompiledMapQueryContext.this.localLockState()));
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledMapQueryContext.this.incrementWriteGuarded();
                                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapQueryContext.this.segmentHeader().tryWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapQueryContext.this.incrementWriteGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapQueryContext.this.updateZeroGuarded());
                        if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapQueryContext.this.decrementUpdateGuarded();
                            CompiledMapQueryContext.this.incrementWriteGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.decrementUpdateGuarded();
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new IllegalStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)CompiledMapQueryContext.this.localLockState()));
        }

        @Override
        public boolean isHeldByCurrentThread() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            return CompiledMapQueryContext.this.localLockState().write;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            try {
                                CompiledMapQueryContext.this.segmentHeader().writeLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                            }
                            catch (InterProcessDeadLockException e) {
                                throw CompiledMapQueryContext.this.debugContextsAndLocksGuarded(e);
                            }
                        }
                    }
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapQueryContext.this.updateZeroGuarded());
                        try {
                            CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                        }
                        catch (InterProcessDeadLockException e) {
                            throw CompiledMapQueryContext.this.debugContextsAndLocksGuarded(e);
                        }
                    }
                    CompiledMapQueryContext.this.decrementUpdateGuarded();
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    CompiledMapQueryContext.this.closeDelayedUpdateChecksum();
                    if (CompiledMapQueryContext.this.decrementWriteGuarded() == 0) {
                        CompiledMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                }
            }
        }

        @Override
        public void lock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            try {
                                CompiledMapQueryContext.this.segmentHeader().writeLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                            }
                            catch (InterProcessDeadLockException e) {
                                throw CompiledMapQueryContext.this.debugContextsAndLocksGuarded(e);
                            }
                        }
                    }
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapQueryContext.this.updateZeroGuarded());
                        try {
                            CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        }
                        catch (InterProcessDeadLockException e) {
                            throw CompiledMapQueryContext.this.debugContextsAndLocksGuarded(e);
                        }
                    }
                    CompiledMapQueryContext.this.decrementUpdateGuarded();
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }
    }

    public class WrappedValueInstanceDataHolder {
        private final DataAccess<V> wrappedValueDataAccess;
        private WrappedValueInstanceDataHolder next;
        private V value;
        public Data<V> wrappedData = null;

        public void doCloseValue() {
            if (!this.valueInit()) {
                return;
            }
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void doCloseNext() {
            if (!this.nextInit()) {
                return;
            }
        }

        public void doCloseWrappedData() {
            if (!this.wrappedDataInit()) {
                return;
            }
            this.wrappedData = null;
            this.wrappedValueDataAccess.uninit();
        }

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolderGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValueHolder();
        }

        public WrappedValueInstanceDataHolder() {
            this.wrappedValueDataAccess = (DataAccess)CompiledMapQueryContext.this.m().valueDataAccess.copy();
        }

        public DataAccess<V> wrappedValueDataAccess() {
            return this.wrappedValueDataAccess;
        }

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolder() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceDataHolder();
            }
            return this.next.getUnusedWrappedValueHolder();
        }

        boolean nextInit() {
            return true;
        }

        public WrappedValueInstanceDataHolder next() {
            assert (this.nextInit()) : "Next should be init";
            return this.next;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
            this.closeNextDependants();
        }

        public void closeNextDependants() {
            this.closeValue();
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            boolean wasValueInit = this.valueInit();
            CompiledMapQueryContext.this.m().checkValue(value);
            this.value = value;
            if (wasValueInit) {
                this.closeValueDependants();
            }
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next() != null) {
                this.next().closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeWrappedData();
        }

        public boolean wrappedDataInit() {
            return this.wrappedData != null;
        }

        private void initWrappedData() {
            this.wrappedData = this.wrappedValueDataAccess.getData(this.value());
        }

        public Data<V> wrappedData() {
            if (!this.wrappedDataInit()) {
                this.initWrappedData();
            }
            return this.wrappedData;
        }

        private void closeWrappedData() {
            if (!this.wrappedDataInit()) {
                return;
            }
            this.wrappedData = null;
            this.wrappedValueDataAccess.uninit();
        }
    }

    public class WrappedValueBytesData
    extends AbstractData<V> {
        private final VanillaBytes wrappedValueBytes = new VanillaBytes(NoBytesStore.NO_BYTES_STORE);
        private WrappedValueBytesData next;
        private long wrappedValueBytesOffset;
        private long wrappedValueBytesSize;
        private BytesStore wrappedValueBytesStore;
        private boolean wrappedValueBytesUsed = false;
        private V cachedWrappedValue;
        private boolean cachedWrappedValueRead = false;

        public void doCloseCachedWrappedValue() {
            this.cachedWrappedValueRead = false;
        }

        public void doCloseNext() {
            if (!this.nextInit()) {
                return;
            }
        }

        public void doCloseWrappedValueBytes() {
            if (!this.wrappedValueBytesInit()) {
                return;
            }
            this.wrappedValueBytes.bytesStore(NoBytesStore.NO_BYTES_STORE, 0L, 0L);
            this.wrappedValueBytesUsed = false;
        }

        public void doCloseWrappedValueBytesStore() {
            if (!this.wrappedValueBytesStoreInit()) {
                return;
            }
            this.wrappedValueBytesStore = null;
            if (this.next != null) {
                this.next.closeWrappedValueBytesStore();
            }
        }

        public WrappedValueBytesData getUnusedWrappedValueBytesDataGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValueBytesData();
        }

        public WrappedValueBytesData getUnusedWrappedValueBytesData() {
            if (!this.wrappedValueBytesStoreInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueBytesData();
            }
            return this.next.getUnusedWrappedValueBytesData();
        }

        boolean nextInit() {
            return true;
        }

        public WrappedValueBytesData next() {
            assert (this.nextInit()) : "Next should be init";
            return this.next;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
            this.closeNextDependants();
        }

        public void closeNextDependants() {
            this.closeWrappedValueBytesStore();
        }

        boolean wrappedValueBytesStoreInit() {
            return this.wrappedValueBytesStore != null;
        }

        public void initWrappedValueBytesStore(BytesStore bytesStore, long offset, long size) {
            boolean wasWrappedValueBytesStoreInit = this.wrappedValueBytesStoreInit();
            this.wrappedValueBytesStore = bytesStore;
            this.wrappedValueBytesOffset = offset;
            this.wrappedValueBytesSize = size;
            if (wasWrappedValueBytesStoreInit) {
                this.closeWrappedValueBytesStoreDependants();
            }
        }

        public long wrappedValueBytesSize() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesSize;
        }

        public long wrappedValueBytesOffset() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesOffset;
        }

        public BytesStore wrappedValueBytesStore() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesStore;
        }

        void closeWrappedValueBytesStore() {
            if (!this.wrappedValueBytesStoreInit()) {
                return;
            }
            this.closeWrappedValueBytesStoreDependants();
            this.wrappedValueBytesStore = null;
            if (this.next() != null) {
                this.next().closeWrappedValueBytesStore();
            }
        }

        public void closeWrappedValueBytesStoreDependants() {
            this.closeWrappedValueBytes();
            this.closeWrappedValueBytesDataInnerGetUsingDependants();
        }

        boolean wrappedValueBytesInit() {
            return this.wrappedValueBytesUsed;
        }

        void initWrappedValueBytes() {
            boolean wasWrappedValueBytesInit = this.wrappedValueBytesInit();
            this.wrappedValueBytes.bytesStore(this.wrappedValueBytesStore(), this.wrappedValueBytesOffset(), this.wrappedValueBytesSize());
            this.wrappedValueBytesUsed = true;
            if (wasWrappedValueBytesInit) {
                this.closeWrappedValueBytesDependants();
            }
        }

        public VanillaBytes wrappedValueBytes() {
            if (!this.wrappedValueBytesInit()) {
                this.initWrappedValueBytes();
            }
            return this.wrappedValueBytes;
        }

        void closeWrappedValueBytes() {
            if (!this.wrappedValueBytesInit()) {
                return;
            }
            this.closeWrappedValueBytesDependants();
            this.wrappedValueBytes.bytesStore(NoBytesStore.NO_BYTES_STORE, 0L, 0L);
            this.wrappedValueBytesUsed = false;
        }

        public void closeWrappedValueBytesDependants() {
            this.closeWrappedValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            this.wrappedValueBytes().readPosition(this.wrappedValueBytesOffset());
            return CompiledMapQueryContext.this.valueReader.read(this.wrappedValueBytes(), this.wrappedValueBytesSize(), usingValue);
        }

        public void closeWrappedValueBytesDataInnerGetUsingDependants() {
            this.closeCachedWrappedValue();
        }

        public boolean cachedWrappedValueInit() {
            return this.cachedWrappedValueRead;
        }

        private void initCachedWrappedValue() {
            this.cachedWrappedValue = this.innerGetUsing(this.cachedWrappedValue);
            this.cachedWrappedValueRead = true;
        }

        public V cachedWrappedValue() {
            if (!this.cachedWrappedValueInit()) {
                this.initCachedWrappedValue();
            }
            return this.cachedWrappedValue;
        }

        public void closeCachedWrappedValue() {
            this.cachedWrappedValueRead = false;
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytesOffset();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytes().bytesStore();
        }

        @Override
        public V get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedWrappedValue();
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytesSize();
        }

        @Override
        public V getUsing(V using) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": Cannot acquire update lock, because outer context holds read lock. " + "In this case you should acquire update lock in the outer context up front");
        }

        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": Cannot upgrade from read to update lock");
        }

        @Override
        public boolean isHeldByCurrentThread() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            return CompiledMapQueryContext.this.localLockState().update;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapQueryContext.this.incrementUpdateGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new IllegalStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)CompiledMapQueryContext.this.localLockState()));
        }

        @Override
        public boolean tryLock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledMapQueryContext.this.incrementUpdateGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new IllegalStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)CompiledMapQueryContext.this.localLockState()));
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledMapQueryContext.this.segmentHeader().updateLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                        }
                        catch (InterProcessDeadLockException e) {
                            throw CompiledMapQueryContext.this.debugContextsAndLocksGuarded(e);
                        }
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public void unlock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.closeDelayedUpdateChecksum();
                    if (CompiledMapQueryContext.this.decrementUpdateGuarded() != 0 || !CompiledMapQueryContext.this.writeZeroGuarded()) break;
                    CompiledMapQueryContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledMapQueryContext.this.closeDelayedUpdateChecksum();
                    if (CompiledMapQueryContext.this.decrementWriteGuarded() != 0) break;
                    if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                        CompiledMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        break;
                    }
                    CompiledMapQueryContext.this.segmentHeader().downgradeWriteToReadLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapQueryContext.this.incrementReadGuarded();
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledMapQueryContext.this.segmentHeader().updateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        }
                        catch (InterProcessDeadLockException e) {
                            throw CompiledMapQueryContext.this.debugContextsAndLocksGuarded(e);
                        }
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public boolean isHeldByCurrentThread() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            return CompiledMapQueryContext.this.localLockState().read;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapQueryContext.this.readZeroGuarded() && CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                    try {
                        CompiledMapQueryContext.this.segmentHeader().readLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    }
                    catch (InterProcessDeadLockException e) {
                        throw CompiledMapQueryContext.this.debugContextsAndLocksGuarded(e);
                    }
                }
                CompiledMapQueryContext.this.incrementReadGuarded();
                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapQueryContext.this.readZeroGuarded() && CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                    try {
                        CompiledMapQueryContext.this.segmentHeader().readLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    }
                    catch (InterProcessDeadLockException e) {
                        throw CompiledMapQueryContext.this.debugContextsAndLocksGuarded(e);
                    }
                }
                CompiledMapQueryContext.this.incrementReadGuarded();
                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledMapQueryContext.this.closeHashLookupPos();
        }

        @Override
        public void unlock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (CompiledMapQueryContext.this.localLockState() != LocalLockState.UNLOCKED) {
                CompiledMapQueryContext.this.closeHashLookupPos();
                CompiledMapQueryContext.this.closeEntry();
            }
            CompiledMapQueryContext.this.readUnlockAndDecrementCountGuarded();
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
        }

        @Override
        public boolean tryLock() {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledMapQueryContext.this.readZeroGuarded() || !CompiledMapQueryContext.this.updateZeroGuarded() || !CompiledMapQueryContext.this.writeZeroGuarded() || CompiledMapQueryContext.this.segmentHeader().tryReadLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                    CompiledMapQueryContext.this.incrementReadGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledMapQueryContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledMapQueryContext.this.readZeroGuarded() || !CompiledMapQueryContext.this.updateZeroGuarded() || !CompiledMapQueryContext.this.writeZeroGuarded() || CompiledMapQueryContext.this.segmentHeader().tryReadLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledMapQueryContext.this.incrementReadGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class InputKeyBytesData
    extends AbstractData<K> {
        private final VanillaBytes inputKeyBytes = new VanillaBytes(NoBytesStore.NO_BYTES_STORE);
        private long inputKeyBytesOffset;
        private long inputKeyBytesSize;
        private BytesStore inputKeyBytesStore = null;
        private boolean inputKeyBytesUsed = false;
        private K cachedInputKey;
        private boolean cachedInputKeyRead = false;

        public void doCloseInputKeyBytesStore() {
            this.inputKeyBytesStore = null;
        }

        public void doCloseCachedInputKey() {
            this.cachedInputKeyRead = false;
        }

        public void doCloseInputKeyBytes() {
            if (!this.inputKeyBytesInit()) {
                return;
            }
            this.inputKeyBytes.bytesStore(NoBytesStore.NO_BYTES_STORE, 0L, 0L);
            this.inputKeyBytesUsed = false;
        }

        public boolean inputKeyBytesStoreInit() {
            return this.inputKeyBytesStore != null;
        }

        public void initInputKeyBytesStore(BytesStore bytesStore, long offset, long size) {
            boolean wasInputKeyBytesStoreInit = this.inputKeyBytesStoreInit();
            this.inputKeyBytesStore = bytesStore;
            this.inputKeyBytesOffset = offset;
            this.inputKeyBytesSize = size;
            if (wasInputKeyBytesStoreInit) {
                this.closeInputKeyBytesStoreDependants();
            }
        }

        public long inputKeyBytesSize() {
            assert (this.inputKeyBytesStoreInit()) : "InputKeyBytesStore should be init";
            return this.inputKeyBytesSize;
        }

        public long inputKeyBytesOffset() {
            assert (this.inputKeyBytesStoreInit()) : "InputKeyBytesStore should be init";
            return this.inputKeyBytesOffset;
        }

        public BytesStore inputKeyBytesStore() {
            assert (this.inputKeyBytesStoreInit()) : "InputKeyBytesStore should be init";
            return this.inputKeyBytesStore;
        }

        public void closeInputKeyBytesStore() {
            if (!this.inputKeyBytesStoreInit()) {
                return;
            }
            this.closeInputKeyBytesStoreDependants();
            this.inputKeyBytesStore = null;
        }

        public void closeInputKeyBytesStoreDependants() {
            this.closeInputKeyBytes();
            this.closeInputKeyBytesDataInnerGetUsingDependants();
        }

        boolean inputKeyBytesInit() {
            return this.inputKeyBytesUsed;
        }

        void initInputKeyBytes() {
            boolean wasInputKeyBytesInit = this.inputKeyBytesInit();
            this.inputKeyBytes.bytesStore(this.inputKeyBytesStore(), this.inputKeyBytesOffset(), this.inputKeyBytesSize());
            this.inputKeyBytesUsed = true;
            if (wasInputKeyBytesInit) {
                this.closeInputKeyBytesDependants();
            }
        }

        public VanillaBytes inputKeyBytes() {
            if (!this.inputKeyBytesInit()) {
                this.initInputKeyBytes();
            }
            return this.inputKeyBytes;
        }

        void closeInputKeyBytes() {
            if (!this.inputKeyBytesInit()) {
                return;
            }
            this.closeInputKeyBytesDependants();
            this.inputKeyBytes.bytesStore(NoBytesStore.NO_BYTES_STORE, 0L, 0L);
            this.inputKeyBytesUsed = false;
        }

        public void closeInputKeyBytesDependants() {
            this.closeInputKeyBytesDataInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            this.inputKeyBytes().readPosition(this.inputKeyBytesOffset());
            return CompiledMapQueryContext.this.keyReader.read(this.inputKeyBytes(), this.inputKeyBytesSize(), usingKey);
        }

        public void closeInputKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedInputKey();
        }

        public boolean cachedInputKeyInit() {
            return this.cachedInputKeyRead;
        }

        private void initCachedInputKey() {
            this.cachedInputKey = this.innerGetUsing(this.cachedInputKey);
            this.cachedInputKeyRead = true;
        }

        public K cachedInputKey() {
            if (!this.cachedInputKeyInit()) {
                this.initCachedInputKey();
            }
            return this.cachedInputKey;
        }

        public void closeCachedInputKey() {
            this.cachedInputKeyRead = false;
        }

        @Override
        public K get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedInputKey();
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.inputKeyBytesOffset();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.inputKeyBytes().bytesStore();
        }

        @Override
        public K getUsing(K using) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.inputKeyBytesSize();
        }
    }

    public class HashEntryChecksumStrategy
    implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return 4L;
        }

        @Override
        public int computeChecksum() {
            long checksum;
            long keyHashCode = CompiledMapQueryContext.this.keyHashCode();
            long keyEnd = CompiledMapQueryContext.this.keyEnd();
            long len = CompiledMapQueryContext.this.entryEnd() - keyEnd;
            if (len > 0L) {
                long addr = CompiledMapQueryContext.this.tierBaseAddr() + keyEnd;
                long payloadChecksum = LongHashFunction.xx_r39().hashMemory(addr, len);
                checksum = ChecksumHashing.hash8To16Bytes(CompiledMapQueryContext.this.keySize(), keyHashCode, payloadChecksum);
            } else {
                checksum = keyHashCode;
            }
            return (int)(checksum >>> 32 ^ checksum);
        }

        public void closeHashEntryChecksumStrategyComputeChecksumDependants() {
            this.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        }

        @Override
        public void computeAndStoreChecksum() {
            int checksum = this.computeChecksum();
            CompiledMapQueryContext.this.segmentBS().writeInt(CompiledMapQueryContext.this.entryEnd(), checksum);
        }

        public void closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants() {
            CompiledMapQueryContext.this.closeDelayedUpdateChecksum();
        }

        @Override
        public int storedChecksum() {
            return CompiledMapQueryContext.this.segmentBS().readInt(CompiledMapQueryContext.this.entryEnd());
        }

        @Override
        public boolean innerCheckSum() {
            int checksum;
            int oldChecksum = this.storedChecksum();
            return oldChecksum == (checksum = this.computeChecksum());
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead;

        public EntryValueBytesData() {
            this.cachedEntryValue = CompiledMapQueryContext.this.m().valueClass() == CharSequence.class ? new StringBuilder() : null;
            this.cachedEntryValueRead = false;
        }

        public void doCloseCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            Bytes segmentBytes = CompiledMapQueryContext.this.segmentBytesForReadGuarded();
            segmentBytes.readPosition(CompiledMapQueryContext.this.valueOffset());
            return CompiledMapQueryContext.this.valueReader.read(segmentBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }

        @Override
        public V getUsing(V using) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.segmentBS();
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        public void doCloseCachedEntryKey() {
            this.cachedEntryKeyRead = false;
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keyOffset();
        }

        @Override
        public long hash(LongHashFunction f) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            if (f == LongHashFunction.xx_r39() && CompiledMapQueryContext.this.keySize() == 4L && CompiledMapQueryContext.this.h().keyDataAccess instanceof IntegerDataAccess) {
                return WrongXxHash.hashInt(CompiledMapQueryContext.this.segmentBS().readInt(CompiledMapQueryContext.this.keyOffset()));
            }
            return super.hash(f);
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            Bytes bytes = CompiledMapQueryContext.this.segmentBytesForReadGuarded();
            bytes.readPosition(CompiledMapQueryContext.this.keyOffset());
            return CompiledMapQueryContext.this.keyReader.read(bytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K using) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.segmentBS();
        }
    }

    public class DummyValueZeroData
    extends AbstractData<V> {
        private final Bytes zeroBytes = ZeroBytesStore.INSTANCE.bytesForRead();

        public Bytes zeroBytes() {
            return this.zeroBytes;
        }

        private IllegalStateException zeroReadException(Exception cause) {
            return new IllegalStateException(CompiledMapQueryContext.this.h().toIdentityString() + ": Most probable cause of this exception - zero bytes of\n" + "the minimum positive encoding length, supported by the specified or default\n" + "valueSizeMarshaller() is not correct serialized form of any value. You should\n" + "configure defaultValueProvider() in ChronicleMapBuilder", cause);
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return ZeroBytesStore.INSTANCE;
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return Math.max(0L, CompiledMapQueryContext.this.m().valueSizeMarshaller.minStorableSize());
        }

        @Override
        public V getUsing(V using) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.zeroBytes.readPosition(0L);
            try {
                return CompiledMapQueryContext.this.valueReader.read(this.zeroBytes, this.size(), using);
            }
            catch (Exception e) {
                throw this.zeroReadException(e);
            }
        }

        @Override
        public V get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.getUsing((V)null);
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return 0L;
        }
    }

    public class AcquireHandle
    implements Closeable {
        @Override
        public void close() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            CompiledMapQueryContext.this.replaceValue(CompiledMapQueryContext.this.entry(), CompiledMapQueryContext.this.wrapValueAsData(CompiledMapQueryContext.this.usingReturnValue.returnValue()));
            CompiledMapQueryContext.this.close();
        }
    }
}

