/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.values.PointersBytesStore;
import net.openhft.chronicle.values.ValueModel;
import sun.misc.Unsafe;

class ValueBuilder {
    final ValueModel model;
    final String className;
    final TypeSpec.Builder typeBuilder;
    private FieldSpec unsafe;
    private CodeBlock.Builder staticBlockBuilder;
    private MethodSpec.Builder defaultConstructorBuilder;
    private FieldSpec bytesStoreForPointers;

    public ValueBuilder(ValueModel model, String className, TypeSpec.Builder typeBuilder) {
        this.model = model;
        this.className = className;
        this.typeBuilder = typeBuilder;
    }

    ClassName className() {
        return ClassName.get(this.model.valueType.getPackage().getName(), this.className, new String[0]);
    }

    FieldSpec unsafe() {
        if (this.unsafe == null) {
            this.unsafe = FieldSpec.builder(Unsafe.class, "UNSAFE", new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).build();
            this.typeBuilder.addField(this.unsafe);
            this.staticBlockBuilder().beginControlFlow("try", new Object[0]).addStatement("$T theUnsafe = $T.getField($T.class, $S)", Field.class, Jvm.class, Unsafe.class, "theUnsafe").addStatement("$N = ($T) theUnsafe.get(null)", this.unsafe, Unsafe.class);
        }
        return this.unsafe;
    }

    CodeBlock.Builder staticBlockBuilder() {
        if (this.staticBlockBuilder == null) {
            this.staticBlockBuilder = CodeBlock.builder();
        }
        return this.staticBlockBuilder;
    }

    MethodSpec.Builder defaultConstructorBuilder() {
        if (this.defaultConstructorBuilder == null) {
            this.defaultConstructorBuilder = MethodSpec.constructorBuilder();
            this.defaultConstructorBuilder.addModifiers(Modifier.PUBLIC);
        }
        return this.defaultConstructorBuilder;
    }

    void closeConstructorsAndInitializationBlocks() {
        if (this.staticBlockBuilder != null) {
            this.staticBlockBuilder.nextControlFlow("catch ($T e)", IllegalAccessException.class);
            this.staticBlockBuilder.addStatement("throw new $T(e)", AssertionError.class);
            this.staticBlockBuilder.endControlFlow();
            this.typeBuilder.addStaticBlock(this.staticBlockBuilder.build());
        }
        if (this.defaultConstructorBuilder != null) {
            this.typeBuilder.addMethod(this.defaultConstructorBuilder.build());
        }
    }

    FieldSpec bytesStoreForPointers() {
        if (this.bytesStoreForPointers == null) {
            ParameterizedTypeName bsType = ParameterizedTypeName.get(NativeBytesStore.class, new Type[]{Void.class});
            this.bytesStoreForPointers = FieldSpec.builder(bsType, "bytesStoreForPointers", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer("$T.instance()", PointersBytesStore.class).build();
            this.typeBuilder.addField(this.bytesStoreForPointers);
        }
        return this.bytesStoreForPointers;
    }
}

