/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.sql;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.lang.VersionUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SqlUtils {
    static final MLogger logger = MLog.getLogger(SqlUtils.class);
    static final DateFormat tsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
    public static final String DRIVER_MANAGER_USER_PROPERTY = "user";
    public static final String DRIVER_MANAGER_PASSWORD_PROPERTY = "password";

    public static String escapeBadSqlPatternChars(String s2) {
        StringBuffer sb = new StringBuffer(s2);
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++len;
            i += 2;
        }
        return sb.toString();
    }

    public static synchronized String escapeAsTimestamp(Date date) {
        return "{ts '" + tsdf.format(date) + "'}";
    }

    public static SQLException toSQLException(Throwable t) {
        return SqlUtils.toSQLException(null, t);
    }

    public static SQLException toSQLException(String msg, Throwable t) {
        return SqlUtils.toSQLException(msg, null, t);
    }

    public static SQLException toSQLException(String msg, String sqlState, Throwable t) {
        if (t instanceof SQLException) {
            if (logger.isLoggable(MLevel.FINER)) {
                SQLException s2 = (SQLException)t;
                StringBuffer tmp = new StringBuffer(255);
                tmp.append("Attempted to convert SQLException to SQLException. Leaving it alone.");
                tmp.append(" [SQLState: ");
                tmp.append(s2.getSQLState());
                tmp.append("; errorCode: ");
                tmp.append(s2.getErrorCode());
                tmp.append(']');
                if (msg != null) {
                    tmp.append(" Ignoring suggested message: '" + msg + "'.");
                }
                logger.log(MLevel.FINER, tmp.toString(), t);
                SQLException s22 = s2;
                while ((s22 = s22.getNextException()) != null) {
                    logger.log(MLevel.FINER, "Nested SQLException or SQLWarning: ", s22);
                }
            }
            return (SQLException)t;
        }
        if (logger.isLoggable(MLevel.FINE)) {
            logger.log(MLevel.FINE, "Converting Throwable to SQLException...", t);
        }
        if (msg == null) {
            msg = "An SQLException was provoked by the following failure: " + t.toString();
        }
        if (VersionUtils.isAtLeastJavaVersion14()) {
            SQLException out = new SQLException(msg);
            out.initCause(t);
            return out;
        }
        return new SQLException(msg + System.getProperty("line.separator") + "[Cause: " + ThrowableUtils.extractStackTrace(t) + ']', sqlState);
    }

    private SqlUtils() {
    }
}

