/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.util.BitSet;
import net.openhft.affinity.IAffinity;
import net.openhft.affinity.impl.LinuxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LinuxJNAAffinity implements IAffinity
{
    INSTANCE;

    public static final boolean LOADED;
    private static final Logger LOGGER;
    private static final int PROCESS_ID;
    private static final int SYS_gettid;
    private static final Object[] NO_ARGS;
    private final ThreadLocal<Integer> THREAD_ID = new ThreadLocal();

    @Override
    public BitSet getAffinity() {
        LinuxHelper.cpu_set_t cpuset = LinuxHelper.sched_getaffinity();
        BitSet ret = new BitSet(1024);
        int i = 0;
        for (NativeLong nl : cpuset.__bits) {
            for (int j = 0; j < 64; ++j) {
                ret.set(i++, (nl.longValue() >>> j & 1L) != 0L);
            }
        }
        return ret;
    }

    @Override
    public void setAffinity(BitSet affinity) {
        LinuxHelper.sched_setaffinity(affinity);
    }

    @Override
    public int getCpu() {
        return LinuxHelper.sched_getcpu();
    }

    @Override
    public int getProcessId() {
        return PROCESS_ID;
    }

    @Override
    public int getThreadId() {
        Integer tid = this.THREAD_ID.get();
        if (tid == null) {
            tid = LinuxHelper.syscall(SYS_gettid, NO_ARGS);
            this.THREAD_ID.set(tid);
        }
        return tid;
    }

    static {
        LOGGER = LoggerFactory.getLogger(LinuxJNAAffinity.class);
        SYS_gettid = Platform.is64Bit() ? 186 : 224;
        NO_ARGS = new Object[0];
        int pid = -1;
        try {
            pid = LinuxHelper.getpid();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PROCESS_ID = pid;
        boolean loaded = false;
        try {
            INSTANCE.getAffinity();
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("Unable to load jna library {}", e);
        }
        LOADED = loaded;
    }
}

