/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import org.jetbrains.annotations.Nullable;

public interface Data<T> {
    public static boolean bytesEquivalent(Data<?> d1, Data<?> d2) {
        return d1.size() == d2.size() && d1.equivalent(d2.bytes(), d2.offset());
    }

    public RandomDataInput bytes();

    public long offset();

    public long size();

    default public long hash(LongHashFunction f) {
        return f.hash(this.bytes(), Access.checkedRandomDataInputAccess(), this.offset(), this.size());
    }

    default public boolean equivalent(RandomDataInput source, long sourceOffset) {
        return BytesUtil.bytesEqual(source, sourceOffset, this.bytes(), this.offset(), this.size());
    }

    default public void writeTo(RandomDataOutput target, long targetOffset) {
        target.write(targetOffset, this.bytes(), this.offset(), this.size());
    }

    public T get();

    public T getUsing(@Nullable T var1);

    default public int dataHashCode() {
        return (int)this.hash(LongHashFunction.xx_r39());
    }

    default public boolean dataEquals(Object obj) {
        return obj != null && obj instanceof Data && Data.bytesEquivalent(this, (Data)obj);
    }

    default public String dataToString() {
        try {
            return this.get().toString();
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("failed to deserialize object from data with bytes: [");
            RandomDataInput bs = this.bytes();
            long lim = this.offset() + this.size();
            for (long off = this.offset(); off < lim; ++off) {
                sb.append(bs.printable(off));
            }
            sb.append("], exception: ");
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            sb.append(exceptionAsString);
            return sb.toString();
        }
    }
}

