/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization;

import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListMarshaller<T>
implements BytesReader<List<T>>,
BytesWriter<List<T>>,
StatefulCopyable<ListMarshaller<T>> {
    private BytesReader<T> elementReader;
    private BytesWriter<? super T> elementWriter;

    public ListMarshaller(BytesReader<T> elementReader, BytesWriter<? super T> elementWriter) {
        this.elementReader = elementReader;
        this.elementWriter = elementWriter;
    }

    public static <T> ListMarshaller<T> of(BytesReader<T> elementReader, BytesWriter<? super T> elementWriter) {
        return new ListMarshaller<T>(elementReader, elementWriter);
    }

    public static <T, M extends BytesReader<T> & BytesWriter<? super T>> ListMarshaller<T> of(M elementMarshaller) {
        return ListMarshaller.of(elementMarshaller, elementMarshaller);
    }

    @Override
    @NotNull
    public List<T> read(Bytes in, @Nullable List<T> using) {
        int i;
        int size = in.readInt();
        if (using == null) {
            using = new ArrayList<T>(size);
            for (i = 0; i < size; ++i) {
                using.add(null);
            }
        } else if (using.size() < size) {
            while (using.size() < size) {
                using.add(null);
            }
        } else if (using.size() > size) {
            using.subList(size, using.size()).clear();
        }
        for (i = 0; i < size; ++i) {
            using.set(i, this.elementReader.read(in, using.get(i)));
        }
        return using;
    }

    @Override
    public void write(Bytes out, @NotNull List<T> toWrite) {
        out.writeInt(toWrite.size());
        for (int i = 0; i < toWrite.size(); ++i) {
            this.elementWriter.write(out, toWrite.get(i));
        }
    }

    @Override
    public ListMarshaller<T> copy() {
        if (this.elementReader instanceof StatefulCopyable || this.elementWriter instanceof StatefulCopyable) {
            return new ListMarshaller<T>(StatefulCopyable.copyIfNeeded(this.elementReader), StatefulCopyable.copyIfNeeded(this.elementWriter));
        }
        return this;
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        this.elementReader = (BytesReader)wireIn.read(() -> "elementReader").typedMarshallable();
        this.elementWriter = (BytesWriter)wireIn.read(() -> "elementWriter").typedMarshallable();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "elementReader").typedMarshallable(this.elementReader);
        wireOut.write(() -> "elementWriter").typedMarshallable(this.elementWriter);
    }
}

