/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import org.jetbrains.annotations.NotNull;

public class TextLongReference
extends AbstractReference
implements LongReference {
    static final int VALUE = 33;
    private static final byte[] template = "!!atomic { locked: false, value: 00000000000000000000 }".getBytes(StandardCharsets.ISO_8859_1);
    private static final int FALSE = BytesUtil.asInt("fals");
    private static final int TRUE = BytesUtil.asInt(" tru");
    private static final long UNINITIALIZED = 0L;
    private static final long LONG_TRUE = 1L;
    private static final long LONG_FALSE = 0L;
    private static final int LOCKED = 19;
    private static final int DIGITS = 20;

    public static void write(@NotNull Bytes bytes, long value) throws BufferOverflowException, IllegalArgumentException {
        long position = bytes.writePosition();
        bytes.write(template);
        bytes.append(position + 33L, value, 20);
    }

    private long withLock(@NotNull LongSupplier call) throws IllegalStateException, BufferUnderflowException {
        long valueOffset = this.offset + 19L;
        int value = this.bytes.readVolatileInt(valueOffset);
        if (value != FALSE && value != TRUE) {
            throw new IllegalStateException("Not a lock value");
        }
        try {
            while (!this.bytes.compareAndSwapInt(valueOffset, FALSE, TRUE)) {
            }
            long t = call.getAsLong();
            this.bytes.writeOrderedInt(valueOffset, FALSE);
            return t;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != (long)template.length) {
            throw new IllegalArgumentException();
        }
        super.bytesStore(bytes, offset, length);
        if (bytes.readLong(offset) == 0L) {
            bytes.write(offset, template);
        }
    }

    @Override
    public long getValue() {
        return this.withLock(() -> this.bytes.parseLong(this.offset + 33L));
    }

    @Override
    public void setValue(long value) {
        this.withLock(() -> {
            this.bytes.append(this.offset + 33L, value, 20);
            return 1L;
        });
    }

    @Override
    public long getVolatileValue() {
        return this.getValue();
    }

    @Override
    public long maxSize() {
        return template.length;
    }

    @Override
    public void setOrderedValue(long value) {
        this.setValue(value);
    }

    @NotNull
    public String toString() {
        return "value: " + this.getValue();
    }

    @Override
    public long addValue(long delta) {
        return this.withLock(() -> {
            long value = this.bytes.parseLong(this.offset + 33L) + delta;
            this.bytes.append(this.offset + 33L, value, 20);
            return value;
        });
    }

    @Override
    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    @Override
    public boolean compareAndSwapValue(long expected, long value) {
        return this.withLock(() -> {
            if (this.bytes.parseLong(this.offset + 33L) == expected) {
                this.bytes.append(this.offset + 33L, value, 20);
                return 1L;
            }
            return 0L;
        }) == 1L;
    }
}

