/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;

public final class IntCompactOffHeapLinearHashTable
extends CompactOffHeapLinearHashTable {
    private static final long SCALE = 4L;

    IntCompactOffHeapLinearHashTable(VanillaChronicleHash h2) {
        super(h2);
    }

    @Override
    long indexToPos(long index) {
        return index * 4L;
    }

    @Override
    public long step(long pos) {
        return pos + 4L & this.capacityMask2;
    }

    @Override
    public long stepBack(long pos) {
        return pos - 4L & this.capacityMask2;
    }

    @Override
    public long readEntry(long addr, long pos) {
        return OS.memory().readInt(addr + pos);
    }

    @Override
    public long readEntryVolatile(long addr, long pos) {
        return OS.memory().readVolatileInt(addr + pos);
    }

    @Override
    public void writeEntryVolatile(long addr, long pos, long key, long value) {
        OS.memory().writeVolatileInt(addr + pos, (int)this.entry(key, value));
    }

    @Override
    public void writeEntry(long addr, long pos, long newEntry) {
        OS.memory().writeInt(addr + pos, (int)newEntry);
    }

    @Override
    public void clearEntry(long addr, long pos) {
        OS.memory().writeInt(addr + pos, 0);
    }
}

