/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.iter;

import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.iter.TierRecovery;
import net.openhft.chronicle.map.ChronicleHashCorruptionImpl;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class SegmentsRecovery
implements IterationContext {
    @StageRef
    VanillaChronicleHashHolder<?> hh;
    @StageRef
    SegmentStages s;
    @StageRef
    TierRecovery tierRecovery;

    @Override
    public void recoverSegments(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long storedFirstFreeTierIndex;
        VanillaChronicleHash<?, ?, ?, ?> h2 = this.hh.h();
        for (int segmentIndex = 0; segmentIndex < h2.actualSegments; ++segmentIndex) {
            this.s.initSegmentIndex(segmentIndex);
            this.resetSegmentLock(corruptionListener, corruption);
            this.zeroOutFirstSegmentTierCountersArea(corruptionListener, corruption);
            this.tierRecovery.recoverTier(segmentIndex, corruptionListener, corruption);
        }
        VanillaGlobalMutableState globalMutableState = h2.globalMutableState();
        long storedExtraTiersInUse = globalMutableState.getExtraTiersInUse();
        long allocatedExtraTiers = (long)globalMutableState.getAllocatedExtraTierBulks() * h2.tiersInBulk;
        long expectedExtraTiersInUse = Math.max(0L, Math.min(storedExtraTiersInUse, allocatedExtraTiers));
        long actualExtraTiersInUse = 0L;
        long firstFreeExtraTierIndex = -1L;
        for (long extraTierIndex = 0L; extraTierIndex < expectedExtraTiersInUse; ++extraTierIndex) {
            long tierCountersAreaAddr;
            long tierIndex = h2.extraTierIndexToTierIndex(extraTierIndex);
            this.s.initSegmentTier(0, tierIndex);
            int segmentIndex = this.tierRecovery.recoverTier(-1, corruptionListener, corruption);
            if (segmentIndex >= 0) {
                tierCountersAreaAddr = this.s.tierCountersAreaAddr();
                int storedSegmentIndex = TierCountersArea.segmentIndex(tierCountersAreaAddr);
                if (storedSegmentIndex != segmentIndex) {
                    ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("wrong segment index stored in tier counters area of tier with index {}: {}, should be, based on entries: {}", tierIndex, storedSegmentIndex, segmentIndex));
                    TierCountersArea.segmentIndex(tierCountersAreaAddr, segmentIndex);
                }
            } else {
                firstFreeExtraTierIndex = extraTierIndex;
                break;
            }
            this.s.nextTierIndex(0L);
            this.s.initSegmentIndex(segmentIndex);
            this.s.goToLastTier();
            this.s.nextTierIndex(tierIndex);
            TierCountersArea.prevTierIndex(tierCountersAreaAddr, this.s.tierIndex);
            TierCountersArea.tier(tierCountersAreaAddr, this.s.tier + 1);
            actualExtraTiersInUse = extraTierIndex + 1L;
        }
        if (storedExtraTiersInUse != actualExtraTiersInUse) {
            long finalActualExtraTiersInUse = actualExtraTiersInUse;
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("wrong number of actual tiers in use in global mutable state, stored: {}, should be: {}", storedExtraTiersInUse, finalActualExtraTiersInUse));
            globalMutableState.setExtraTiersInUse(actualExtraTiersInUse);
        }
        long firstFreeTierIndex = firstFreeExtraTierIndex == -1L ? (allocatedExtraTiers > expectedExtraTiersInUse ? h2.extraTierIndexToTierIndex(expectedExtraTiersInUse) : 0L) : h2.extraTierIndexToTierIndex(firstFreeExtraTierIndex);
        if (firstFreeTierIndex > 0L) {
            long lastTierIndex = h2.extraTierIndexToTierIndex(allocatedExtraTiers - 1L);
            h2.linkAndZeroOutFreeTiers(firstFreeTierIndex, lastTierIndex);
        }
        if ((storedFirstFreeTierIndex = globalMutableState.getFirstFreeTierIndex()) != firstFreeTierIndex) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("wrong first free tier index in global mutable state, stored: {}, should be: {}", storedFirstFreeTierIndex, firstFreeTierIndex));
            globalMutableState.setFirstFreeTierIndex(firstFreeTierIndex);
        }
        this.removeDuplicatesInSegments(corruptionListener, corruption);
    }

    private void removeDuplicatesInSegments(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        VanillaChronicleHash<?, ?, ?, ?> h2 = this.hh.h();
        block0: for (int segmentIndex = 0; segmentIndex < h2.actualSegments; ++segmentIndex) {
            this.s.initSegmentIndex(segmentIndex);
            this.s.initSegmentTier();
            this.s.goToLastTier();
            while (true) {
                this.tierRecovery.removeDuplicatesInSegment(corruptionListener, corruption);
                if (this.s.tier <= 0) continue block0;
                this.s.prevTier();
            }
        }
    }

    private void resetSegmentLock(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long lockState = this.s.segmentHeader.getLockState(this.s.segmentHeaderAddress);
        if (lockState != this.s.segmentHeader.resetLockState()) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.s.segmentIndex, () -> ChronicleHashCorruptionImpl.format("lock of segment {} is not clear: {}", this.s.segmentIndex, this.s.segmentHeader.lockStateToString(lockState)));
            this.s.segmentHeader.resetLock(this.s.segmentHeaderAddress);
        }
    }

    private void zeroOutFirstSegmentTierCountersArea(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long tierCountersAreaAddr;
        this.s.nextTierIndex(0L);
        if (this.s.prevTierIndex() != 0L) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.s.segmentIndex, () -> ChronicleHashCorruptionImpl.format("stored prev tier index in first tier of segment {}: {}, should be 0", this.s.segmentIndex, this.s.prevTierIndex()));
            this.s.prevTierIndex(0L);
        }
        if (TierCountersArea.segmentIndex(tierCountersAreaAddr = this.s.tierCountersAreaAddr()) != 0) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.s.segmentIndex, () -> ChronicleHashCorruptionImpl.format("stored segment index in first tier of segment {}: {}, should be 0", this.s.segmentIndex, TierCountersArea.segmentIndex(tierCountersAreaAddr)));
            TierCountersArea.segmentIndex(tierCountersAreaAddr, 0);
        }
        if (TierCountersArea.tier(tierCountersAreaAddr) != 0) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.s.segmentIndex, () -> ChronicleHashCorruptionImpl.format("stored tier in first tier of segment {}: {}, should be 0", this.s.segmentIndex, TierCountersArea.tier(tierCountersAreaAddr)));
            TierCountersArea.tier(tierCountersAreaAddr, 0);
        }
    }
}

