/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util.jna;

import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.IOException;

public final class PosixMsync {
    private static final int MS_SYNC = 4;

    private PosixMsync() {
    }

    public static void msync(long addr, long length) throws IOException {
        if (PosixMsync.msync(new Pointer(addr), new size_t(length), 4) == -1) {
            throw new IOException("msync failed: error code " + Native.getLastError());
        }
    }

    private static native int msync(Pointer var0, size_t var1, int var2);

    static {
        NativeLibrary clib = NativeLibrary.getInstance(Platform.C_LIBRARY_NAME);
        Native.register(PosixMsync.class, clib);
    }

    public static class size_t
    extends IntegerType {
        private static final long serialVersionUID = 0L;

        public size_t() {
            this(0L);
        }

        public size_t(long value) {
            super(Native.SIZE_T_SIZE, value, true);
        }
    }
}

