/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.function.Supplier;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import org.jetbrains.annotations.Nullable;
import org.slf4j.helpers.MessageFormatter;

public class ChronicleHashCorruptionImpl
implements ChronicleHashCorruption {
    private int segmentIndex;
    private Supplier<String> messageSupplier;
    private Throwable exception;
    private String message;

    public static void report(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption, int segmentIndex, Supplier<String> messageSupplier) {
        corruption.set(segmentIndex, messageSupplier, null);
        corruptionListener.onCorruption(corruption);
    }

    public static void reportException(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption, int segmentIndex, Supplier<String> messageSupplier, Throwable exception) {
        corruption.set(segmentIndex, messageSupplier, exception);
        corruptionListener.onCorruption(corruption);
    }

    public static String format(String message, Object ... args) {
        return MessageFormatter.arrayFormat(message, args).getMessage();
    }

    private void set(int segmentIndex, Supplier<String> messageSupplier, Throwable exception) {
        this.segmentIndex = segmentIndex;
        this.messageSupplier = messageSupplier;
        this.exception = exception;
        this.message = null;
    }

    @Override
    public String message() {
        if (this.message == null) {
            this.message = this.messageSupplier.get();
        }
        return this.message;
    }

    @Override
    @Nullable
    public Throwable exception() {
        return this.exception;
    }

    @Override
    public int segmentIndex() {
        return this.segmentIndex;
    }
}

