/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.Pauser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongPauser
implements Pauser {
    private static final String SHOW_PAUSES = System.getProperty("pauses.show");
    private final long minPauseTimeNS;
    private final long maxPauseTimeNS;
    private final AtomicBoolean pausing = new AtomicBoolean();
    private final int minBusy;
    private final int minCount;
    private int count = 0;
    private long pauseTimeNS;
    private long timePaused = 0L;
    private long countPaused = 0L;
    @Nullable
    private volatile Thread thread = null;
    private long yieldStart = 0L;
    private long timeOutStart = Long.MAX_VALUE;

    public LongPauser(int minBusy, int minCount, long minTime, long maxTime, @NotNull TimeUnit timeUnit) {
        this.minBusy = minBusy;
        this.minCount = minCount;
        this.minPauseTimeNS = timeUnit.toNanos(minTime);
        this.maxPauseTimeNS = timeUnit.toNanos(maxTime);
        this.pauseTimeNS = this.minPauseTimeNS;
    }

    @Override
    public void reset() {
        this.checkYieldTime();
        this.pauseTimeNS = this.minPauseTimeNS;
        this.count = 0;
        this.timeOutStart = Long.MAX_VALUE;
    }

    @Override
    public void pause() {
        ++this.count;
        if (this.count < this.minBusy) {
            Jvm.safepoint();
            return;
        }
        this.checkYieldTime();
        if (this.count <= this.minBusy + this.minCount) {
            this.yield();
            return;
        }
        if (SHOW_PAUSES != null) {
            this.showPauses();
        }
        this.doPause(this.pauseTimeNS);
        this.pauseTimeNS = Math.min(this.maxPauseTimeNS, this.pauseTimeNS + (this.pauseTimeNS >> 6) + 20000L);
    }

    private void showPauses() {
        String name = Thread.currentThread().getName();
        if (name.startsWith(SHOW_PAUSES)) {
            System.out.println(name + " p" + this.pauseTimeNS / 1000L);
        }
    }

    @Override
    public void pause(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        ++this.count;
        if (this.count < this.minBusy) {
            return;
        }
        if (this.count <= this.minBusy + this.minCount) {
            this.yield();
            return;
        }
        if (this.timeOutStart == Long.MAX_VALUE) {
            this.timeOutStart = System.nanoTime();
        } else if (this.timeOutStart + timeUnit.toNanos(timeout) < System.nanoTime()) {
            throw new TimeoutException();
        }
        this.checkYieldTime();
        this.doPause(this.pauseTimeNS);
        this.pauseTimeNS = Math.min(this.maxPauseTimeNS, this.pauseTimeNS + (this.pauseTimeNS >> 7) + 10000L);
    }

    private void checkYieldTime() {
        if (this.yieldStart > 0L) {
            long time = System.nanoTime() - this.yieldStart;
            this.timePaused += time;
            ++this.countPaused;
            this.yieldStart = 0L;
        }
    }

    private void yield() {
        if (this.yieldStart == 0L) {
            this.yieldStart = System.nanoTime();
        }
        Thread.yield();
    }

    void doPause(long delayNs) {
        long start = System.nanoTime();
        this.thread = Thread.currentThread();
        this.pausing.set(true);
        LockSupport.parkNanos(delayNs);
        this.pausing.set(false);
        long time = System.nanoTime() - start;
        this.timePaused += time;
        ++this.countPaused;
    }

    @Override
    public void unpause() {
        Thread thread = this.thread;
        if (thread != null && this.pausing.get()) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public long timePaused() {
        return this.timePaused / 1000000L;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }
}

