/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.reflect.Method;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.Primitives;
import net.openhft.chronicle.values.ScalarFieldModel;

abstract class PrimitiveFieldModel
extends ScalarFieldModel {
    PrimitiveFieldModel() {
    }

    @Override
    void addTypeInfo(Method m3, MethodTemplate template) {
        super.addTypeInfo(m3, template);
        this.addVolatileInfo(template);
    }

    void addVolatileInfo(MethodTemplate template) {
        String regex = template.regex;
        if ((regex.contains("Volatile") || regex.contains("Ordered") || regex.contains("Atomic") || regex.contains("compareAndSwap")) && !this.alignmentSpecifiedExplicitly) {
            this.offsetAlignment = -1;
        }
    }

    int sizeInBitsConsideringVolatileOrOrderedPuts(int rawSizeInBits) {
        int minBits = this.setOrdered != null ? 32 : 8;
        return this.setVolatile != null || this.setOrdered != null ? Maths.nextPower2(rawSizeInBits, minBits) : rawSizeInBits;
    }

    @Override
    int sizeInBits() {
        return this.sizeInBitsConsideringVolatileOrOrderedPuts(Primitives.widthInBits(this.type));
    }

    @Override
    int offsetAlignmentInBytes() {
        return this.offsetAlignment != -1 ? this.offsetAlignment : 1;
    }

    @Override
    int dontCrossAlignmentInBytes() {
        if (this.dontCrossAlignment == -1) {
            return Maths.nextPower2(this.sizeInBits(), 8) / 8;
        }
        return this.dontCrossAlignment;
    }
}

