/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.Nullable;

public class BinaryReadDocumentContext
implements ReadDocumentContext {
    private final boolean ensureFullRead;
    public long start = -1L;
    public long lastStart = -1L;
    @Nullable
    protected AbstractWire wire;
    protected boolean present;
    protected boolean notComplete;
    protected long readPosition;
    protected long readLimit;
    private boolean metaData;

    public BinaryReadDocumentContext(@Nullable Wire wire) {
        this(wire, wire != null && wire.getValueIn() instanceof BinaryWire.DeltaValueIn);
    }

    public BinaryReadDocumentContext(@Nullable Wire wire, boolean ensureFullRead) {
        this.wire = (AbstractWire)wire;
        this.ensureFullRead = ensureFullRead;
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void metaData(boolean metaData) {
        this.metaData = metaData;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void closeReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    @Override
    public void closeReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    @Override
    @Nullable
    public Wire wire() {
        return this.wire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        long readLimit = this.readLimit;
        long readPosition = this.readPosition;
        AbstractWire wire0 = this.wire;
        if (this.ensureFullRead && wire0 != null && wire0.hasMore()) {
            long readPosition1 = wire0.bytes().readPosition();
            try {
                wire0.bytes().readPosition(this.start);
                wire0.bytes().readSkip(4L);
                while (wire0.hasMore()) {
                    long remaining = wire0.bytes().readRemaining();
                    ValueIn read = wire0.read();
                    if (read.isTyped()) {
                        read.skipValue();
                    } else {
                        read.text(Wires.acquireStringBuilder());
                    }
                    if (wire0.bytes().readRemaining() != remaining) continue;
                    break;
                }
            }
            catch (Exception e) {
                Jvm.debug().on(this.getClass(), e);
            }
            finally {
                wire0.bytes().readPosition(readPosition1);
            }
        }
        this.start = -1L;
        if (readLimit > 0L && wire0 != null) {
            Bytes<?> bytes = wire0.bytes();
            bytes.readLimit(readLimit);
            bytes.readPosition(readPosition);
        }
        this.present = false;
    }

    @Override
    public void start() {
        this.wire.getValueOut().resetBetweenDocuments();
        this.readLimit = -1L;
        this.readPosition = -1L;
        Bytes<?> bytes = this.wire.bytes();
        this.setStart(bytes.readPosition());
        this.present = false;
        if (bytes.readRemaining() < 4L) {
            this.notComplete = false;
            return;
        }
        long position = bytes.readPosition();
        int header = bytes.readVolatileInt(position);
        this.notComplete = Wires.isNotComplete(header);
        if (header == 0 || this.wire.notCompleteIsNotPresent() && this.notComplete) {
            return;
        }
        bytes.readSkip(4L);
        int len = Wires.lengthOf(header);
        if ((long)len > bytes.readRemaining()) {
            bytes.readSkip(-4L);
            return;
        }
        this.metaData = Wires.isReadyMetaData(header);
        this.readLimit = bytes.readLimit();
        this.readPosition = bytes.readPosition() + (long)len;
        bytes.readLimit(this.readPosition);
        this.present = true;
    }

    @Override
    public long index() {
        return 0L;
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return this.notComplete;
    }

    public void setStart(long start) {
        this.start = start;
        this.lastStart = start;
    }

    public String toString() {
        return Wires.fromSizePrefixedBlobs(this);
    }
}

