/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;

public class CharSequenceObjectMap<T> {
    private static final int K0 = 1829709757;
    private static final int M0 = 1539836845;
    final String[] keys;
    final T[] values;
    final int mask;

    public CharSequenceObjectMap(int capacity) {
        int nextPower2 = Maths.nextPower2(capacity, 16);
        this.keys = new String[nextPower2];
        this.values = new Object[nextPower2];
        this.mask = nextPower2 - 1;
    }

    public void put(CharSequence name, T t) {
        int h2 = this.hashFor(name);
        for (int i = 0; i < this.mask; ++i) {
            if (this.keys[i] == null || StringUtils.isEqual(this.keys[i], name)) {
                this.keys[i] = name.toString();
                this.values[i] = t;
                return;
            }
            h2 = h2 + 1 & this.mask;
        }
        throw new IllegalStateException("Map is full");
    }

    public T get(CharSequence cs) {
        int h2 = this.hashFor(cs);
        for (int i = 0; i < this.mask; ++i) {
            if (this.keys[i] == null) {
                return null;
            }
            if (StringUtils.isEqual(this.keys[i], cs)) {
                return this.values[i];
            }
            h2 = h2 + 1 & this.mask;
        }
        throw new IllegalStateException("Map is full");
    }

    private int hashFor(CharSequence name) {
        long h2 = name.length();
        for (int i = 0; i < name.length(); ++i) {
            h2 = h2 * 1829709757L + (long)name.charAt(i);
        }
        return (int)Maths.agitate(h2) & this.mask;
    }
}

