/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.ops4j.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipExploder {
    protected boolean verbose;
    protected boolean sortNames;

    public ZipExploder() {
        this(false);
    }

    public ZipExploder(boolean verbose) {
        this.setVerbose(verbose);
    }

    public ZipExploder(boolean verbose, boolean sorted) {
        this(verbose);
        this.setSortNames(sorted);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean f) {
        this.verbose = f;
    }

    public boolean getSortNames() {
        return this.sortNames;
    }

    public void setSortNames(boolean sortNames) {
        this.sortNames = sortNames;
    }

    public void process(String[] zipNames, String[] jarNames, String destDir) throws IOException {
        this.processZips(zipNames, destDir);
        this.processJars(jarNames, destDir);
    }

    public void processJars(String[] jarNames, String destDir) throws IOException {
        for (int i = 0; i < jarNames.length; ++i) {
            this.processFile(jarNames[i], destDir);
        }
    }

    public void processZips(String[] zipNames, String destDir) throws IOException {
        for (int i = 0; i < zipNames.length; ++i) {
            this.processFile(zipNames[i], destDir);
        }
    }

    public void processFile(String zipName, String destDir) throws IOException {
        String source = new File(zipName).getCanonicalPath();
        String dest = new File(destDir).getCanonicalPath();
        ZipFile f = null;
        try {
            f = new ZipFile(source);
            Map<String, ZipEntry> fEntries = this.getEntries(f);
            Object[] names = fEntries.keySet().toArray(new String[0]);
            if (this.sortNames) {
                Arrays.sort(names);
            }
            for (int i = 0; i < names.length; ++i) {
                Object name = names[i];
                ZipEntry e = fEntries.get(name);
                this.copyFileEntry(dest, f, e);
            }
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (msg.indexOf(zipName) < 0) {
                msg = msg + " - " + zipName;
            }
            throw new IOException(msg);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected Map<String, ZipEntry> getEntries(ZipFile zf) {
        Enumeration<? extends ZipEntry> e = zf.entries();
        HashMap<String, ZipEntry> m3 = new HashMap<String, ZipEntry>();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            m3.put(ze.getName(), ze);
        }
        return m3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileEntry(String destDir, ZipFile zf, ZipEntry ze) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(zf.getInputStream(ze)));
        try {
            this.copyFileEntry(destDir, ze.isDirectory(), ze.getName(), dis);
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFileEntry(String destDir, boolean destIsDir, String destFile, DataInputStream dis) throws IOException {
        File dir;
        byte[] bytes = this.readAllBytes(dis);
        File file = new File(destFile);
        String parent = file.getParent();
        if (parent != null && parent.length() > 0 && (dir = new File(destDir, parent)) != null) {
            dir.mkdirs();
        }
        File outFile = new File(destDir, destFile);
        if (destIsDir) {
            outFile.mkdir();
        } else {
            FileOutputStream fos = new FileOutputStream(outFile);
            try {
                fos.write(bytes, 0, bytes.length);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected byte[] readAllBytes(DataInputStream is) throws IOException {
        byte[] bytes = new byte[]{};
        int len = is.available();
        while (len > 0) {
            byte[] xbytes = new byte[len];
            int count = is.read(xbytes);
            if (count > 0) {
                byte[] nbytes = new byte[bytes.length + count];
                System.arraycopy(bytes, 0, nbytes, 0, bytes.length);
                System.arraycopy(xbytes, 0, nbytes, bytes.length, count);
                bytes = nbytes;
            } else if (count < 0) break;
            len = is.available();
        }
        return bytes;
    }

    protected void print(String s2) {
        System.out.print(s2);
    }

    protected static void printHelp() {
        System.out.println();
        System.out.println("Usage: java " + ZipExploder.class.getName() + " (-jar jarFilename... | -zip zipFilename...)... -dir destDir {-verbose}");
        System.out.println("Where:");
        System.out.println("  jarFilename path to source jar, may repeat");
        System.out.println("  zipFilename path to source zip, may repeat");
        System.out.println("  destDir    path to target directory; should exist");
        System.out.println("Note: one -jar or -zip is required; switch case or order is not important");
    }

    protected static void reportError(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ZipExploder.printHelp();
            System.exit(0);
        }
        ArrayList<String> zipNames = new ArrayList<String>();
        ArrayList<String> jarNames = new ArrayList<String>();
        String destDir = null;
        boolean jarActive = false;
        boolean zipActive = false;
        boolean destDirActive = false;
        boolean verbose = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if ((arg = arg.substring(1)).equalsIgnoreCase("jar")) {
                    jarActive = true;
                    zipActive = false;
                    destDirActive = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("zip")) {
                    zipActive = true;
                    jarActive = false;
                    destDirActive = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("dir")) {
                    jarActive = false;
                    zipActive = false;
                    destDirActive = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("verbose")) {
                    verbose = true;
                    continue;
                }
                ZipExploder.reportError("Invalid switch - " + arg);
                continue;
            }
            if (jarActive) {
                jarNames.add(arg);
                continue;
            }
            if (zipActive) {
                zipNames.add(arg);
                continue;
            }
            if (destDirActive) {
                if (destDir != null) {
                    ZipExploder.reportError("duplicate argument - -destDir");
                }
                destDir = arg;
                continue;
            }
            ZipExploder.reportError("Too many parameters - " + arg);
        }
        if (destDir == null || zipNames.size() + jarNames.size() == 0) {
            ZipExploder.reportError("Missing parameters");
        }
        if (verbose) {
            System.out.println("Effective command: " + ZipExploder.class.getName() + " " + (jarNames.size() > 0 ? "-jars " + jarNames + " " : "") + (zipNames.size() > 0 ? "-zips " + zipNames + " " : "") + "-dir " + destDir);
        }
        try {
            ZipExploder ze = new ZipExploder(verbose);
            ze.process(zipNames.toArray(new String[zipNames.size()]), jarNames.toArray(new String[jarNames.size()]), destDir);
        }
        catch (IOException ioe) {
            System.err.println("Exception - " + ioe.getMessage());
            ioe.printStackTrace();
            System.exit(2);
        }
    }
}

