/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.catalog.tracker.CatalogExt;

public class CatalogTracker {
    private static final Logger logger = LoggerFactory.getLogger(CatalogTracker.class);
    private static final String dbname = "/catTracker.dat";
    private final String filepath;
    private final int expectedSize;
    private long nextCatId;
    private Map<String, CatalogExt> catalogs;
    private boolean changed;

    public CatalogTracker(String pathname, boolean startOver, int expectedSize, long nextCatId) {
        this.filepath = pathname + dbname;
        this.expectedSize = expectedSize > 0 ? expectedSize : 100;
        this.nextCatId = nextCatId;
        File file = new File(this.filepath);
        if (startOver) {
            this.reinit();
        }
        if (!file.exists() || startOver || this.readCatalogs() <= 0) {
            this.changed = true;
            this.catalogs = new HashMap<String, CatalogExt>(2 * expectedSize);
        }
    }

    private void reinit() {
        boolean wasDeleted;
        File file = new File(this.filepath);
        if (file.exists() && !(wasDeleted = file.delete())) {
            throw new IllegalStateException("DatasetTrackerMapDB not able to delete " + this.filepath);
        }
        this.changed = true;
        this.catalogs = new HashMap<String, CatalogExt>(2 * this.expectedSize);
    }

    public long put(CatalogExt cat) {
        this.changed = true;
        if (cat.setCatId(this.nextCatId)) {
            ++this.nextCatId;
        }
        this.catalogs.put(cat.getCatRelLocation(), cat);
        return cat.getCatId();
    }

    public CatalogExt get(String path) {
        return this.catalogs.get(path);
    }

    public CatalogExt removeCatalog(String catPath) {
        this.changed = true;
        return this.catalogs.remove(catPath);
    }

    public Iterable<? extends CatalogExt> getCatalogs() {
        if (this.catalogs == null) {
            this.readCatalogs();
        }
        ArrayList<CatalogExt> result = new ArrayList<CatalogExt>();
        for (CatalogExt ext : this.catalogs.values()) {
            result.add(ext);
        }
        Collections.sort(result, (o1, o2) -> o1.getCatRelLocation().compareTo(o2.getCatRelLocation()));
        return result;
    }

    private int readCatalogs() {
        this.catalogs = new HashMap<String, CatalogExt>();
        int count = 0;
        try (DataInputStream in = new DataInputStream(new FileInputStream(this.filepath));){
            while (in.available() > 0) {
                CatalogExt ext = new CatalogExt();
                ext.readExternal(in);
                this.catalogs.put(ext.getCatRelLocation(), ext);
                ++count;
            }
        }
        catch (IOException e) {
            logger.error("read " + this.filepath, e);
            return 0;
        }
        return count;
    }

    public void save() throws IOException {
        if (!this.changed) {
            return;
        }
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.filepath));){
            for (CatalogExt ext : this.catalogs.values()) {
                ext.writeExternal(out);
            }
        }
        this.changed = false;
    }

    public int size() {
        return this.catalogs.size();
    }

    public long getNextCatId() {
        return this.nextCatId;
    }
}

