/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.TimeUnitConverter;
import ucar.nc2.grib.GribLevelType;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.CfsrLocalTables;
import ucar.nc2.grib.grib2.table.FslLocalTables;
import ucar.nc2.grib.grib2.table.GempakLocalTables;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.KmaLocalTables;
import ucar.nc2.grib.grib2.table.MrmsLocalTables;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.grib.grib2.table.NdfdLocalTables;
import ucar.nc2.grib.grib2.table.NwsMetDevTables;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.wmo.CommonCodeTable;

@Immutable
public class Grib2Customizer
implements GribTables,
TimeUnitConverter {
    private static final Logger log = LoggerFactory.getLogger(Grib2Customizer.class);
    private static Map<Grib2Table.Id, Grib2Customizer> tables = new HashMap<Grib2Table.Id, Grib2Customizer>();
    private static Grib2Customizer wmoStandardTable = null;
    protected final Grib2Table grib2Table;
    private boolean timeUnitWarnWasSent;
    private TimeUnitConverter timeUnitConverter;

    public static Grib2Customizer factory(Grib2Record gr) throws IOException {
        Grib2SectionIdentification ids = gr.getId();
        Grib2Pds pds = gr.getPDS();
        return Grib2Customizer.factory(ids.getCenter_id(), ids.getSubcenter_id(), ids.getMaster_table_version(), ids.getLocal_table_version(), pds.getGenProcessId());
    }

    public static Grib2Customizer factory(int center, int subCenter, int masterVersion, int localVersion, int genProcessId) {
        Grib2Table.Id id = new Grib2Table.Id(center, subCenter, masterVersion, localVersion, genProcessId);
        Grib2Customizer cust = tables.get(id);
        if (cust != null) {
            return cust;
        }
        Grib2Table table = Grib2Table.getTable(id);
        cust = Grib2Customizer.factory(table);
        tables.put(id, cust);
        return cust;
    }

    public static Grib2Customizer factory(Grib2Table grib2Table) {
        switch (grib2Table.type) {
            case cfsr: {
                return CfsrLocalTables.getCust(grib2Table);
            }
            case gempak: {
                return GempakLocalTables.getCust(grib2Table);
            }
            case gsd: {
                return FslLocalTables.getCust(grib2Table);
            }
            case kma: {
                return KmaLocalTables.getCust(grib2Table);
            }
            case ncep: {
                return NcepLocalTables.getCust(grib2Table);
            }
            case ndfd: {
                return NdfdLocalTables.getCust(grib2Table);
            }
            case mrms: {
                return MrmsLocalTables.getCust(grib2Table);
            }
            case nwsDev: {
                return NwsMetDevTables.getCust(grib2Table);
            }
        }
        if (wmoStandardTable == null) {
            wmoStandardTable = new Grib2Customizer(grib2Table);
        }
        return wmoStandardTable;
    }

    public static int makeParamId(int discipline, int category, int number) {
        return (discipline << 16) + (category << 8) + number;
    }

    public static boolean isLocal(GribTables.Parameter p) {
        return p.getCategory() > 191 || p.getNumber() > 191;
    }

    protected Grib2Customizer(Grib2Table grib2Table) {
        this.grib2Table = grib2Table;
    }

    public String getVariableName(Grib2Record gr) {
        return this.getVariableName(gr.getDiscipline(), gr.getPDS().getParameterCategory(), gr.getPDS().getParameterNumber());
    }

    public String getVariableName(int discipline, int category, int parameter) {
        String s2 = WmoCodeTable.getParameterName(discipline, category, parameter);
        if (s2 == null) {
            s2 = "U" + discipline + "-" + category + "-" + parameter;
        }
        return s2;
    }

    public String getTableValue(String tableName, int code) {
        return WmoCodeTable.getTableValue(tableName, code);
    }

    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        return WmoCodeTable.getParameterEntry(discipline, category, number);
    }

    @Override
    public String getSubCenterName(int center_id, int subcenter_id) {
        return CommonCodeTable.getSubCenterName(center_id, subcenter_id);
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        return null;
    }

    @Override
    public String getGeneratingProcessTypeName(int genProcess) {
        return this.getTableValue("4.3", genProcess);
    }

    public String getCategory(int discipline, int category) {
        return this.getTableValue("4.1." + discipline, category);
    }

    public void setTimeUnitConverter(TimeUnitConverter timeUnitConverter) {
        if (this.timeUnitConverter != null) {
            throw new RuntimeException("Cant modify timeUnitConverter once its been set");
        }
        this.timeUnitConverter = timeUnitConverter;
    }

    @Override
    public int convertTimeUnit(int timeUnit) {
        if (this.timeUnitConverter == null) {
            return timeUnit;
        }
        return this.timeUnitConverter.convertTimeUnit(timeUnit);
    }

    public CalendarDate getForecastDate(Grib2Record gr) {
        Grib2Pds pds = gr.getPDS();
        if (pds.isTimeInterval()) {
            TimeCoord.TinvDate intv = this.getForecastTimeInterval(gr);
            return intv == null ? null : intv.getEnd();
        }
        int val = pds.getForecastTime();
        CalendarPeriod period = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(pds.getTimeUnit()));
        if (period == null) {
            return null;
        }
        return gr.getReferenceDate().add(period.multiply(val));
    }

    public TimeCoord.TinvDate getForecastTimeInterval(Grib2Record gr) {
        if (!gr.getPDS().isTimeInterval()) {
            return null;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)gr.getPDS());
        int timeUnitOrg = gr.getPDS().getTimeUnit();
        int range = 0;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit == 255) continue;
            if ((ti.timeRangeUnit != timeUnitOrg || ti.timeIncrementUnit != timeUnitOrg && ti.timeIncrementUnit != 255 && ti.timeIncrement != 0) && !this.timeUnitWarnWasSent) {
                log.warn("TimeInterval has different units timeUnit org=" + timeUnitOrg + " TimeInterval=" + ti.timeIncrementUnit);
                this.timeUnitWarnWasSent = true;
            }
            range += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            range += ti.timeIncrement;
        }
        CalendarPeriod unitPeriod = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(timeUnitOrg));
        if (unitPeriod == null) {
            return null;
        }
        CalendarPeriod period = unitPeriod.multiply(range);
        CalendarDate EI = pdsIntv.getIntervalTimeEnd();
        if (EI == null) {
            return new TimeCoord.TinvDate(gr.getReferenceDate(), period);
        }
        return new TimeCoord.TinvDate(period, EI);
    }

    public double getForecastTimeIntervalSizeInHours(Grib2Pds pds) {
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)pds);
        int timeUnitOrg = pds.getTimeUnit();
        int range = 0;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit == 255) continue;
            if (ti.timeRangeUnit != timeUnitOrg || ti.timeIncrementUnit != timeUnitOrg && ti.timeIncrementUnit != 255 && ti.timeIncrement != 0) {
                log.warn("TimeInterval(2) has different units timeUnit org=" + timeUnitOrg + " TimeInterval=" + ti.timeIncrementUnit);
                throw new RuntimeException("TimeInterval(2) has different units");
            }
            range += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            range += ti.timeIncrement;
        }
        CalendarPeriod timeUnitPeriod = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(timeUnitOrg));
        if (timeUnitPeriod == null) {
            return -9999.0;
        }
        if (timeUnitPeriod.equals(CalendarPeriod.Hour)) {
            return range;
        }
        double fac = timeUnitPeriod.getField() == CalendarPeriod.Field.Month ? 720.0 : (timeUnitPeriod.getField() == CalendarPeriod.Field.Year ? 8760.0 : CalendarPeriod.Hour.getConvertFactor(timeUnitPeriod));
        return fac * (double)range;
    }

    public int[] getForecastTimeIntervalOffset(Grib2Record gr) {
        TimeCoord.TinvDate tinvd = this.getForecastTimeInterval(gr);
        if (tinvd == null) {
            return null;
        }
        Grib2Pds pds = gr.getPDS();
        int unit = this.convertTimeUnit(pds.getTimeUnit());
        TimeCoord.Tinv tinv = tinvd.convertReferenceDate(gr.getReferenceDate(), Grib2Utils.getCalendarPeriod(unit));
        int[] result = new int[]{tinv.getBounds1(), tinv.getBounds2()};
        return result;
    }

    public String getStatisticName(int id) {
        return this.getTableValue("4.10", id);
    }

    public String getStatisticNameShort(int id) {
        GribStatType stat = GribStatType.getStatTypeFromGrib2(id);
        return stat == null ? "UnknownStatType-" + id : stat.toString();
    }

    @Override
    public GribStatType getStatType(int grib2StatCode) {
        return GribStatType.getStatTypeFromGrib2(grib2StatCode);
    }

    public String getProbabilityNameShort(int id) {
        switch (id) {
            case 0: {
                return "unweightedMean";
            }
            case 1: {
                return "weightedMean";
            }
            case 2: {
                return "stdDev";
            }
            case 3: {
                return "stdDevNormalized";
            }
            case 4: {
                return "spread";
            }
            case 5: {
                return "largeAnomalyIndex";
            }
            case 6: {
                return "unweightedMeanCluster";
            }
            case 7: {
                return "interquartileRange";
            }
            case 8: {
                return "minimumEnsemble";
            }
            case 9: {
                return "maximumEnsemble";
            }
        }
        return "UnknownProbType" + id;
    }

    @Override
    public VertCoord.VertUnit getVertUnit(int code) {
        switch (code) {
            case 11: 
            case 12: {
                return new GribLevelType(code, "m", null, true);
            }
            case 20: {
                return new GribLevelType(code, "K", null, false);
            }
            case 100: {
                return new GribLevelType(code, "Pa", null, false);
            }
            case 102: {
                return new GribLevelType(code, "m", "mean sea level", true);
            }
            case 103: {
                return new GribLevelType(code, "m", "ground", true);
            }
            case 104: 
            case 105: {
                return new GribLevelType(code, "sigma", null, false);
            }
            case 106: {
                return new GribLevelType(code, "m", "land surface", false);
            }
            case 107: {
                return new GribLevelType(code, "K", null, true);
            }
            case 108: {
                return new GribLevelType(code, "Pa", "ground", true);
            }
            case 109: {
                return new GribLevelType(code, "K m2 kg-1 s-1", null, true);
            }
            case 114: {
                return new GribLevelType(code, "numeric", null, false);
            }
            case 117: {
                return new GribLevelType(code, "m", null, true);
            }
            case 119: {
                return new GribLevelType(code, "Pa", null, false);
            }
            case 160: {
                return new GribLevelType(code, "m", "sea level", false);
            }
            case 161: {
                return new GribLevelType(code, "m", "water surface", false);
            }
            case 235: {
                return new GribLevelType(code, "0.1 C", null, true);
            }
            case 237: {
                return new GribLevelType(code, "m", null, true);
            }
            case 238: {
                return new GribLevelType(code, "m", null, true);
            }
        }
        return new GribLevelType(code, null, null, true);
    }

    public boolean isLevelUsed(int code) {
        VertCoord.VertUnit vunit = this.getVertUnit(code);
        return vunit.isVerticalCoordinate();
    }

    public String getLevelName(int id) {
        return this.getTableValue("4.5", id);
    }

    public boolean isLayer(Grib2Pds pds) {
        return pds.getLevelType2() != 255 && pds.getLevelType2() != 0;
    }

    @Override
    public String getLevelNameShort(int id) {
        switch (id) {
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud_base";
            }
            case 3: {
                return "cloud_tops";
            }
            case 4: {
                return "zeroDegC_isotherm";
            }
            case 5: {
                return "adiabatic_condensation_lifted";
            }
            case 6: {
                return "maximum_wind";
            }
            case 7: {
                return "tropopause";
            }
            case 8: {
                return "atmosphere_top";
            }
            case 9: {
                return "sea_bottom";
            }
            case 10: {
                return "entire_atmosphere";
            }
            case 11: {
                return "cumulonimbus_base";
            }
            case 12: {
                return "cumulonimbus_top";
            }
            case 20: {
                return "isotherm";
            }
            case 100: {
                return "isobaric";
            }
            case 101: {
                return "msl";
            }
            case 102: {
                return "altitude_above_msl";
            }
            case 103: {
                return "height_above_ground";
            }
            case 104: {
                return "sigma";
            }
            case 105: {
                return "hybrid";
            }
            case 106: {
                return "depth_below_surface";
            }
            case 107: {
                return "isentrope";
            }
            case 108: {
                return "pressure_difference";
            }
            case 109: {
                return "potential_vorticity_surface";
            }
            case 111: {
                return "eta";
            }
            case 113: {
                return "log_hybrid";
            }
            case 117: {
                return "mixed_layer_depth";
            }
            case 118: {
                return "hybrid_height";
            }
            case 119: {
                return "hybrid_pressure";
            }
            case 120: {
                return "pressure_thickness";
            }
            case 160: {
                return "depth_below_sea";
            }
            case -9999: {
                return "none";
            }
        }
        return "UnknownLevelType-" + id;
    }

    public GribTables.Parameter getParameterRaw(int discipline, int category, int number) {
        return WmoCodeTable.getParameterEntry(discipline, category, number);
    }

    public String getTablePath(int discipline, int category, int number) {
        return WmoCodeTable.standard.getResourceName();
    }

    public List<GribTables.Parameter> getParameters() {
        ArrayList<GribTables.Parameter> allParams = new ArrayList<GribTables.Parameter>(3000);
        try {
            WmoCodeTable.WmoTables wmo = WmoCodeTable.getWmoStandard();
            for (String key : wmo.map.keySet()) {
                if (!key.startsWith("4.2.")) continue;
                WmoCodeTable params = wmo.map.get(key);
                allParams.addAll(params.entries);
            }
        }
        catch (IOException e) {
            System.out.printf("Error reading wmo tables = %s%n", e.getMessage());
        }
        return allParams;
    }

    public void lookForProblems(Formatter f) {
    }

    public void showSpecialPdsInfo(Grib2Record pds, Formatter f) {
    }
}

