/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.util.TreeMap;
import java.util.WeakHashMap;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChronicleHashCloseOnExitHook {
    private static final Logger LOG = LoggerFactory.getLogger(ChronicleHashCloseOnExitHook.class);
    private static WeakHashMap<VanillaChronicleHash.Identity, Long> maps = new WeakHashMap();
    private static long order = 0L;

    private ChronicleHashCloseOnExitHook() {
    }

    static synchronized void add(VanillaChronicleHash hash) {
        if (maps == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        maps.put(hash.identity, order++);
    }

    static synchronized void remove(VanillaChronicleHash hash) {
        if (maps == null) {
            return;
        }
        maps.remove(hash.identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeAll() {
        try {
            Class<ChronicleHashCloseOnExitHook> clazz = ChronicleHashCloseOnExitHook.class;
            synchronized (ChronicleHashCloseOnExitHook.class) {
                WeakHashMap<VanillaChronicleHash.Identity, Long> maps = ChronicleHashCloseOnExitHook.maps;
                ChronicleHashCloseOnExitHook.maps = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                TreeMap orderedMaps = new TreeMap();
                maps.forEach((identity, order) -> orderedMaps.put(order, identity.hash()));
                orderedMaps.descendingMap().values().forEach(h2 -> {
                    try {
                        h2.close();
                    }
                    catch (Throwable throwable) {
                        try {
                            LOG.error("Error while closing " + h2.toIdentityString() + " during shutdown hook:", throwable);
                        }
                        catch (Throwable t2) {
                            throwable.addSuppressed(t2);
                            throwable.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            try {
                LOG.error("Error while closing maps during shutdown hook:", throwable);
            }
            catch (Throwable t2) {
                throwable.addSuppressed(t2);
                throwable.printStackTrace();
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(ChronicleHashCloseOnExitHook::closeAll));
    }
}

