/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.impl.DefaultElasticBytes;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

abstract class AbstractCharSequenceUtf8DataAccess<T extends CharSequence>
extends AbstractData<T>
implements DataAccess<T>,
Data<T> {
    transient T cs;
    private transient Bytes bytes;

    AbstractCharSequenceUtf8DataAccess(long bytesCapacity) {
        this.initTransients(bytesCapacity);
    }

    private void initTransients(long bytesCapacity) {
        this.bytes = DefaultElasticBytes.allocateDefaultElasticBytes(bytesCapacity);
    }

    @Override
    public Data<T> getData(@NotNull T cs) {
        this.cs = cs;
        this.bytes.clear();
        BytesUtil.appendUtf8(this.bytes, cs);
        return this;
    }

    @Override
    public void uninit() {
        this.cs = null;
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients(32L);
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
    }

    @Override
    public RandomDataInput bytes() {
        return this.bytes.bytesStore();
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return this.bytes.readRemaining();
    }

    @Override
    public T get() {
        return this.cs;
    }
}

