/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.map.ReplicatedGlobalMutableState;
import net.openhft.chronicle.values.Copyable;

@Deprecated
public class ReplicatedGlobalMutableState$$Native
implements ReplicatedGlobalMutableState,
Copyable<ReplicatedGlobalMutableState>,
BytesMarshallable,
Byteable {
    private BytesStore bs;
    private long offset;

    @Override
    public int getAllocatedExtraTierBulks() {
        return this.bs.readInt(this.offset + 0L) & 0xFFFFFF;
    }

    @Override
    public void setAllocatedExtraTierBulks(int _allocatedExtraTierBulks) {
        if (_allocatedExtraTierBulks < 0 || _allocatedExtraTierBulks > 0xFFFFFF) {
            throw new IllegalArgumentException("_allocatedExtraTierBulks should be in [0, 16777215] range, " + _allocatedExtraTierBulks + " is given");
        }
        this.bs.writeInt(this.offset + 0L, this.bs.readInt(this.offset + 0L) & 0xFF000000 | _allocatedExtraTierBulks);
    }

    @Override
    public long getFirstFreeTierIndex() {
        return this.bs.readLong(this.offset + 3L) & 0xFFFFFFFFFFL;
    }

    @Override
    public void setFirstFreeTierIndex(long _firstFreeTierIndex) {
        if (_firstFreeTierIndex < 0L || _firstFreeTierIndex > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("_firstFreeTierIndex should be in [0, 1099511627775] range, " + _firstFreeTierIndex + " is given");
        }
        this.bs.writeLong(this.offset + 3L, this.bs.readLong(this.offset + 3L) & 0xFFFFFF0000000000L | _firstFreeTierIndex);
    }

    @Override
    public long getExtraTiersInUse() {
        return this.bs.readLong(this.offset + 8L) & 0xFFFFFFFFFFL;
    }

    @Override
    public void setExtraTiersInUse(long _extraTiersInUse) {
        if (_extraTiersInUse < 0L || _extraTiersInUse > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("_extraTiersInUse should be in [0, 1099511627775] range, " + _extraTiersInUse + " is given");
        }
        this.bs.writeLong(this.offset + 8L, this.bs.readLong(this.offset + 8L) & 0xFFFFFF0000000000L | _extraTiersInUse);
    }

    @Override
    public long getSegmentHeadersOffset() {
        return (long)this.bs.readInt(this.offset + 13L) & 0xFFFFFFFFL;
    }

    @Override
    public void setSegmentHeadersOffset(long _segmentHeadersOffset) {
        if (_segmentHeadersOffset < 0L || _segmentHeadersOffset > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("_segmentHeadersOffset should be in [0, 4294967295] range, " + _segmentHeadersOffset + " is given");
        }
        this.bs.writeInt(this.offset + 13L, (int)_segmentHeadersOffset);
    }

    @Override
    public long getDataStoreSize() {
        return this.bs.readLong(this.offset + 17L);
    }

    @Override
    public void setDataStoreSize(long _dataStoreSize) {
        if (_dataStoreSize < 0L) {
            throw new IllegalArgumentException("_dataStoreSize should be in [0, 9223372036854775807] range, " + _dataStoreSize + " is given");
        }
        this.bs.writeLong(this.offset + 17L, _dataStoreSize);
    }

    @Override
    public long addDataStoreSize(long addition) {
        long oldDataStoreSize = this.bs.readLong(this.offset + 17L);
        long newDataStoreSize = oldDataStoreSize + addition;
        if (newDataStoreSize < 0L) {
            throw new IllegalStateException("bs.readLong(offset + 17) should be in [0, 9223372036854775807] range, the value was " + oldDataStoreSize + ", + " + addition + " = " + newDataStoreSize + " out of the range");
        }
        this.bs.writeLong(this.offset + 17L, newDataStoreSize);
        return newDataStoreSize;
    }

    @Override
    public int getCurrentCleanupSegmentIndex() {
        return this.bs.readInt(this.offset + 25L);
    }

    @Override
    public void setCurrentCleanupSegmentIndex(int _currentCleanupSegmentIndex) {
        if (_currentCleanupSegmentIndex < 0) {
            throw new IllegalArgumentException("_currentCleanupSegmentIndex should be in [0, 2147483647] range, " + _currentCleanupSegmentIndex + " is given");
        }
        this.bs.writeInt(this.offset + 25L, _currentCleanupSegmentIndex);
    }

    @Override
    public int getModificationIteratorsCount() {
        return this.bs.readByte(this.offset + 29L) & 0xFF;
    }

    @Override
    public int addModificationIteratorsCount(int addition) {
        int oldModificationIteratorsCount = this.bs.readByte(this.offset + 29L) & 0xFF;
        int newModificationIteratorsCount = oldModificationIteratorsCount + addition;
        if (newModificationIteratorsCount < 0 || newModificationIteratorsCount > 128) {
            throw new IllegalStateException("(bs.readByte(offset + 29)) & 0xFF should be in [0, 128] range, the value was " + oldModificationIteratorsCount + ", + " + addition + " = " + newModificationIteratorsCount + " out of the range");
        }
        this.bs.writeByte(this.offset + 29L, (byte)newModificationIteratorsCount);
        return newModificationIteratorsCount;
    }

    @Override
    public boolean getModificationIteratorInitAt(int index) {
        if (index < 0 || index >= 128) {
            throw new ArrayIndexOutOfBoundsException(index + " is out of bounds, array length 128");
        }
        int bitOffset = 240 + index;
        int byteOffset = bitOffset / 8;
        int bitShift = bitOffset & 7;
        return (this.bs.readByte(this.offset + (long)byteOffset) & 1 << bitShift) != 0;
    }

    @Override
    public void setModificationIteratorInitAt(int index, boolean _modificationIteratorInit) {
        if (index < 0 || index >= 128) {
            throw new ArrayIndexOutOfBoundsException(index + " is out of bounds, array length 128");
        }
        int bitOffset = 240 + index;
        int byteOffset = bitOffset / 8;
        int bitShift = bitOffset & 7;
        int b = this.bs.readByte(this.offset + (long)byteOffset);
        b = _modificationIteratorInit ? (b |= 1 << bitShift) : (b &= ~(1 << bitShift));
        this.bs.writeByte(this.offset + (long)byteOffset, (byte)b);
    }

    @Override
    public void copyFrom(ReplicatedGlobalMutableState from) {
        this.setAllocatedExtraTierBulks(from.getAllocatedExtraTierBulks());
        this.setFirstFreeTierIndex(from.getFirstFreeTierIndex());
        this.setExtraTiersInUse(from.getExtraTiersInUse());
        this.setSegmentHeadersOffset(from.getSegmentHeadersOffset());
        this.setDataStoreSize(from.getDataStoreSize());
        this.setCurrentCleanupSegmentIndex(from.getCurrentCleanupSegmentIndex());
        int _modificationIteratorsCount = from.getModificationIteratorsCount();
        if (_modificationIteratorsCount < 0 || _modificationIteratorsCount > 128) {
            throw new IllegalArgumentException("_modificationIteratorsCount should be in [0, 128] range, " + _modificationIteratorsCount + " is given");
        }
        this.bs.writeByte(this.offset + 29L, (byte)_modificationIteratorsCount);
        for (int index = 0; index < 128; ++index) {
            this.setModificationIteratorInitAt(index, from.getModificationIteratorInitAt(index));
        }
    }

    @Override
    public void writeMarshallable(BytesOut bytes) {
        bytes.writeInt(this.bs.readInt(this.offset + 0L) & 0xFFFFFF);
        bytes.writeLong(this.bs.readLong(this.offset + 3L) & 0xFFFFFFFFFFL);
        bytes.writeLong(this.bs.readLong(this.offset + 8L) & 0xFFFFFFFFFFL);
        bytes.writeLong((long)this.bs.readInt(this.offset + 13L) & 0xFFFFFFFFL);
        bytes.writeLong(this.bs.readLong(this.offset + 17L));
        bytes.writeInt(this.bs.readInt(this.offset + 25L));
        bytes.writeInt(this.bs.readByte(this.offset + 29L) & 0xFF);
        for (int index = 0; index < 128; ++index) {
            bytes.writeBoolean(this.getModificationIteratorInitAt(index));
        }
    }

    @Override
    public void readMarshallable(BytesIn bytes) {
        this.bs.writeInt(this.offset + 0L, this.bs.readInt(this.offset + 0L) & 0xFF000000 | bytes.readInt());
        this.bs.writeLong(this.offset + 3L, this.bs.readLong(this.offset + 3L) & 0xFFFFFF0000000000L | bytes.readLong());
        this.bs.writeLong(this.offset + 8L, this.bs.readLong(this.offset + 8L) & 0xFFFFFF0000000000L | bytes.readLong());
        this.bs.writeInt(this.offset + 13L, (int)bytes.readLong());
        this.bs.writeLong(this.offset + 17L, bytes.readLong());
        this.bs.writeInt(this.offset + 25L, bytes.readInt());
        this.bs.writeByte(this.offset + 29L, (byte)bytes.readInt());
        for (int index = 0; index < 128; ++index) {
            this.setModificationIteratorInitAt(index, bytes.readBoolean());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReplicatedGlobalMutableState)) {
            return false;
        }
        ReplicatedGlobalMutableState other = (ReplicatedGlobalMutableState)obj;
        if (this.getAllocatedExtraTierBulks() != other.getAllocatedExtraTierBulks()) {
            return false;
        }
        if (this.getFirstFreeTierIndex() != other.getFirstFreeTierIndex()) {
            return false;
        }
        if (this.getExtraTiersInUse() != other.getExtraTiersInUse()) {
            return false;
        }
        if (this.getSegmentHeadersOffset() != other.getSegmentHeadersOffset()) {
            return false;
        }
        if (this.getDataStoreSize() != other.getDataStoreSize()) {
            return false;
        }
        if (this.getCurrentCleanupSegmentIndex() != other.getCurrentCleanupSegmentIndex()) {
            return false;
        }
        if (this.getModificationIteratorsCount() != other.getModificationIteratorsCount()) {
            return false;
        }
        for (int index = 0; index < 128; ++index) {
            if (this.getModificationIteratorInitAt(index) == other.getModificationIteratorInitAt(index)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= Integer.hashCode(this.getAllocatedExtraTierBulks());
        hashCode *= 1000003;
        hashCode ^= Long.hashCode(this.getFirstFreeTierIndex());
        hashCode *= 1000003;
        hashCode ^= Long.hashCode(this.getExtraTiersInUse());
        hashCode *= 1000003;
        hashCode ^= Long.hashCode(this.getSegmentHeadersOffset());
        hashCode *= 1000003;
        hashCode ^= Long.hashCode(this.getDataStoreSize());
        hashCode *= 1000003;
        hashCode ^= Integer.hashCode(this.getCurrentCleanupSegmentIndex());
        hashCode *= 1000003;
        hashCode ^= Integer.hashCode(this.getModificationIteratorsCount());
        hashCode *= 1000003;
        int _modificationIteratorInitHashCode = 1;
        for (int index = 0; index < 128; ++index) {
            _modificationIteratorInitHashCode *= 1000003;
            _modificationIteratorInitHashCode ^= Boolean.hashCode(this.getModificationIteratorInitAt(index));
        }
        return hashCode ^= _modificationIteratorInitHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicatedGlobalMutableState");
        sb.append(", allocatedExtraTierBulks=").append(this.getAllocatedExtraTierBulks());
        sb.append(", firstFreeTierIndex=").append(this.getFirstFreeTierIndex());
        sb.append(", extraTiersInUse=").append(this.getExtraTiersInUse());
        sb.append(", segmentHeadersOffset=").append(this.getSegmentHeadersOffset());
        sb.append(", dataStoreSize=").append(this.getDataStoreSize());
        sb.append(", currentCleanupSegmentIndex=").append(this.getCurrentCleanupSegmentIndex());
        sb.append(", modificationIteratorsCount=").append(this.getModificationIteratorsCount());
        sb.append(", modificationIteratorInit=[");
        for (int index = 0; index < 128; ++index) {
            sb.append(this.getModificationIteratorInitAt(index)).append(',').append(' ');
        }
        sb.setCharAt(sb.length() - 2, ']');
        sb.setLength(sb.length() - 1);
        sb.setCharAt(28, '{');
        sb.append(' ').append('}');
        return sb.toString();
    }

    public void bytesStore(BytesStore bytesStore, long offset, long length) {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException("Constant size is 46, given length is " + length);
        }
        this.bs = bytesStore;
        this.offset = offset;
    }

    public BytesStore bytesStore() {
        return this.bs;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return 46L;
    }
}

