/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class TextMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    static boolean ENABLE_EOD = true;
    @NotNull
    private final TextWire wire;
    private final Map<Method, Consumer<Object[]>> visitorConverter = new LinkedHashMap<Method, Consumer<Object[]>>();

    TextMethodWriterInvocationHandler(@NotNull TextWire wire) {
        this.wire = wire;
        this.recordHistory = wire.recordHistory();
    }

    @Override
    protected void handleInvoke(Method method, Object[] args) {
        this.visitorConverter.computeIfAbsent(method, this::buildConverter).accept(args);
        this.handleInvoke(method, args, this.wire);
        this.wire.getValueOut().resetBetweenDocuments();
        Bytes<?> bytes = this.wire.bytes();
        if (bytes.peekUnsignedByte(bytes.writePosition() - 1L) >= 32) {
            bytes.append('\n');
        }
        if (ENABLE_EOD) {
            bytes.append("---\n");
        }
    }

    private Consumer<Object[]> buildConverter(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (Annotation anno : parameterAnnotations[0]) {
            if (anno instanceof LongConversion) {
                LongConversion longConversion = (LongConversion)anno;
                LongConverter ic = ObjectUtils.newInstance(longConversion.value());
                return a -> {
                    if (a[0] instanceof Number) {
                        StringBuilder sb = Wires.acquireStringBuilder();
                        ic.append(sb, ((Number)a[0]).longValue());
                        a[0] = sb.toString();
                    }
                };
            }
            if (!(anno instanceof IntConversion)) continue;
            IntConversion intConversion = (IntConversion)anno;
            IntConverter ic = ObjectUtils.newInstance(intConversion.value());
            return a -> {
                if (a[0] instanceof Number) {
                    StringBuilder sb = Wires.acquireStringBuilder();
                    ic.append(sb, ((Number)a[0]).intValue());
                    a[0] = sb.toString();
                }
            };
        }
        return NoOp.INSTANCE;
    }

    static enum NoOp implements Consumer<Object[]>
    {
        INSTANCE;


        @Override
        public void accept(Object[] objects) {
        }
    }
}

