/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.artifact;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArtifact
implements Artifact {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");

    @Override
    public boolean isSnapshot() {
        return AbstractArtifact.isSnapshot(this.getVersion());
    }

    private static boolean isSnapshot(String version) {
        return version.endsWith(SNAPSHOT) || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }

    @Override
    public String getBaseVersion() {
        return AbstractArtifact.toBaseVersion(this.getVersion());
    }

    private static String toBaseVersion(String version) {
        Matcher m3;
        String baseVersion = version == null ? version : (version.startsWith("[") || version.startsWith("(") ? version : ((m3 = SNAPSHOT_TIMESTAMP.matcher(version)).matches() ? (m3.group(1) != null ? m3.group(1) + SNAPSHOT : SNAPSHOT) : version));
        return baseVersion;
    }

    private Artifact newInstance(String version, Map<String, String> properties, File file) {
        return new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), version, file, properties);
    }

    @Override
    public Artifact setVersion(String version) {
        String current = this.getVersion();
        if (current.equals(version) || version == null && current.length() <= 0) {
            return this;
        }
        return this.newInstance(version, this.getProperties(), this.getFile());
    }

    @Override
    public Artifact setFile(File file) {
        File current = this.getFile();
        if (current == null ? file == null : current.equals(file)) {
            return this;
        }
        return this.newInstance(this.getVersion(), this.getProperties(), file);
    }

    @Override
    public Artifact setProperties(Map<String, String> properties) {
        Map<String, String> current = this.getProperties();
        if (current.equals(properties) || properties == null && current.isEmpty()) {
            return this;
        }
        return this.newInstance(this.getVersion(), AbstractArtifact.copyProperties(properties), this.getFile());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperties().get(key);
        return value != null ? value : defaultValue;
    }

    protected static Map<String, String> copyProperties(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            return Collections.unmodifiableMap(new HashMap<String, String>(properties));
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.getGroupId());
        buffer.append(':').append(this.getArtifactId());
        buffer.append(':').append(this.getExtension());
        if (this.getClassifier().length() > 0) {
            buffer.append(':').append(this.getClassifier());
        }
        buffer.append(':').append(this.getVersion());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact that = (Artifact)obj;
        return this.getArtifactId().equals(that.getArtifactId()) && this.getGroupId().equals(that.getGroupId()) && this.getVersion().equals(that.getVersion()) && this.getExtension().equals(that.getExtension()) && this.getClassifier().equals(that.getClassifier()) && AbstractArtifact.eq(this.getFile(), that.getFile()) && this.getProperties().equals(that.getProperties());
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getGroupId().hashCode();
        hash = hash * 31 + this.getArtifactId().hashCode();
        hash = hash * 31 + this.getExtension().hashCode();
        hash = hash * 31 + this.getClassifier().hashCode();
        hash = hash * 31 + this.getVersion().hashCode();
        hash = hash * 31 + AbstractArtifact.hash(this.getFile());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

