/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.DoubleFunction;
import java.util.stream.DoubleStream;
import net.openhft.chronicle.core.util.NanoSampler;
import org.jetbrains.annotations.NotNull;

public class Histogram
implements NanoSampler {
    static final DecimalFormat F3 = new DecimalFormat("0.000");
    static final DecimalFormat F2 = new DecimalFormat("0.00");
    static final DecimalFormat F1 = new DecimalFormat("0.0");
    private int fractionBits;
    private int powersOf2;
    private long overRange;
    private long totalCount;
    private long floor;
    private int[] sampleCount;

    public Histogram() {
        this(42, 4);
    }

    public Histogram(int powersOf2, int fractionBits) {
        this(powersOf2, fractionBits, 1.0);
    }

    public Histogram(int powersOf2, int fractionBits, double minValue) {
        this.powersOf2 = powersOf2;
        this.fractionBits = fractionBits;
        this.sampleCount = new int[powersOf2 << fractionBits];
        this.floor = Double.doubleToRawLongBits(minValue) >> 52 - fractionBits;
    }

    @NotNull
    public static Histogram timeMicros() {
        return new Histogram(22, 3, 1000.0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Histogram)) {
            return false;
        }
        Histogram h2 = (Histogram)obj;
        if (this.powersOf2 != h2.powersOf2 || this.fractionBits != h2.fractionBits || this.floor != h2.floor) {
            return false;
        }
        int size = this.powersOf2 << this.fractionBits;
        for (int i = 0; i < size; ++i) {
            if (this.sampleCount[i] == h2.sampleCount[i]) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "Histogram{fractionBits=" + this.fractionBits + ", powersOf2=" + this.powersOf2 + ", overRange=" + this.overRange + ", totalCount=" + this.totalCount + ", floor=" + this.floor + ", sampleCount=" + Arrays.toString(this.sampleCount) + '}';
    }

    public void init(int powersOf2, int fractionBits, long overRange, long totalCount, long floor) {
        this.powersOf2 = powersOf2;
        this.fractionBits = fractionBits;
        this.overRange = overRange;
        this.totalCount = totalCount;
        this.floor = floor;
        int minSampleCountLength = powersOf2 << fractionBits;
        if (this.sampleCount.length < minSampleCountLength) {
            this.sampleCount = new int[minSampleCountLength];
        }
    }

    public int fractionBits() {
        return this.fractionBits;
    }

    public int powersOf2() {
        return this.powersOf2;
    }

    public long overRange() {
        return this.overRange;
    }

    public int[] sampleCount() {
        return this.sampleCount;
    }

    public void add(@NotNull Histogram h2) {
        assert (this.powersOf2 == h2.powersOf2);
        assert (this.fractionBits == h2.fractionBits);
        this.totalCount += h2.totalCount;
        this.overRange += h2.overRange;
        for (int i = 0; i < this.sampleCount.length; ++i) {
            int n = i;
            this.sampleCount[n] = this.sampleCount[n] + h2.sampleCount[i];
        }
    }

    public int sample(double time) {
        int bucket = (int)((Double.doubleToRawLongBits(time) >> 52 - this.fractionBits) - this.floor);
        if (bucket >= this.sampleCount.length) {
            ++this.overRange;
        } else if (bucket >= 0) {
            int n = bucket;
            this.sampleCount[n] = this.sampleCount[n] + 1;
        }
        ++this.totalCount;
        return bucket;
    }

    public double percentile(double fraction) {
        long value = (long)((double)this.totalCount * (1.0 - fraction));
        if ((value -= this.overRange) < 0L) {
            return Double.POSITIVE_INFINITY;
        }
        for (int i = this.sampleCount.length - 1; i >= 0; --i) {
            if ((value -= (long)this.sampleCount[i]) >= 0L) continue;
            long bits = ((long)i + this.floor << 1) + 1L << 51 - this.fractionBits;
            return Double.longBitsToDouble(bits);
        }
        return 1.0;
    }

    public static double[] percentilesFor(long count) {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(0.5);
        values.add(0.9);
        values.add(0.99);
        if (count > 10000L) {
            values.add(0.997);
            if (count > 100000L) {
                values.add(0.9990000000000001);
                if (count > 1000000L) {
                    values.add(0.9997);
                    if (count > 2000000L) {
                        values.add(0.9998999999999999);
                    }
                }
            }
        }
        values.add(1.0);
        return values.stream().mapToDouble(d -> d).toArray();
    }

    @NotNull
    public double[] getPercentiles() {
        return this.getPercentiles(Histogram.percentilesFor(this.totalCount));
    }

    @NotNull
    public double[] getPercentiles(double[] percentileFor) {
        return DoubleStream.of(percentileFor).map(this::percentile).toArray();
    }

    @NotNull
    public String toMicrosFormat() {
        return this.toMicrosFormat(t -> t / 1000.0);
    }

    @NotNull
    public String toMicrosFormat(@NotNull DoubleFunction<Double> toMicros) {
        if (this.totalCount < 1000000L) {
            return "50/90 99/99.9 99.99 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.99))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
        }
        if (this.totalCount < 10000000L) {
            return "50/90 99/99.9 99.99/99.999 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.99))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9999))) + " / " + this.p(toMicros.apply(this.percentile(0.99999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
        }
        return "50/90 99/99.9 99.99/99.999 99.9999/worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.99))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9999))) + " / " + this.p(toMicros.apply(this.percentile(0.99999))) + "  " + this.p(toMicros.apply(this.percentile(0.999999))) + " / " + this.p(toMicros.apply(this.percentile(1.0)));
    }

    @NotNull
    public String toLongMicrosFormat() {
        return this.toLongMicrosFormat(t -> t / 1000.0);
    }

    @NotNull
    public String toLongMicrosFormat(@NotNull DoubleFunction<Double> toMicros) {
        if (this.totalCount < 1000000L) {
            return "50/90 97/99 99.7/99.9 99.97/99.99 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.97))) + " / " + this.p(toMicros.apply(this.percentile(0.99))) + "  " + this.p(toMicros.apply(this.percentile(0.997))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9997))) + " / " + this.p(toMicros.apply(this.percentile(0.9999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
        }
        if (this.totalCount < 10000000L) {
            return "50/90 97/99 99.7/99.9 99.97/99.99 99.997/99.999 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.97))) + " / " + this.p(toMicros.apply(this.percentile(0.99))) + "  " + this.p(toMicros.apply(this.percentile(0.997))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9997))) + " / " + this.p(toMicros.apply(this.percentile(0.9999))) + "  " + this.p(toMicros.apply(this.percentile(0.99997))) + " / " + this.p(toMicros.apply(this.percentile(0.99999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
        }
        return "50/90 97/99 99.7/99.9 99.97/99.99 99.997/99.999 99.9997/99.9999 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.97))) + " / " + this.p(toMicros.apply(this.percentile(0.99))) + "  " + this.p(toMicros.apply(this.percentile(0.997))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9997))) + " / " + this.p(toMicros.apply(this.percentile(0.9999))) + "  " + this.p(toMicros.apply(this.percentile(0.99997))) + " / " + this.p(toMicros.apply(this.percentile(0.99999))) + "  " + this.p(toMicros.apply(this.percentile(0.999997))) + " / " + this.p(toMicros.apply(this.percentile(0.999999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
    }

    @NotNull
    private String p(double v) {
        return v < 0.1 ? F3.format(v) : (v < 1.0 ? F2.format(v) : (v < 10.0 ? F1.format(v) : (v < 1000.0 ? Long.toString(Math.round(v)) : String.format("%,d", Math.round(v / 10.0) * 10L))));
    }

    public long totalCount() {
        return this.totalCount;
    }

    public long floor() {
        return this.floor;
    }

    public void reset() {
        this.overRange = 0L;
        this.totalCount = 0L;
        Arrays.fill(this.sampleCount, 0);
    }

    @Override
    public void sampleNanos(long nanos) {
        this.sample(nanos);
    }
}

