/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.iter;

import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.iter.TierRecovery;
import net.openhft.chronicle.map.ChronicleHashCorruptionImpl;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.entry.ReplicatedMapEntryStages;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class ReplicatedTierRecovery
extends TierRecovery {
    @StageRef
    ReplicatedChronicleMapHolder<?, ?, ?> rh;
    @StageRef
    SegmentStages s;
    @StageRef
    ReplicatedMapEntryStages<?, ?> e;

    @Override
    public void removeDuplicatesInSegment(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        super.removeDuplicatesInSegment(corruptionListener, corruption);
        this.recoverTierDeleted(corruptionListener, corruption);
        this.cleanupModificationIterationBits();
    }

    private void recoverTierDeleted(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        VanillaChronicleHash h2 = this.rh.h();
        CompactOffHeapLinearHashTable hl = h2.hashLookup;
        long hlAddr = this.s.tierBaseAddr;
        long deleted = 0L;
        long hlPos = 0L;
        do {
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            this.e.readExistingEntry(hl.value(hlEntry));
            if (!this.e.entryDeleted()) continue;
            ++deleted;
        } while ((hlPos = hl.step(hlPos)) != 0L);
        if (this.s.tierDeleted() != deleted) {
            long finalDeleted = deleted;
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.s.segmentIndex, () -> ChronicleHashCorruptionImpl.format("wrong deleted counter for tier with index {}, stored: {}, should be: {}", this.s.tierIndex, this.s.tierDeleted(), finalDeleted));
            this.s.tierDeleted(deleted);
        }
    }

    private void cleanupModificationIterationBits() {
        VanillaChronicleMap m3 = this.rh.m();
        ReplicatedChronicleMap.ModificationIterator[] its = ((ReplicatedChronicleMap)m3).acquireAllModificationIterators();
        ReusableBitSet freeList = this.s.freeList;
        long pos = 0L;
        while (pos < ((ReplicatedChronicleMap)m3).actualChunksPerSegmentTier) {
            long nextPos = freeList.nextSetBit(pos);
            if (nextPos > pos) {
                for (ReplicatedChronicleMap.ModificationIterator it : its) {
                    it.clearRange0(this.s.tierIndex, pos, nextPos);
                }
            }
            if (nextPos > 0L) {
                this.e.readExistingEntry(nextPos);
                if (this.e.entrySizeInChunks > 1) {
                    for (ReplicatedChronicleMap.ModificationIterator it : its) {
                        it.clearRange0(this.s.tierIndex, nextPos + 1L, nextPos + (long)this.e.entrySizeInChunks);
                    }
                }
                pos = nextPos + (long)this.e.entrySizeInChunks;
                continue;
            }
            for (ReplicatedChronicleMap.ModificationIterator it : its) {
                it.clearRange0(this.s.tierIndex, pos, ((ReplicatedChronicleMap)m3).actualChunksPerSegmentTier);
            }
        }
    }
}

