/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThrowingCallable;
import net.openhft.chronicle.threads.ExecutorFactory;
import net.openhft.chronicle.threads.VanillaExecutorFactory;
import org.jetbrains.annotations.NotNull;

public enum Threads {

    static final Field GROUP = Jvm.getField(Thread.class, "group");
    static ExecutorFactory executorFactory;

    public static ExecutorService acquireExecutorService(String name, int threads, boolean daemon) {
        return executorFactory.acquireExecutorService(name, threads, daemon);
    }

    public static ScheduledExecutorService acquireScheduledExecutorService(String name, boolean daemon) {
        return executorFactory.acquireScheduledExecutorService(name, daemon);
    }

    public static void executorFactory(ExecutorFactory executorFactory) {
        Threads.executorFactory = executorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    public static <R, T extends Throwable> R withThreadGroup(ThreadGroup tg, @NotNull ThrowingCallable<R, T> callable) throws T {
        Thread thread = Thread.currentThread();
        ThreadGroup tg0 = thread.getThreadGroup();
        Threads.setThreadGroup(thread, tg);
        try {
            R r = callable.call();
            return r;
        }
        finally {
            Threads.setThreadGroup(thread, tg0);
        }
    }

    @ForceInline
    public static void setThreadGroup(Thread thread, ThreadGroup tg) {
        try {
            GROUP.set(thread, tg);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static String threadGroupPrefix() {
        String threadGroupName = Thread.currentThread().getThreadGroup().getName();
        if (!threadGroupName.endsWith("/")) {
            threadGroupName = threadGroupName + "/";
        }
        return threadGroupName;
    }

    public static void shutdownDaemon(@NotNull ExecutorService service) {
        service.shutdownNow();
        try {
            boolean terminated = service.awaitTermination(10L, TimeUnit.MILLISECONDS);
            if (!terminated && !(terminated = service.awaitTermination(1L, TimeUnit.SECONDS))) {
                if (service instanceof ThreadPoolExecutor) {
                    Threads.warnRunningThreads(service);
                } else {
                    Jvm.warn().on(Threads.class, "*** FAILED TO TERMINATE " + service.toString());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void shutdown(@NotNull ExecutorService service, boolean daemon) {
        if (daemon) {
            Threads.shutdownDaemon(service);
        } else {
            Threads.shutdown(service);
        }
    }

    public static void shutdown(@NotNull ExecutorService service) {
        block5: {
            service.shutdown();
            try {
                if (service.awaitTermination(1L, TimeUnit.SECONDS)) break block5;
                service.shutdownNow();
                try {
                    if (service.awaitTermination(20L, TimeUnit.SECONDS)) break block5;
                    if (service instanceof ThreadPoolExecutor) {
                        Threads.warnRunningThreads(service);
                        break block5;
                    }
                    service.shutdownNow();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void warnRunningThreads(@NotNull ExecutorService service) {
        try {
            Field workers = ThreadPoolExecutor.class.getDeclaredField("workers");
            workers.setAccessible(true);
            Set objects = (Set)workers.get(service);
            for (Object o : objects) {
                Field thread = o.getClass().getDeclaredField("thread");
                thread.setAccessible(true);
                Thread t = (Thread)thread.get(o);
                if (t.getState() == Thread.State.TERMINATED) continue;
                StringBuilder b = new StringBuilder("**** THE FOLLOWING THREAD DID NOT SHUTDOWN ***\n");
                for (StackTraceElement s2 : t.getStackTrace()) {
                    b.append("  ").append(s2).append("\n");
                }
                Jvm.warn().on(Threads.class, b.toString());
            }
        }
        catch (Exception e) {
            Jvm.warn().on(Threads.class, e);
        }
    }

    static {
        ExecutorFactory instance = VanillaExecutorFactory.INSTANCE;
        try {
            String property = System.getProperty("threads.executor.factory");
            if (property != null) {
                instance = (ExecutorFactory)ObjectUtils.newInstance(Class.forName(property));
            }
        }
        catch (Exception e) {
            Jvm.warn().on(Threads.class, e);
        }
        executorFactory = instance;
    }
}

