/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.annotation.Annotation;
import net.openhft.chronicle.values.Range;

final class RangeImpl
implements Range {
    static final Range DEFAULT_BYTE_RANGE = new RangeImpl(-128L, 127L);
    static final Range DEFAULT_CHAR_RANGE = new RangeImpl(0L, 65535L);
    static final Range DEFAULT_SHORT_RANGE = new RangeImpl(-32768L, 32767L);
    static final Range DEFAULT_INT_RANGE = new RangeImpl(Integer.MIN_VALUE, Integer.MAX_VALUE);
    static final Range DEFAULT_LONG_RANGE = new RangeImpl(Long.MIN_VALUE, Long.MAX_VALUE);
    private final long min;
    private final long max;

    RangeImpl(long min2, long max) {
        this.min = min2;
        this.max = max;
    }

    @Override
    public long min() {
        return this.min;
    }

    @Override
    public long max() {
        return this.max;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Range.class;
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return other.min() == this.min && other.max() == this.max;
    }
}

